/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.streaming.compress.CompressionInfo;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDSerializer;

public class FileMessageHeader {
    public static FileMessageHeaderSerializer serializer = new FileMessageHeaderSerializer();
    public final UUID cfId;
    public final int sequenceNumber;
    public final String version;
    public final SSTableFormat.Type format;
    public final long estimatedKeys;
    public final List<Pair<Long, Long>> sections;
    public final CompressionInfo compressionInfo;
    private final CompressionMetadata compressionMetadata;
    public final long repairedAt;
    public final int sstableLevel;

    public FileMessageHeader(UUID cfId, int sequenceNumber, String version, SSTableFormat.Type format, long estimatedKeys, List<Pair<Long, Long>> sections, CompressionInfo compressionInfo, long repairedAt, int sstableLevel) {
        this.cfId = cfId;
        this.sequenceNumber = sequenceNumber;
        this.version = version;
        this.format = format;
        this.estimatedKeys = estimatedKeys;
        this.sections = sections;
        this.compressionInfo = compressionInfo;
        this.compressionMetadata = null;
        this.repairedAt = repairedAt;
        this.sstableLevel = sstableLevel;
    }

    public FileMessageHeader(UUID cfId, int sequenceNumber, String version, SSTableFormat.Type format, long estimatedKeys, List<Pair<Long, Long>> sections, CompressionMetadata compressionMetadata, long repairedAt, int sstableLevel) {
        this.cfId = cfId;
        this.sequenceNumber = sequenceNumber;
        this.version = version;
        this.format = format;
        this.estimatedKeys = estimatedKeys;
        this.sections = sections;
        this.compressionInfo = null;
        this.compressionMetadata = compressionMetadata;
        this.repairedAt = repairedAt;
        this.sstableLevel = sstableLevel;
    }

    public boolean isCompressed() {
        return this.compressionInfo != null || this.compressionMetadata != null;
    }

    public long size() {
        long size = 0L;
        if (this.compressionInfo != null) {
            for (CompressionMetadata.Chunk chunk : this.compressionInfo.chunks) {
                size += (long)(chunk.length + 4);
            }
        } else if (this.compressionMetadata != null) {
            size = this.compressionMetadata.getTotalSizeForSections(this.sections);
        } else {
            for (Pair<Long, Long> section : this.sections) {
                size += (Long)section.right - (Long)section.left;
            }
        }
        return size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Header (");
        sb.append("cfId: ").append(this.cfId);
        sb.append(", #").append(this.sequenceNumber);
        sb.append(", version: ").append(this.version);
        sb.append(", format: ").append((Object)this.format);
        sb.append(", estimated keys: ").append(this.estimatedKeys);
        sb.append(", transfer size: ").append(this.size());
        sb.append(", compressed?: ").append(this.isCompressed());
        sb.append(", repairedAt: ").append(this.repairedAt);
        sb.append(", level: ").append(this.sstableLevel);
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileMessageHeader that = (FileMessageHeader)o;
        return this.sequenceNumber == that.sequenceNumber && this.cfId.equals(that.cfId);
    }

    public int hashCode() {
        int result = this.cfId.hashCode();
        result = 31 * result + this.sequenceNumber;
        return result;
    }

    static class FileMessageHeaderSerializer {
        FileMessageHeaderSerializer() {
        }

        public CompressionInfo serialize(FileMessageHeader header, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(header.cfId, out, version);
            out.writeInt(header.sequenceNumber);
            out.writeUTF(header.version);
            if (version < 3 && header.format != SSTableFormat.Type.LEGACY && header.format != SSTableFormat.Type.BIG) {
                throw new UnsupportedOperationException("Can't stream non-legacy sstables to nodes < 2.2");
            }
            if (version >= 3) {
                out.writeUTF(header.format.name);
            }
            out.writeLong(header.estimatedKeys);
            out.writeInt(header.sections.size());
            for (Pair<Long, Long> section : header.sections) {
                out.writeLong((Long)section.left);
                out.writeLong((Long)section.right);
            }
            CompressionInfo compressionInfo = null;
            if (header.compressionMetadata != null) {
                compressionInfo = new CompressionInfo(header.compressionMetadata.getChunksForSections(header.sections), ((FileMessageHeader)header).compressionMetadata.parameters);
            }
            CompressionInfo.serializer.serialize(compressionInfo, out, version);
            out.writeLong(header.repairedAt);
            out.writeInt(header.sstableLevel);
            return compressionInfo;
        }

        public FileMessageHeader deserialize(DataInput in, int version) throws IOException {
            UUID cfId = UUIDSerializer.serializer.deserialize(in, 9);
            int sequenceNumber = in.readInt();
            String sstableVersion = in.readUTF();
            SSTableFormat.Type format = SSTableFormat.Type.LEGACY;
            if (version >= 3) {
                format = SSTableFormat.Type.validate(in.readUTF());
            }
            long estimatedKeys = in.readLong();
            int count = in.readInt();
            ArrayList<Pair<Long, Long>> sections = new ArrayList<Pair<Long, Long>>(count);
            for (int k = 0; k < count; ++k) {
                sections.add(Pair.create(in.readLong(), in.readLong()));
            }
            CompressionInfo compressionInfo = CompressionInfo.serializer.deserialize(in, 9);
            long repairedAt = in.readLong();
            int sstableLevel = in.readInt();
            return new FileMessageHeader(cfId, sequenceNumber, sstableVersion, format, estimatedKeys, sections, compressionInfo, repairedAt, sstableLevel);
        }

        public long serializedSize(FileMessageHeader header, int version) {
            long size = UUIDSerializer.serializer.serializedSize(header.cfId, version);
            size += (long)TypeSizes.NATIVE.sizeof(header.sequenceNumber);
            size += (long)TypeSizes.NATIVE.sizeof(header.version);
            if (version >= 3) {
                size += (long)TypeSizes.NATIVE.sizeof(header.format.name);
            }
            size += (long)TypeSizes.NATIVE.sizeof(header.estimatedKeys);
            size += (long)TypeSizes.NATIVE.sizeof(header.sections.size());
            for (Pair<Long, Long> section : header.sections) {
                size += (long)TypeSizes.NATIVE.sizeof((Long)section.left);
                size += (long)TypeSizes.NATIVE.sizeof((Long)section.right);
            }
            size += CompressionInfo.serializer.serializedSize(header.compressionInfo, version);
            return size += (long)TypeSizes.NATIVE.sizeof(header.sstableLevel);
        }
    }
}

