/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.thrift.ThriftCql2Factory;
import com.netflix.astyanax.thrift.ThriftCql3Factory;
import com.netflix.astyanax.thrift.ThriftCqlFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThriftCqlFactoryResolver {
    private static final Pattern VERSION_REGEX = Pattern.compile("^([0-9])+\\.([0-9])+(.*)");

    public static ThriftCqlFactory createFactory(AstyanaxConfiguration config) {
        Matcher m;
        if (config.getTargetCassandraVersion() != null && (m = VERSION_REGEX.matcher(config.getTargetCassandraVersion())).matches()) {
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            if (major > 1 || major == 1 && minor >= 2) {
                return new ThriftCql3Factory();
            }
        }
        return new ThriftCql2Factory();
    }
}

