/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.thrift.AbstractThriftCqlQuery;
import com.netflix.astyanax.thrift.ThriftColumnFamilyQueryImpl;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;

public class ThriftCqlQuery<K, C>
extends AbstractThriftCqlQuery<K, C> {
    ThriftCqlQuery(ThriftColumnFamilyQueryImpl<K, C> cfQuery, String cql) {
        super(cfQuery, cql);
    }

    @Override
    protected CqlPreparedResult prepare_cql_query(Cassandra.Client client) throws InvalidRequestException, TException {
        return client.prepare_cql_query(StringSerializer.get().toByteBuffer(this.cql), Compression.NONE);
    }

    @Override
    protected CqlResult execute_prepared_cql_query(Cassandra.Client client, int id, List<ByteBuffer> values) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        return client.execute_prepared_cql_query(id, values);
    }

    @Override
    protected CqlResult execute_cql_query(Cassandra.Client client) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        return client.execute_cql_query(StringSerializer.get().toByteBuffer(this.cql), this.useCompression ? Compression.GZIP : Compression.NONE);
    }
}

