/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.ext.serializer.ConventionSerializationContext;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.ObjectContext;
import org.apache.abdera.ext.serializer.SerializationContext;
import org.apache.abdera.ext.serializer.SerializationException;
import org.apache.abdera.ext.serializer.Serializer;
import org.apache.abdera.ext.serializer.annotation.Attribute;
import org.apache.abdera.ext.serializer.annotation.BaseURI;
import org.apache.abdera.ext.serializer.annotation.Extension;
import org.apache.abdera.ext.serializer.annotation.Language;
import org.apache.abdera.ext.serializer.annotation.Value;
import org.apache.abdera.ext.serializer.impl.ExtensionSerializer;
import org.apache.abdera.ext.serializer.impl.SimpleElementSerializer;
import org.apache.abdera.i18n.rfc4646.Lang;
import org.apache.abdera.writer.StreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSerializer
extends Serializer {
    public static final String DEFAULT = "##default";

    protected abstract void init(Object var1, ObjectContext var2, SerializationContext var3, Conventions var4);

    protected abstract void finish(Object var1, ObjectContext var2, SerializationContext var3, Conventions var4);

    protected void process(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
    }

    @Override
    public void serialize(Object source, ObjectContext objectContext, SerializationContext context) {
        Conventions conventions = ((ConventionSerializationContext)context).getConventions();
        this.init(source, objectContext, context, conventions);
        this.process(source, objectContext, context, conventions);
        this.finish(source, objectContext, context, conventions);
    }

    protected void writeTextValue(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        AccessibleObject accessor = objectContext.getAccessor(Value.class, conventions);
        Object value = null;
        if (accessor != null) {
            value = BaseSerializer.eval(accessor, source);
        }
        context.getStreamWriter().writeElementText(value != null ? BaseSerializer.toString(value) : BaseSerializer.toString(source));
    }

    protected void writeExtensions(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        AccessibleObject[] accessors;
        for (AccessibleObject accessor : accessors = objectContext.getAccessors(Extension.class, conventions)) {
            Object value = BaseSerializer.eval(accessor, source);
            ObjectContext valueContext = new ObjectContext(value, source, accessor);
            Extension extension = valueContext.getAnnotation(Extension.class);
            boolean simple = extension != null ? extension.simple() : false;
            Serializer ser = context.getSerializer(valueContext);
            if (ser == null) {
                QName qname;
                if (simple) {
                    qname = BaseSerializer.getQName(accessor);
                    ser = new SimpleElementSerializer(qname);
                } else {
                    ser = context.getSerializer(valueContext);
                    if (ser == null) {
                        qname = BaseSerializer.getQName(accessor);
                        ser = new ExtensionSerializer(qname);
                    }
                }
            }
            ser.serialize(value, valueContext, context);
        }
    }

    protected void writeAttributes(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        AccessibleObject[] accessors;
        this.writeCommon(source, objectContext, context, conventions);
        StreamWriter sw = context.getStreamWriter();
        for (AccessibleObject accessor : accessors = objectContext.getAccessors(Attribute.class, conventions)) {
            QName qname = BaseSerializer.getQName(accessor);
            Object value = BaseSerializer.eval(accessor, source);
            if (value == null) continue;
            sw.writeAttribute(qname, BaseSerializer.toString(value));
        }
    }

    protected boolean writeElement(Class<? extends Annotation> annotation, Serializer serializer, Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        AccessibleObject accessor = objectContext.getAccessor(annotation, conventions);
        if (accessor != null) {
            Object value = BaseSerializer.eval(accessor, source);
            ObjectContext valueContext = new ObjectContext(value, source, accessor);
            serializer.serialize(value, valueContext, context);
            return true;
        }
        return false;
    }

    protected void writeElements(Class<? extends Annotation> annotation, Serializer serializer, Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        AccessibleObject[] accessors;
        for (AccessibleObject accessor : accessors = objectContext.getAccessors(annotation, conventions)) {
            Object[] values;
            if (accessor == null) continue;
            Object value = BaseSerializer.eval(accessor, source);
            for (Object val : values = BaseSerializer.toArray(value)) {
                ObjectContext valueContext = new ObjectContext(val, source, accessor);
                serializer.serialize(val, valueContext, context);
            }
        }
    }

    public static Object eval(AccessibleObject accessor, Object parent) {
        try {
            if (accessor instanceof Field) {
                return ((Field)accessor).get(parent);
            }
            if (accessor instanceof Method) {
                return ((Method)accessor).invoke(parent, new Object[0]);
            }
            return null;
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    protected boolean hasAnnotation(AnnotatedElement item, Class<? extends Annotation> annotation) {
        return item.isAnnotationPresent(annotation);
    }

    protected void writeElement(StreamWriter sw, QName qname, String value) {
        sw.startElement(qname).writeElementText(value).endElement();
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        Object[] values = BaseSerializer.toArray(value);
        StringBuilder buf = new StringBuilder();
        for (int n = 0; n < values.length; ++n) {
            if (n > 0) {
                buf.append(", ");
            }
            buf.append(values[n].toString());
        }
        return buf.toString();
    }

    public static Object[] toArray(Object value) {
        if (value == null) {
            return new Object[0];
        }
        if (value.getClass().isArray()) {
            return (Object[])value;
        }
        if (value instanceof Collection) {
            return ((Collection)value).toArray();
        }
        if (value instanceof Map) {
            return ((Map)value).values().toArray();
        }
        if (value instanceof Dictionary) {
            ArrayList list = new ArrayList();
            Enumeration e = ((Dictionary)value).elements();
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
            return list.toArray();
        }
        if (value instanceof Iterator) {
            ArrayList list = new ArrayList();
            Iterator i = (Iterator)value;
            while (i.hasNext()) {
                list.add(i.next());
            }
            return list.toArray();
        }
        if (value instanceof Enumeration) {
            ArrayList list = new ArrayList();
            Enumeration e = (Enumeration)value;
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
            return list.toArray();
        }
        if (value instanceof Iterable) {
            ArrayList list = new ArrayList();
            Iterable v = (Iterable)value;
            Iterator i = v.iterator();
            while (i.hasNext()) {
                list.add(i.next());
            }
            return list.toArray();
        }
        return new Object[]{value};
    }

    protected static boolean isUndefined(String value) {
        return value == null || DEFAULT.equals(value);
    }

    protected static QName getQName(AccessibleObject accessor) {
        Extension ext = accessor.getAnnotation(Extension.class);
        if (ext != null) {
            return BaseSerializer.getQName(ext);
        }
        Attribute attr = accessor.getAnnotation(Attribute.class);
        if (attr != null) {
            return BaseSerializer.getQName(attr);
        }
        return new QName(accessor instanceof Method ? ((Method)accessor).getName() : ((Field)accessor).getName());
    }

    protected static QName getQName(Extension extension) {
        QName qname = null;
        if (extension != null) {
            if (BaseSerializer.isUndefined(extension.prefix()) && BaseSerializer.isUndefined(extension.ns()) && BaseSerializer.isUndefined(extension.name())) {
                qname = new QName(extension.ns(), extension.name(), extension.prefix());
            } else if (BaseSerializer.isUndefined(extension.prefix()) && !BaseSerializer.isUndefined(extension.ns()) && !BaseSerializer.isUndefined(extension.name())) {
                qname = new QName(extension.ns(), extension.name());
            } else if (!BaseSerializer.isUndefined(extension.name())) {
                qname = new QName(extension.name());
            }
        }
        return qname;
    }

    protected static QName getQName(Attribute attribute) {
        QName qname = null;
        if (attribute != null) {
            if (BaseSerializer.isUndefined(attribute.prefix()) && BaseSerializer.isUndefined(attribute.ns()) && BaseSerializer.isUndefined(attribute.name())) {
                qname = new QName(attribute.ns(), attribute.name(), attribute.prefix());
            } else if (BaseSerializer.isUndefined(attribute.prefix()) && !BaseSerializer.isUndefined(attribute.ns()) && !BaseSerializer.isUndefined(attribute.name())) {
                qname = new QName(attribute.ns(), attribute.name());
            } else if (!BaseSerializer.isUndefined(attribute.name())) {
                qname = new QName(attribute.name());
            }
        }
        return qname;
    }

    protected void writeCommon(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        Object value;
        Language _lang;
        Object value2;
        StreamWriter sw = context.getStreamWriter();
        String lang = null;
        AccessibleObject accessor = objectContext.getAccessor(Language.class, conventions);
        if (accessor != null && (value2 = BaseSerializer.eval(accessor, source)) != null) {
            lang = value2 instanceof Lang || value2 instanceof org.apache.abdera.i18n.lang.Lang ? value2.toString() : BaseSerializer.toString(value2);
        }
        if (lang == null && (_lang = objectContext.getAnnotation(Language.class)) != null && !_lang.value().equals(DEFAULT)) {
            lang = _lang.value();
        }
        if (lang != null) {
            sw.writeLanguage(lang);
        }
        String base = null;
        accessor = objectContext.getAccessor(BaseURI.class, conventions);
        if (accessor != null && (value = BaseSerializer.eval(accessor, source)) != null) {
            base = BaseSerializer.toString(value);
        }
        if (base != null) {
            sw.writeBase(base);
        }
    }
}

