/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob.osgi;

import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.FileBlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, name="org.apache.jackrabbit.oak.spi.blob.FileBlobStore")
public class FileBlobStoreService {
    public static final String NAME = "org.apache.jackrabbit.oak.spi.blob.FileBlobStore";
    private static final String PROP_HOME = "repository.home";
    private ServiceRegistration reg;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        String homeDir = FileBlobStoreService.lookup(context, PROP_HOME);
        if (homeDir != null) {
            this.log.info("Initializing the FileBlobStore with homeDir [{}]", (Object)homeDir);
        }
        FileBlobStore blobStore = new FileBlobStore(FilenameUtils.concat((String)homeDir, (String)"datastore"));
        PropertiesUtil.populate((Object)blobStore, config, (boolean)false);
        this.reg = context.getBundleContext().registerService(new String[]{BlobStore.class.getName(), GarbageCollectableBlobStore.class.getName()}, (Object)blobStore, null);
    }

    @Deactivate
    protected void deactivate() {
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    protected static String lookup(ComponentContext context, String property) {
        if (context.getBundleContext().getProperty(property) != null) {
            return context.getBundleContext().getProperty(property).toString();
        }
        if (context.getProperties().get(property) != null) {
            return context.getProperties().get(property).toString();
        }
        return null;
    }
}

