/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.logging.Log;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.ThreadFactory;

public class ConnectionTableNIO
extends BasicConnectionTable
implements Runnable {
    private ServerSocketChannel m_serverSocketChannel;
    private Selector m_acceptSelector;
    private WriteHandler[] m_writeHandlers;
    private int m_nextWriteHandler = 0;
    private final Object m_lockNextWriteHandler = new Object();
    private ReadHandler[] m_readHandlers;
    private int m_nextReadHandler = 0;
    private final Object m_lockNextReadHandler = new Object();
    private Executor m_requestProcessors;
    private volatile boolean serverStopping = false;
    private final List<Thread> m_backGroundThreads = new LinkedList<Thread>();
    private int m_reader_threads = 3;
    private int m_writer_threads = 3;
    private int m_processor_threads = 5;
    private int m_processor_minThreads = 5;
    private int m_processor_maxThreads = 5;
    private int m_processor_queueSize = 100;
    private long m_processor_keepAliveTime = Long.MAX_VALUE;
    private static final NullCallable NULLCALL = new NullCallable();

    public ConnectionTableNIO(int srv_port) throws Exception {
        this.srv_port = srv_port;
        this.start();
    }

    public ConnectionTableNIO(int srv_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.srv_port = srv_port;
        this.reaper_interval = reaper_interval;
        this.conn_expire_time = conn_expire_time;
        this.start();
    }

    public ConnectionTableNIO(BasicConnectionTable.Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port) throws Exception {
        this.setReceiver(r);
        this.external_addr = external_addr;
        this.external_port = external_port;
        this.bind_addr = bind_addr;
        this.srv_port = srv_port;
        this.max_port = max_port;
        this.use_reaper = true;
        this.start();
    }

    public ConnectionTableNIO(BasicConnectionTable.Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port, boolean doStart) throws Exception {
        this.setReceiver(r);
        this.external_addr = external_addr;
        this.external_port = external_port;
        this.bind_addr = bind_addr;
        this.srv_port = srv_port;
        this.max_port = max_port;
        this.use_reaper = true;
        if (doStart) {
            this.start();
        }
    }

    public ConnectionTableNIO(BasicConnectionTable.Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.setReceiver(r);
        this.bind_addr = bind_addr;
        this.external_addr = external_addr;
        this.external_port = external_port;
        this.srv_port = srv_port;
        this.max_port = max_port;
        this.reaper_interval = reaper_interval;
        this.conn_expire_time = conn_expire_time;
        this.use_reaper = true;
        this.start();
    }

    public ConnectionTableNIO(BasicConnectionTable.Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port, long reaper_interval, long conn_expire_time, boolean doStart) throws Exception {
        this.setReceiver(r);
        this.bind_addr = bind_addr;
        this.external_addr = external_addr;
        this.external_port = external_port;
        this.srv_port = srv_port;
        this.max_port = max_port;
        this.reaper_interval = reaper_interval;
        this.conn_expire_time = conn_expire_time;
        this.use_reaper = true;
        if (doStart) {
            this.start();
        }
    }

    public int getReaderThreads() {
        return this.m_reader_threads;
    }

    public void setReaderThreads(int m_reader_threads) {
        this.m_reader_threads = m_reader_threads;
    }

    public int getWriterThreads() {
        return this.m_writer_threads;
    }

    public void setWriterThreads(int m_writer_threads) {
        this.m_writer_threads = m_writer_threads;
    }

    public int getProcessorThreads() {
        return this.m_processor_threads;
    }

    public void setProcessorThreads(int m_processor_threads) {
        this.m_processor_threads = m_processor_threads;
    }

    public int getProcessorMinThreads() {
        return this.m_processor_minThreads;
    }

    public void setProcessorMinThreads(int m_processor_minThreads) {
        this.m_processor_minThreads = m_processor_minThreads;
    }

    public int getProcessorMaxThreads() {
        return this.m_processor_maxThreads;
    }

    public void setProcessorMaxThreads(int m_processor_maxThreads) {
        this.m_processor_maxThreads = m_processor_maxThreads;
    }

    public int getProcessorQueueSize() {
        return this.m_processor_queueSize;
    }

    public void setProcessorQueueSize(int m_processor_queueSize) {
        this.m_processor_queueSize = m_processor_queueSize;
    }

    public long getProcessorKeepAliveTime() {
        return this.m_processor_keepAliveTime;
    }

    public void setProcessorKeepAliveTime(long m_processor_keepAliveTime) {
        this.m_processor_keepAliveTime = m_processor_keepAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    BasicConnectionTable.Connection getConnection(Address dest) throws Exception {
        Map map = this.conns;
        synchronized (map) {
            Connection conn = (Connection)this.conns.get(dest);
            if (conn == null) {
                int idx;
                block23: {
                    SocketChannel sock_ch;
                    block22: {
                        InetSocketAddress destAddress = new InetSocketAddress(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
                        sock_ch = SocketChannel.open(destAddress);
                        sock_ch.socket().setTcpNoDelay(this.tcp_nodelay);
                        conn = new Connection(sock_ch, dest);
                        conn.sendLocalAddress(this.local_addr);
                        sock_ch.configureBlocking(false);
                        try {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("About to change new connection send buff size from " + sock_ch.socket().getSendBufferSize() + " bytes");
                            }
                            sock_ch.socket().setSendBufferSize(this.send_buf_size);
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Changed new connection send buff size to " + sock_ch.socket().getSendBufferSize() + " bytes");
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            if (!this.log.isErrorEnabled()) break block22;
                            this.log.error("exception setting send buffer size to " + this.send_buf_size + " bytes: " + ex);
                        }
                    }
                    try {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("About to change new connection receive buff size from " + sock_ch.socket().getReceiveBufferSize() + " bytes");
                        }
                        sock_ch.socket().setReceiveBufferSize(this.recv_buf_size);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Changed new connection receive buff size to " + sock_ch.socket().getReceiveBufferSize() + " bytes");
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (!this.log.isErrorEnabled()) break block23;
                        this.log.error("exception setting receive buffer size to " + this.send_buf_size + " bytes: " + ex);
                    }
                }
                Object object = this.m_lockNextWriteHandler;
                synchronized (object) {
                    idx = this.m_nextWriteHandler = (this.m_nextWriteHandler + 1) % this.m_writeHandlers.length;
                }
                conn.setupWriteHandler(this.m_writeHandlers[idx]);
                try {
                    object = this.m_lockNextReadHandler;
                    synchronized (object) {
                        idx = this.m_nextReadHandler = (this.m_nextReadHandler + 1) % this.m_readHandlers.length;
                    }
                    this.m_readHandlers[idx].add(conn);
                }
                catch (InterruptedException e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Thread (" + Thread.currentThread().getName() + ") was interrupted, closing connection", e);
                    }
                    conn.destroy();
                    throw e;
                }
                this.addConnection(dest, conn);
                this.notifyConnectionOpened(dest);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("created socket to " + dest);
                }
            }
            return conn;
        }
    }

    @Override
    public final void start() throws Exception {
        super.start();
        this.init();
        this.srv_sock = this.createServerSocket(this.srv_port, this.max_port);
        this.local_addr = this.external_addr != null ? new IpAddress(this.external_addr, this.external_port == 0 ? this.srv_sock.getLocalPort() : this.external_port) : (this.bind_addr != null ? new IpAddress(this.bind_addr, this.srv_sock.getLocalPort()) : new IpAddress(this.srv_sock.getLocalPort()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("server socket created on " + this.local_addr);
        }
        this.acceptor = this.getThreadFactory().newThread(this, "ConnectionTable.AcceptorThread");
        this.acceptor.setDaemon(true);
        this.acceptor.start();
        this.m_backGroundThreads.add(this.acceptor);
        if (this.use_reaper && this.reaper == null) {
            this.reaper = new BasicConnectionTable.Reaper();
            this.reaper.start();
        }
    }

    protected void init() throws Exception {
        if (this.getProcessorMaxThreads() <= 0) {
            this.m_requestProcessors = new Executor(){

                @Override
                public void execute(Runnable command) {
                    command.run();
                }
            };
        } else {
            ThreadPoolExecutor requestProcessors = new ThreadPoolExecutor(this.getProcessorMinThreads(), this.getProcessorMaxThreads(), this.getProcessorKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.getProcessorQueueSize()));
            requestProcessors.setThreadFactory(new java.util.concurrent.ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread new_thread = new Thread(runnable, "ConnectionTableNIO.Thread");
                    new_thread.setDaemon(true);
                    ConnectionTableNIO.this.m_backGroundThreads.add(new_thread);
                    return new_thread;
                }
            });
            requestProcessors.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(requestProcessors.getRejectedExecutionHandler()));
            this.m_requestProcessors = requestProcessors;
        }
        this.m_writeHandlers = WriteHandler.create(this.getThreadFactory(), this.getWriterThreads(), this.m_backGroundThreads, this.log);
        this.m_readHandlers = ReadHandler.create(this.getThreadFactory(), this.getReaderThreads(), this, this.m_backGroundThreads, this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        int i;
        super.stop();
        this.serverStopping = true;
        if (this.reaper != null) {
            this.reaper.stop();
        }
        if (this.m_acceptSelector != null) {
            this.m_acceptSelector.wakeup();
        }
        if (this.m_readHandlers != null) {
            for (i = 0; i < this.m_readHandlers.length; ++i) {
                try {
                    this.m_readHandlers[i].add(new Shutdown());
                    continue;
                }
                catch (InterruptedException e) {
                    this.log.error("Thread (" + Thread.currentThread().getName() + ") was interrupted, failed to shutdown selector", e);
                }
            }
        }
        if (this.m_writeHandlers != null) {
            for (i = 0; i < this.m_writeHandlers.length; ++i) {
                try {
                    this.m_writeHandlers[i].queue.put(new Shutdown());
                    this.m_writeHandlers[i].selector.wakeup();
                    continue;
                }
                catch (InterruptedException e) {
                    this.log.error("Thread (" + Thread.currentThread().getName() + ") was interrupted, failed to shutdown selector", e);
                }
            }
        }
        if (this.m_requestProcessors instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.m_requestProcessors).shutdownNow();
        }
        if (this.m_requestProcessors instanceof ThreadPoolExecutor) {
            try {
                ((ThreadPoolExecutor)this.m_requestProcessors).awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Map e = this.conns;
        synchronized (e) {
            for (Connection conn : this.conns.values()) {
                conn.destroy();
            }
            this.conns.clear();
        }
        while (!this.m_backGroundThreads.isEmpty()) {
            Thread t = this.m_backGroundThreads.remove(0);
            try {
                t.join();
            }
            catch (InterruptedException e2) {
                this.log.error("Thread (" + Thread.currentThread().getName() + ") was interrupted while waiting on thread " + t.getName() + " to finish.");
            }
        }
        this.m_backGroundThreads.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (this.m_serverSocketChannel.isOpen() && !this.serverStopping) {
            try {
                num = this.m_acceptSelector.select();
            }
            catch (IOException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn("Select operation on listening socket failed", e);
                continue;
            }
            if (num <= 0) continue;
            readyKeys = this.m_acceptSelector.selectedKeys();
            i = readyKeys.iterator();
            while (i.hasNext()) {
                block41: {
                    block40: {
                        key = i.next();
                        i.remove();
                        readyChannel = (ServerSocketChannel)key.channel();
                        try {
                            client_sock_ch = readyChannel.accept();
                        }
                        catch (IOException e) {
                            if (!this.log.isWarnEnabled()) continue;
                            this.log.warn("Attempt to accept new connection from listening socket failed", e);
                            continue;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("accepted connection, client_sock=" + client_sock_ch.socket());
                        }
                        try {
                            client_sock_ch.socket().setSendBufferSize(this.send_buf_size);
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error("exception setting send buffer size to " + this.send_buf_size + " bytes: ", ex);
                            }
                        }
                        catch (SocketException e) {
                            if (!this.log.isErrorEnabled()) break block40;
                            this.log.error("exception setting send buffer size to " + this.send_buf_size + " bytes: ", e);
                        }
                    }
                    try {
                        client_sock_ch.socket().setReceiveBufferSize(this.recv_buf_size);
                    }
                    catch (IllegalArgumentException ex) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("exception setting receive buffer size to " + this.send_buf_size + " bytes: ", ex);
                        }
                    }
                    catch (SocketException e) {
                        if (!this.log.isErrorEnabled()) break block41;
                        this.log.error("exception setting receive buffer size to " + this.recv_buf_size + " bytes: ", e);
                    }
                }
                conn = new Connection(client_sock_ch, null);
                try {
                    conn.peer_addr = peer_addr = conn.readPeerAddress(client_sock_ch.socket());
                    var9_19 = this.conns;
                    synchronized (var9_19) {
                        tmp = (Connection)this.conns.get(peer_addr);
                        if (tmp == null) ** GOTO lbl66
                        if (peer_addr.compareTo(this.local_addr) > 0) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("peer's address (" + peer_addr + ") is greater than our local address (" + this.local_addr + "), replacing our existing connection");
                            }
                            this.addConnection(peer_addr, conn);
                            tmp.destroy();
                            this.notifyConnectionOpened(peer_addr);
                        } else {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("peer's address (" + peer_addr + ") is smaller than our local address (" + this.local_addr + "), rejecting peer connection request");
                            }
                            conn.destroy();
                            continue;
lbl66:
                            // 1 sources

                            this.addConnection(peer_addr, conn);
                        }
                    }
                    this.notifyConnectionOpened(peer_addr);
                    client_sock_ch.configureBlocking(false);
                }
                catch (IOException e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Attempt to configure non-blocking mode failed", e);
                    }
                    conn.destroy();
                    continue;
                }
                catch (Exception e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Attempt to handshake with other peer failed", e);
                    }
                    conn.destroy();
                    continue;
                }
                var9_19 = this.m_lockNextWriteHandler;
                synchronized (var9_19) {
                    idx = this.m_nextWriteHandler = (this.m_nextWriteHandler + 1) % this.m_writeHandlers.length;
                }
                Connection.access$000(conn, this.m_writeHandlers[idx]);
                try {
                    var9_19 = this.m_lockNextReadHandler;
                    synchronized (var9_19) {
                        idx = this.m_nextReadHandler = (this.m_nextReadHandler + 1) % this.m_readHandlers.length;
                    }
                    ReadHandler.access$100(this.m_readHandlers[idx], conn);
                }
                catch (InterruptedException e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Attempt to configure read handler for accepted connection failed", e);
                    }
                    conn.destroy();
                }
            }
        }
        if (this.m_serverSocketChannel.isOpen()) {
            try {
                this.m_serverSocketChannel.close();
            }
            catch (Exception e) {
                this.log.error("exception closing server listening socket", e);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("acceptor thread terminated");
        }
    }

    protected ServerSocket createServerSocket(int start_port, int end_port) throws Exception {
        this.m_acceptSelector = Selector.open();
        this.m_serverSocketChannel = ServerSocketChannel.open();
        this.m_serverSocketChannel.configureBlocking(false);
        while (true) {
            try {
                InetSocketAddress sockAddr;
                if (this.bind_addr == null) {
                    sockAddr = new InetSocketAddress(start_port);
                    this.m_serverSocketChannel.socket().bind(sockAddr);
                    break;
                }
                sockAddr = new InetSocketAddress(this.bind_addr, start_port);
                this.m_serverSocketChannel.socket().bind(sockAddr, 20);
            }
            catch (BindException bind_ex) {
                if (start_port == end_port) {
                    throw (BindException)new BindException("No available port to bind to (start_port=" + start_port + ")").initCause(bind_ex);
                }
                ++start_port;
                continue;
            }
            catch (SocketException bind_ex) {
                if (start_port == end_port) {
                    throw (BindException)new BindException("No available port to bind to  (start_port=" + start_port + ")").initCause(bind_ex);
                }
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("Attempt to bind serversocket failed, port=" + start_port + ", bind addr=" + this.bind_addr, io_ex);
                }
                throw io_ex;
            }
            break;
        }
        this.srv_port = start_port;
        this.m_serverSocketChannel.register(this.m_acceptSelector, 16);
        return this.m_serverSocketChannel.socket();
    }

    protected void runRequest(Address addr, ByteBuffer buf) throws InterruptedException {
        this.m_requestProcessors.execute(new ExecuteTask(addr, buf));
    }

    public static class MyFuture
    extends FutureTask {
        public MyFuture() {
            super(NULLCALL);
        }

        protected void set(Object o) {
            super.set(o);
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
        }
    }

    private static class NullCallable
    implements Callable {
        private NullCallable() {
        }

        public Object call() {
            System.out.println("nullCallable.call invoked");
            return null;
        }
    }

    public static class WriteRequest {
        private final SocketChannel m_channel;
        private final ByteBuffer m_buffer;
        private final MyFuture m_callback;
        private final SelectorWriteHandler m_hdlr;

        WriteRequest(SocketChannel channel, ByteBuffer buffer, MyFuture callback, SelectorWriteHandler hdlr) {
            this.m_channel = channel;
            this.m_buffer = buffer;
            this.m_callback = callback;
            this.m_hdlr = hdlr;
        }

        SelectorWriteHandler getHandler() {
            return this.m_hdlr;
        }

        SocketChannel getChannel() {
            return this.m_channel;
        }

        ByteBuffer getBuffer() {
            return this.m_buffer;
        }

        MyFuture getCallback() {
            return this.m_callback;
        }
    }

    public static class SelectorWriteHandler {
        private final List<WriteRequest> m_writeRequests = new LinkedList<WriteRequest>();
        private boolean m_headerSent = false;
        private SocketChannel m_channel;
        private SelectionKey m_key;
        private Selector m_selector;
        private int m_bytesWritten = 0;
        private boolean m_enabled = false;
        private ByteBuffer m_headerBuffer;

        SelectorWriteHandler(SocketChannel channel, Selector selector, ByteBuffer headerBuffer) {
            this.m_channel = channel;
            this.m_selector = selector;
            this.m_headerBuffer = headerBuffer;
        }

        private void register(Selector selector, SocketChannel channel) throws ClosedChannelException {
            this.m_key = channel.register(selector, 0, this);
        }

        private boolean enable() {
            boolean rc = false;
            try {
                if (this.m_key == null) {
                    this.register(this.m_selector, this.m_channel);
                }
            }
            catch (ClosedChannelException e) {
                return rc;
            }
            if (!this.m_enabled) {
                rc = true;
                try {
                    this.m_key.interestOps(4);
                }
                catch (CancelledKeyException e) {
                    return false;
                }
                this.m_enabled = true;
            }
            return rc;
        }

        private void disable() {
            if (this.m_enabled) {
                try {
                    this.m_key.interestOps(0);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
                this.m_enabled = false;
            }
        }

        private void cancel() {
            this.m_key.cancel();
        }

        boolean add(WriteRequest entry) {
            this.m_writeRequests.add(entry);
            return this.enable();
        }

        WriteRequest getCurrentRequest() {
            return this.m_writeRequests.get(0);
        }

        SocketChannel getChannel() {
            return this.m_channel;
        }

        ByteBuffer getBuffer() {
            return this.getCurrentRequest().getBuffer();
        }

        MyFuture getCallback() {
            return this.getCurrentRequest().getCallback();
        }

        int getBytesWritten() {
            return this.m_bytesWritten;
        }

        void notifyError(Throwable error) {
            if (this.getCallback() != null) {
                this.getCallback().setException(error);
            }
        }

        void notifyObject(Object result) {
            if (this.getCallback() != null) {
                this.getCallback().set(result);
            }
        }

        boolean next() {
            boolean rc;
            this.m_headerSent = false;
            this.m_bytesWritten = 0;
            this.m_writeRequests.remove(0);
            boolean bl = rc = !this.m_writeRequests.isEmpty();
            if (!rc) {
                this.disable();
            }
            return rc;
        }

        int write() throws IOException {
            if (!this.m_headerSent) {
                this.m_headerSent = true;
                this.m_headerBuffer.clear();
                this.m_headerBuffer.putInt(this.getBuffer().remaining());
                this.m_headerBuffer.flip();
                do {
                    this.getChannel().write(this.m_headerBuffer);
                } while (this.m_headerBuffer.remaining() > 0);
            }
            this.m_bytesWritten += this.getChannel().write(this.getBuffer());
            return this.getBuffer().remaining();
        }
    }

    private static class WriteHandler
    implements Runnable {
        private final LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();
        private final Selector selector = this.initSelector();
        private int m_pendingChannels;
        private ByteBuffer m_headerBuffer = ByteBuffer.allocate(4);
        private final Log log;

        public WriteHandler(Log log) {
            this.log = log;
        }

        Selector initSelector() {
            try {
                return SelectorProvider.provider().openSelector();
            }
            catch (IOException e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(e.toString());
                }
                throw new IllegalStateException(e.getMessage());
            }
        }

        private static WriteHandler[] create(ThreadFactory f, int workerThreads, List<Thread> backGroundThreads, Log log) {
            WriteHandler[] handlers = new WriteHandler[workerThreads];
            for (int looper = 0; looper < workerThreads; ++looper) {
                handlers[looper] = new WriteHandler(log);
                Thread thread = f.newThread(handlers[looper], "nioWriteHandlerThread");
                thread.setDaemon(true);
                thread.start();
                backGroundThreads.add(thread);
            }
            return handlers;
        }

        private SelectorWriteHandler add(SocketChannel channel) {
            return new SelectorWriteHandler(channel, this.selector, this.m_headerBuffer);
        }

        private void write(SocketChannel channel, ByteBuffer buffer, MyFuture notification, SelectorWriteHandler hdlr) throws InterruptedException {
            this.queue.put(new WriteRequest(channel, buffer, notification, hdlr));
        }

        private static void close(SelectorWriteHandler entry) {
            entry.cancel();
        }

        private static void handleChannelError(SelectorWriteHandler entry, Throwable error) {
            do {
                if (error == null) continue;
                entry.notifyError(error);
            } while (entry.next());
            WriteHandler.close(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processWrite(Selector selector) {
            Object[] arr;
            Set<SelectionKey> keys = selector.selectedKeys();
            for (Object anArr : arr = keys.toArray()) {
                SelectionKey key = (SelectionKey)anArr;
                SelectorWriteHandler entry = (SelectorWriteHandler)key.attachment();
                boolean needToDecrementPendingChannels = false;
                try {
                    if (0 != entry.write()) continue;
                    entry.notifyObject(entry.getBytesWritten());
                    if (entry.next()) continue;
                    needToDecrementPendingChannels = true;
                }
                catch (IOException e) {
                    needToDecrementPendingChannels = true;
                    WriteHandler.handleChannelError(entry, e);
                }
                finally {
                    if (needToDecrementPendingChannels) {
                        --this.m_pendingChannels;
                    }
                }
            }
            keys.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (this.selector.isOpen()) {
                try {
                    WriteRequest queueEntry;
                    Object o;
                    while (null != (o = this.queue.poll(0L, TimeUnit.MILLISECONDS))) {
                        if (o instanceof Shutdown) {
                            try {
                                this.selector.close();
                                return;
                            }
                            catch (IOException e) {
                                if (!this.log.isTraceEnabled()) return;
                                this.log.trace("Write selector close operation failed", e);
                            }
                            return;
                        }
                        queueEntry = (WriteRequest)o;
                        if (queueEntry.getHandler().add(queueEntry)) {
                            ++this.m_pendingChannels;
                        }
                        try {
                            if (this.selector.selectNow() <= 0) continue;
                            this.processWrite(this.selector);
                        }
                        catch (IOException e) {
                            if (!this.log.isErrorEnabled()) return;
                            this.log.error("SelectNow operation on write selector failed, didn't expect this to occur, please report this", e);
                            return;
                        }
                    }
                    if (this.m_pendingChannels == 0) {
                        o = this.queue.take();
                        if (o instanceof Shutdown) {
                            try {
                                this.selector.close();
                                return;
                            }
                            catch (IOException e) {
                                if (!this.log.isTraceEnabled()) return;
                                this.log.trace("Write selector close operation failed", e);
                            }
                            return;
                        }
                        queueEntry = (WriteRequest)o;
                        if (!queueEntry.getHandler().add(queueEntry)) continue;
                        ++this.m_pendingChannels;
                        continue;
                    }
                    try {
                        if (this.selector.select() <= 0) continue;
                        this.processWrite(this.selector);
                    }
                    catch (IOException e) {
                        if (!this.log.isErrorEnabled()) continue;
                        this.log.error("Failure while writing to socket", e);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error("Thread (" + Thread.currentThread().getName() + ") was interrupted", e);
                }
                catch (Throwable e) {
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error("Thread (" + Thread.currentThread().getName() + ") caught Throwable", e);
                }
            }
        }
    }

    class Connection
    extends BasicConnectionTable.Connection {
        private SocketChannel sock_ch;
        private WriteHandler m_writeHandler;
        private SelectorWriteHandler m_selectorWriteHandler;
        private final ConnectionReadState m_readState;
        private static final int HEADER_SIZE = 4;
        final ByteBuffer headerBuffer;

        Connection(SocketChannel s, Address peer_addr) {
            super(s.socket(), peer_addr);
            this.sock_ch = null;
            this.headerBuffer = ByteBuffer.allocate(4);
            this.sock_ch = s;
            this.m_readState = new ConnectionReadState(this);
            this.is_running = true;
        }

        private ConnectionReadState getReadState() {
            return this.m_readState;
        }

        private void setupWriteHandler(WriteHandler hdlr) {
            this.m_writeHandler = hdlr;
            this.m_selectorWriteHandler = hdlr.add(this.sock_ch);
        }

        @Override
        void doSend(byte[] buffie, int offset, int length) throws Exception {
            MyFuture result = new MyFuture();
            this.m_writeHandler.write(this.sock_ch, ByteBuffer.wrap(buffie, offset, length), result, this.m_selectorWriteHandler);
            Object ex = result.get();
            if (ex instanceof Exception) {
                if (ConnectionTableNIO.this.log.isErrorEnabled()) {
                    ConnectionTableNIO.this.log.error("failed sending message", (Exception)ex);
                }
                if (((Exception)ex).getCause() instanceof IOException) {
                    throw (IOException)((Exception)ex).getCause();
                }
                throw (Exception)ex;
            }
            result.get();
        }

        SocketChannel getSocketChannel() {
            return this.sock_ch;
        }

        @Override
        synchronized void closeSocket() {
            if (this.sock_ch != null) {
                try {
                    if (this.sock_ch.isConnected() && this.sock_ch.isOpen()) {
                        this.sock_ch.close();
                    }
                }
                catch (Exception e) {
                    ConnectionTableNIO.this.log.error("error closing socket connection", e);
                }
                this.sock_ch = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closed() {
            Address peerAddr = this.getPeerAddress();
            Map map = ConnectionTableNIO.this.conns;
            synchronized (map) {
                ConnectionTableNIO.this.conns.remove(peerAddr);
            }
            ConnectionTableNIO.this.notifyConnectionClosed(peerAddr);
        }
    }

    private class ConnectionReadState {
        private final Connection m_conn;
        private boolean m_headFinished = false;
        private ByteBuffer m_readBodyBuf = null;
        private final ByteBuffer m_readHeadBuf = ByteBuffer.allocate(4);

        public ConnectionReadState(Connection conn) {
            this.m_conn = conn;
        }

        ByteBuffer getReadBodyBuffer() {
            return this.m_readBodyBuf;
        }

        ByteBuffer getReadHeadBuffer() {
            return this.m_readHeadBuf;
        }

        void bodyFinished() {
            this.m_headFinished = false;
            this.m_readHeadBuf.clear();
            this.m_readBodyBuf = null;
            this.m_conn.updateLastAccessed();
        }

        int headFinished() {
            this.m_headFinished = true;
            this.m_readHeadBuf.flip();
            int messageSize = this.m_readHeadBuf.getInt();
            this.m_readBodyBuf = ByteBuffer.allocate(messageSize);
            this.m_conn.updateLastAccessed();
            return messageSize;
        }

        boolean isHeadFinished() {
            return this.m_headFinished;
        }
    }

    private class ExecuteTask
    implements Runnable {
        Address m_addr = null;
        ByteBuffer m_buf = null;

        public ExecuteTask(Address addr, ByteBuffer buf) {
            this.m_addr = addr;
            this.m_buf = buf;
        }

        @Override
        public void run() {
            ConnectionTableNIO.this.receive(this.m_addr, this.m_buf.array(), this.m_buf.arrayOffset(), this.m_buf.limit());
        }
    }

    private static class ReadHandler
    implements Runnable {
        private final Selector selector = this.initHandler();
        private final LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();
        private final ConnectionTableNIO connectTable;
        private final Log log;

        ReadHandler(ConnectionTableNIO ct, Log log) {
            this.connectTable = ct;
            this.log = log;
        }

        public Selector initHandler() {
            try {
                return Selector.open();
            }
            catch (IOException e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(e.toString());
                }
                throw new IllegalStateException(e.getMessage());
            }
        }

        private static ReadHandler[] create(ThreadFactory f, int workerThreads, ConnectionTableNIO ct, List<Thread> backGroundThreads, Log log) {
            ReadHandler[] handlers = new ReadHandler[workerThreads];
            for (int looper = 0; looper < workerThreads; ++looper) {
                handlers[looper] = new ReadHandler(ct, log);
                Thread thread = f.newThread(handlers[looper], "nioReadHandlerThread");
                thread.setDaemon(true);
                thread.start();
                backGroundThreads.add(thread);
            }
            return handlers;
        }

        private void add(Object conn) throws InterruptedException {
            this.queue.put(conn);
            this.wakeup();
        }

        private void wakeup() {
            this.selector.wakeup();
        }

        @Override
        public void run() {
            while (true) {
                Object o;
                block21: {
                    int events;
                    try {
                        events = this.selector.select();
                    }
                    catch (IOException e) {
                        if (!this.log.isWarnEnabled()) continue;
                        this.log.warn("Select operation on socket failed", e);
                        continue;
                    }
                    catch (ClosedSelectorException e) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn("Select operation on socket failed", e);
                        }
                        return;
                    }
                    if (events > 0) {
                        Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                        try {
                            Iterator<SelectionKey> i = readyKeys.iterator();
                            while (i.hasNext()) {
                                SelectionKey key = i.next();
                                i.remove();
                                Connection conn = (Connection)key.attachment();
                                if (conn == null || conn.getSocketChannel() == null) continue;
                                try {
                                    if (conn.getSocketChannel().isOpen()) {
                                        this.readOnce(conn);
                                        continue;
                                    }
                                    conn.closed();
                                }
                                catch (IOException e) {
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Read operation on socket failed", e);
                                    }
                                    key.cancel();
                                    conn.destroy();
                                    conn.closed();
                                }
                            }
                        }
                        catch (ConcurrentModificationException e) {
                            if (!this.log.isTraceEnabled()) break block21;
                            this.log.trace("Selection set changed", e);
                        }
                    }
                }
                try {
                    o = this.queue.poll(0L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("Thread (" + Thread.currentThread().getName() + ") was interrupted while polling queue", e);
                    continue;
                }
                if (null == o) continue;
                if (o instanceof Shutdown) {
                    block22: {
                        try {
                            this.selector.close();
                        }
                        catch (IOException e) {
                            if (!this.log.isTraceEnabled()) break block22;
                            this.log.trace("Read selector close operation failed", e);
                        }
                    }
                    return;
                }
                Connection conn = (Connection)o;
                SocketChannel sc = conn.getSocketChannel();
                try {
                    sc.register(this.selector, 1, conn);
                    continue;
                }
                catch (ClosedChannelException e) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Socket channel was closed while we were trying to register it to selector", e);
                    }
                    conn.destroy();
                    conn.closed();
                    continue;
                }
                break;
            }
        }

        private void readOnce(Connection conn) throws IOException {
            int size;
            ConnectionReadState readState = conn.getReadState();
            if (!readState.isHeadFinished() && 0 == (size = this.readHeader(conn))) {
                return;
            }
            if (this.readBody(conn) > 0) {
                return;
            }
            Address addr = conn.getPeerAddress();
            ByteBuffer buf = readState.getReadBodyBuffer();
            readState.bodyFinished();
            try {
                this.connectTable.runRequest(addr, buf);
            }
            catch (InterruptedException e) {
                this.log.error("Thread (" + Thread.currentThread().getName() + ") was interrupted while assigning executor to process read request", e);
            }
        }

        private int readHeader(Connection conn) throws IOException {
            ConnectionReadState readState = conn.getReadState();
            ByteBuffer headBuf = readState.getReadHeadBuffer();
            SocketChannel sc = conn.getSocketChannel();
            while (headBuf.remaining() > 0) {
                int num = sc.read(headBuf);
                if (-1 == num) {
                    throw new IOException("Peer closed socket");
                }
                if (0 != num) continue;
                return 0;
            }
            return readState.headFinished();
        }

        private int readBody(Connection conn) throws IOException {
            ByteBuffer bodyBuf = conn.getReadState().getReadBodyBuffer();
            SocketChannel sc = conn.getSocketChannel();
            while (bodyBuf.remaining() > 0) {
                int num = sc.read(bodyBuf);
                if (-1 == num) {
                    throw new IOException("Couldn't read from socket as peer closed the socket");
                }
                if (0 != num) continue;
                return bodyBuf.remaining();
            }
            bodyBuf.flip();
            return 0;
        }
    }

    private static class Shutdown {
        private Shutdown() {
        }
    }
}

