/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;

public final class BlockProximityFusion
implements BoilerpipeFilter {
    private final int maxBlocksDistance;
    public static final BlockProximityFusion MAX_DISTANCE_1 = new BlockProximityFusion(1, false);
    public static final BlockProximityFusion MAX_DISTANCE_1_CONTENT_ONLY = new BlockProximityFusion(1, true);
    private final boolean contentOnly;

    public BlockProximityFusion(int maxBlocksDistance, boolean contentOnly) {
        this.maxBlocksDistance = maxBlocksDistance;
        this.contentOnly = contentOnly;
    }

    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        int offset;
        TextBlock prevBlock;
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        boolean changes = false;
        if (this.contentOnly) {
            prevBlock = null;
            offset = 0;
            for (TextBlock tb : textBlocks) {
                ++offset;
                if (!tb.isContent()) continue;
                prevBlock = tb;
                break;
            }
            if (prevBlock == null) {
                return false;
            }
        } else {
            prevBlock = textBlocks.get(0);
            offset = 1;
        }
        ListIterator<TextBlock> it = textBlocks.listIterator(offset);
        while (it.hasNext()) {
            TextBlock block = (TextBlock)it.next();
            if (!block.isContent()) {
                prevBlock = block;
                continue;
            }
            int diffBlocks = block.getOffsetBlocksStart() - prevBlock.getOffsetBlocksEnd() - 1;
            if (diffBlocks <= this.maxBlocksDistance) {
                boolean ok = true;
                if (!(!this.contentOnly || prevBlock.isContent() && block.isContent())) {
                    ok = false;
                }
                if (ok) {
                    prevBlock.mergeNext(block);
                    it.remove();
                    changes = true;
                    continue;
                }
                prevBlock = block;
                continue;
            }
            prevBlock = block;
        }
        return changes;
    }
}

