/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.concurrent.AbortPolicy;
import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;
import com.liferay.portal.kernel.concurrent.TaskQueue;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandler;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandlerAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final int _RUNNING = 0;
    private static final int _SHUTDOWN = 1;
    private static final int _STOP = 2;
    private static final int _TERMINATED = 3;
    private volatile boolean _allowCoreThreadTimeout;
    private long _completedTaskCount;
    private volatile int _corePoolSize;
    private volatile long _keepAliveTime;
    private volatile int _largestPoolSize;
    private final ReentrantLock _mainLock = new ReentrantLock();
    private volatile int _maxPoolSize;
    private volatile int _poolSize;
    private volatile RejectedExecutionHandler _rejectedExecutionHandler;
    private volatile int _runState;
    private final TaskQueue<Runnable> _taskQueue;
    private final Condition _terminationCondition = this._mainLock.newCondition();
    private volatile ThreadFactory _threadFactory;
    private volatile ThreadPoolHandler _threadPoolHandler;
    private final Set<WorkerTask> _workerTasks;

    public ThreadPoolExecutor(int corePoolSize, int maxPoolSize) {
        this(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, false, Integer.MAX_VALUE, new AbortPolicy(), Executors.defaultThreadFactory(), new ThreadPoolHandlerAdapter());
    }

    public ThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, boolean allowCoreThreadTimeout, int maxQueueSize) {
        this(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, allowCoreThreadTimeout, maxQueueSize, new AbortPolicy(), Executors.defaultThreadFactory(), new ThreadPoolHandlerAdapter());
    }

    public ThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, boolean allowCoreThreadTimeout, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory, ThreadPoolHandler threadPoolHandler) {
        if (corePoolSize < 0 || maxPoolSize <= 0 || maxPoolSize < corePoolSize || keepAliveTime < 0L || maxQueueSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (rejectedExecutionHandler == null || threadFactory == null || threadPoolHandler == null) {
            throw new NullPointerException();
        }
        this._corePoolSize = corePoolSize;
        this._maxPoolSize = maxPoolSize;
        this._keepAliveTime = timeUnit.toNanos(keepAliveTime);
        this._allowCoreThreadTimeout = allowCoreThreadTimeout;
        this._rejectedExecutionHandler = rejectedExecutionHandler;
        this._threadFactory = threadFactory;
        this._threadPoolHandler = threadPoolHandler;
        this._taskQueue = new TaskQueue(maxQueueSize);
        this._workerTasks = new HashSet<WorkerTask>();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void adjustPoolSize(int newCorePoolSize, int newMaxPoolSize) {
        if (newCorePoolSize < 0 || newMaxPoolSize <= 0 || newMaxPoolSize < newCorePoolSize) {
            throw new IllegalArgumentException();
        }
        this._mainLock.lock();
        try {
            surplusCoreThreads = this._corePoolSize - newCorePoolSize;
            surplusMaxPoolSize = this._maxPoolSize - newMaxPoolSize;
            this._corePoolSize = newCorePoolSize;
            this._maxPoolSize = newMaxPoolSize;
            if (surplusCoreThreads > 0 && this._poolSize > this._corePoolSize || surplusMaxPoolSize > 0 && this._poolSize > this._maxPoolSize) {
                interruptCount = Math.max(surplusCoreThreads, surplusMaxPoolSize);
                for (WorkerTask workerTask : this._workerTasks) {
                    if (interruptCount <= 0) return;
                    if (!WorkerTask.access$0(workerTask)) continue;
                    --interruptCount;
                }
                return;
            }
            runnable = null;
            if (true) ** GOTO lbl21
            do {
                this._doAddWorkerThread(runnable);
lbl21:
                // 2 sources

                if (surplusCoreThreads++ >= 0 || this._poolSize >= this._corePoolSize) return;
            } while ((runnable = this._taskQueue.poll()) != null);
            return;
        }
        finally {
            this._mainLock.unlock();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long nanos = timeUnit.toNanos(timeout);
        this._mainLock.lock();
        try {
            while (true) {
                if (this._runState == 3) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                nanos = this._terminationCondition.awaitNanos(nanos);
            }
        }
        finally {
            this._mainLock.unlock();
        }
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        boolean[] hasWaiterMarker = new boolean[1];
        if (this._runState == 0 && this._taskQueue.offer(runnable, hasWaiterMarker)) {
            if (this._runState != 0) {
                if (this._taskQueue.remove(runnable)) {
                    this._rejectedExecutionHandler.rejectedExecution(runnable, this);
                }
                return;
            }
            if (!hasWaiterMarker[0]) {
                this._addWorkerThread();
            }
            return;
        }
        this._rejectedExecutionHandler.rejectedExecution(runnable, this);
    }

    public int getActiveCount() {
        this._mainLock.lock();
        try {
            int count = 0;
            for (WorkerTask workerTask : this._workerTasks) {
                if (!workerTask._isLocked()) continue;
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this._mainLock.unlock();
        }
    }

    public long getCompletedTaskCount() {
        this._mainLock.lock();
        try {
            long count = this._completedTaskCount;
            for (WorkerTask workerTask : this._workerTasks) {
                count += workerTask._localCompletedTaskCount;
            }
            long l = count;
            return l;
        }
        finally {
            this._mainLock.unlock();
        }
    }

    public int getCorePoolSize() {
        return this._corePoolSize;
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        return timeUnit.convert(this._keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getLargestPoolSize() {
        return this._largestPoolSize;
    }

    public int getMaxPoolSize() {
        return this._maxPoolSize;
    }

    public int getPendingTaskCount() {
        return this._taskQueue.size();
    }

    public int getPoolSize() {
        return this._poolSize;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this._rejectedExecutionHandler;
    }

    public int getRemainingTaskQueueCapacity() {
        return this._taskQueue.remainingCapacity();
    }

    public long getTaskCount() {
        this._mainLock.lock();
        try {
            long count = this._completedTaskCount;
            for (WorkerTask workerTask : this._workerTasks) {
                count += workerTask._localCompletedTaskCount;
                if (!workerTask._isLocked()) continue;
                ++count;
            }
            long l = count + (long)this._taskQueue.size();
            return l;
        }
        finally {
            this._mainLock.unlock();
        }
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public ThreadPoolHandler getThreadPoolHandler() {
        return this._threadPoolHandler;
    }

    public boolean isAllowCoreThreadTimeout() {
        return this._allowCoreThreadTimeout;
    }

    @Override
    public boolean isShutdown() {
        return this._runState != 0;
    }

    @Override
    public boolean isTerminated() {
        return this._runState == 3;
    }

    public boolean isTerminating() {
        return this._runState == 2;
    }

    public void setAllowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
        this._allowCoreThreadTimeout = allowCoreThreadTimeout;
    }

    public void setKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        this._keepAliveTime = timeUnit.toNanos(keepAliveTime);
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        if (rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this._rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this._threadFactory = threadFactory;
    }

    public void setThreadPoolHandler(ThreadPoolHandler threadPoolHandler) {
        if (threadPoolHandler == null) {
            throw new NullPointerException();
        }
        this._threadPoolHandler = threadPoolHandler;
    }

    @Override
    public void shutdown() {
        this._mainLock.lock();
        try {
            int state = this._runState;
            if (state < 1) {
                this._runState = 1;
            }
            for (WorkerTask workerTask : this._workerTasks) {
                workerTask._interruptIfWaiting();
            }
            this._tryTerminate();
        }
        finally {
            this._mainLock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this._mainLock.lock();
        try {
            int state = this._runState;
            if (state < 2) {
                this._runState = 2;
            }
            for (WorkerTask workerTask : this._workerTasks) {
                workerTask._thread.interrupt();
            }
            ArrayList<Runnable> runnables = new ArrayList<Runnable>();
            this._taskQueue.drainTo(runnables);
            this._tryTerminate();
            ArrayList<Runnable> arrayList = runnables;
            return arrayList;
        }
        finally {
            this._mainLock.unlock();
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    protected ReentrantLock getMainLock() {
        return this._mainLock;
    }

    protected TaskQueue<Runnable> getTaskQueue() {
        return this._taskQueue;
    }

    protected Set<WorkerTask> getWorkerTasks() {
        return this._workerTasks;
    }

    private void _addWorkerThread() {
        int runState = this._runState;
        int poolSize = this._poolSize;
        if (runState == 0 && poolSize < this._maxPoolSize || runState == 1 && poolSize == 0 && !this._taskQueue.isEmpty()) {
            this._mainLock.lock();
            try {
                Runnable runnable;
                runState = this._runState;
                poolSize = this._poolSize;
                if ((runState == 0 && poolSize < this._maxPoolSize || runState == 1 && poolSize == 0 && !this._taskQueue.isEmpty()) && (runnable = this._taskQueue.poll()) != null) {
                    this._doAddWorkerThread(runnable);
                }
            }
            finally {
                this._mainLock.unlock();
            }
        }
    }

    private void _doAddWorkerThread(Runnable runnable) {
        WorkerTask workerTask = new WorkerTask(runnable);
        this._workerTasks.add(workerTask);
        int poolSize = ++this._poolSize;
        if (poolSize > this._largestPoolSize) {
            this._largestPoolSize = poolSize;
        }
        workerTask._startWork();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Runnable _getTask(WorkerTask workerTask, boolean[] cleanUpMarker) {
        while (true) {
            try {
                while (true) {
                    int state;
                    if ((state = this._runState) >= 2) {
                        return null;
                    }
                    Runnable runnable = null;
                    runnable = state == 1 ? this._taskQueue.poll() : (this._poolSize > this._corePoolSize || this._allowCoreThreadTimeout ? this._taskQueue.poll(this._keepAliveTime, TimeUnit.NANOSECONDS) : this._taskQueue.take());
                    if (runnable != null) {
                        return runnable;
                    }
                    this._mainLock.lock();
                    try {
                        if (this._runState < 2 && (this._runState < 1 || !this._taskQueue.isEmpty()) && (!this._allowCoreThreadTimeout || this._poolSize <= 1 && !this._taskQueue.isEmpty()) && (this._allowCoreThreadTimeout || this._poolSize <= this._corePoolSize)) continue;
                        this._completedTaskCount += workerTask._localCompletedTaskCount;
                        this._workerTasks.remove(workerTask);
                        if (--this._poolSize == 0) {
                            this._tryTerminate();
                        }
                        cleanUpMarker[0] = true;
                        return null;
                    }
                    finally {
                        this._mainLock.unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void _tryTerminate() {
        if (this._poolSize == 0) {
            int state = this._runState;
            if (state == 2 || state == 1 && this._taskQueue.isEmpty()) {
                this._runState = 3;
                this._terminationCondition.signalAll();
                this._threadPoolHandler.terminated();
                return;
            }
            if (!this._taskQueue.isEmpty()) {
                this._doAddWorkerThread(this._taskQueue.poll());
            }
        }
    }

    private class WorkerTask
    extends AbstractQueuedSynchronizer
    implements Runnable {
        private volatile long _localCompletedTaskCount;
        private Runnable _runnable;
        private Thread _thread;

        public WorkerTask(Runnable runnable) {
            this._runnable = runnable;
        }

        @Override
        public void run() {
            boolean[] cleanUpMarker = new boolean[1];
            try {
                Runnable runnable = this._runnable;
                this._runnable = null;
                do {
                    if (runnable == null) continue;
                    this._runTask(runnable);
                    runnable = null;
                } while ((runnable = ThreadPoolExecutor.this._getTask(this, cleanUpMarker)) != null);
            }
            finally {
                if (!cleanUpMarker[0]) {
                    ThreadPoolExecutor.this._mainLock.lock();
                    try {
                        ThreadPoolExecutor threadPoolExecutor = ThreadPoolExecutor.this;
                        threadPoolExecutor._completedTaskCount = threadPoolExecutor._completedTaskCount + this._localCompletedTaskCount;
                        ThreadPoolExecutor.this._workerTasks.remove(this);
                        ThreadPoolExecutor threadPoolExecutor2 = ThreadPoolExecutor.this;
                        int n = threadPoolExecutor2._poolSize - 1;
                        threadPoolExecutor2._poolSize = n;
                        if (n == 0) {
                            ThreadPoolExecutor.this._tryTerminate();
                        }
                    }
                    finally {
                        ThreadPoolExecutor.this._mainLock.unlock();
                    }
                }
                ThreadPoolExecutor.this._threadPoolHandler.beforeThreadEnd(this._thread);
            }
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() == 1;
        }

        @Override
        protected boolean tryAcquire(int unused) {
            return this.compareAndSetState(0, 1);
        }

        @Override
        protected boolean tryRelease(int unused) {
            this.setState(0);
            return true;
        }

        private boolean _interruptIfWaiting() {
            if (!this._thread.isInterrupted() && this.tryAcquire(1)) {
                try {
                    this._thread.interrupt();
                    return true;
                }
                finally {
                    this._unlock();
                }
            }
            return false;
        }

        private boolean _isLocked() {
            return this.isHeldExclusively();
        }

        private void _lock() {
            this.acquire(1);
        }

        private void _runTask(Runnable task) {
            this._lock();
            try {
                if (ThreadPoolExecutor.this._runState < 2 && Thread.interrupted() && ThreadPoolExecutor.this._runState >= 2) {
                    this._thread.interrupt();
                }
                RuntimeException throwable = null;
                ThreadPoolExecutor.this._threadPoolHandler.beforeExecute(this._thread, task);
                try {
                    try {
                        task.run();
                        ++this._localCompletedTaskCount;
                    }
                    catch (RuntimeException re) {
                        throwable = re;
                        throw re;
                    }
                }
                finally {
                    ThreadPoolExecutor.this._threadPoolHandler.afterExecute(task, throwable);
                }
            }
            finally {
                this._unlock();
            }
        }

        private void _startWork() {
            this._thread = ThreadPoolExecutor.this._threadFactory.newThread(this);
            ThreadPoolExecutor.this._threadPoolHandler.beforeThreadStart(this._thread);
            this._thread.start();
        }

        private void _unlock() {
            this.release(1);
        }
    }
}

