/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.mailbox;

import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.mailbox.MailboxException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MailboxUtil {
    private static final boolean _INTRABAND_MAILBOX_REAPER_THREAD_ENABLED = GetterUtil.getBoolean(PropsUtil.get("intraband.mailbox.reaper.thread.enabled"));
    private static final long _INTRABAND_MAILBOX_STORAGE_LIFE = GetterUtil.getLong(PropsUtil.get("intraband.mailbox.storage.life"));
    private static final Map<Long, ByteBuffer> _mailMap = new ConcurrentHashMap<Long, ByteBuffer>();
    private static final BlockingQueue<ReceiptStub> _overdueMailQueue = new DelayQueue<ReceiptStub>();
    private static final AtomicLong _receiptGenerator = new AtomicLong();

    static {
        if (_INTRABAND_MAILBOX_REAPER_THREAD_ENABLED) {
            OverdueMailReaperThread thread = new OverdueMailReaperThread(MailboxUtil.class.getName());
            thread.setContextClassLoader(MailboxUtil.class.getClassLoader());
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static ByteBuffer receiveMail(long receipt) {
        ByteBuffer byteBuffer = _mailMap.remove(receipt);
        _overdueMailQueue.remove(new ReceiptStub(receipt));
        if (!_INTRABAND_MAILBOX_REAPER_THREAD_ENABLED) {
            MailboxUtil._pollingCleanup();
        }
        return byteBuffer;
    }

    public static long sendMail(RegistrationReference registrationReference, ByteBuffer byteBuffer) throws MailboxException {
        Intraband intraband = registrationReference.getIntraband();
        try {
            SystemDataType systemDataType = SystemDataType.MAILBOX;
            Datagram responseDatagram = intraband.sendSyncDatagram(registrationReference, Datagram.createRequestDatagram(systemDataType.getValue(), byteBuffer));
            byteBuffer = responseDatagram.getDataByteBuffer();
            return byteBuffer.getLong();
        }
        catch (Exception e) {
            throw new MailboxException(e);
        }
    }

    static long depositMail(ByteBuffer byteBuffer) {
        long receipt = _receiptGenerator.getAndIncrement();
        _mailMap.put(receipt, byteBuffer);
        _overdueMailQueue.offer(new ReceiptStub(receipt, System.nanoTime()));
        if (!_INTRABAND_MAILBOX_REAPER_THREAD_ENABLED) {
            MailboxUtil._pollingCleanup();
        }
        return receipt;
    }

    private static void _pollingCleanup() {
        ReceiptStub receiptStub = null;
        while ((receiptStub = (ReceiptStub)_overdueMailQueue.poll()) != null) {
            _mailMap.remove(receiptStub.getReceipt());
        }
    }

    private static class OverdueMailReaperThread
    extends Thread {
        public OverdueMailReaperThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ReceiptStub receiptStub = (ReceiptStub)_overdueMailQueue.take();
                        _mailMap.remove(receiptStub.getReceipt());
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private static class ReceiptStub
    implements Delayed {
        private final long _expireTime;
        private final long _receipt;

        public ReceiptStub(long receipt) {
            this(receipt, -1L);
        }

        public ReceiptStub(long receipt, long currentNanoTime) {
            this._expireTime = currentNanoTime + TimeUnit.MILLISECONDS.toNanos(_INTRABAND_MAILBOX_STORAGE_LIFE);
            this._receipt = receipt;
        }

        @Override
        public int compareTo(Delayed delayed) {
            ReceiptStub receiptStub = (ReceiptStub)delayed;
            return (int)(this._expireTime - receiptStub._expireTime);
        }

        public boolean equals(Object obj) {
            ReceiptStub receiptStub = (ReceiptStub)obj;
            return this._receipt == receiptStub._receipt;
        }

        public long getReceipt() {
            return this._receipt;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this._expireTime - System.nanoTime();
        }
    }
}

