/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletJSONUtil {
    public static void populatePortletJSONObject(HttpServletRequest request, String portletHTML, Portlet portlet, JSONObject jsonObject) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashSet<String> footerCssSet = new LinkedHashSet<String>();
        LinkedHashSet<String> footerJavaScriptSet = new LinkedHashSet<String>();
        LinkedHashSet<String> headerCssSet = new LinkedHashSet<String>();
        LinkedHashSet<String> headerJavaScriptSet = new LinkedHashSet<String>();
        boolean portletOnLayout = false;
        String rootPortletId = PortletJSONUtil._getRootPortletId(portlet);
        String portletId = portlet.getPortletId();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        for (Portlet layoutPortlet : layoutTypePortlet.getAllPortlets()) {
            String layoutPortletRootPortletId = PortletJSONUtil._getRootPortletId(layoutPortlet);
            if (!rootPortletId.equals(layoutPortletRootPortletId) || portletId.equals(layoutPortlet.getPortletId())) continue;
            portletOnLayout = true;
            break;
        }
        if (!portletOnLayout && portlet.isAjaxable()) {
            Portlet rootPortlet = portlet.getRootPortlet();
            for (String footerPortalCss : portlet.getFooterPortalCss()) {
                if (!HttpUtil.hasProtocol(footerPortalCss)) {
                    footerPortalCss = String.valueOf(PortalUtil.getPathContext()) + footerPortalCss;
                    footerPortalCss = PortalUtil.getStaticResourceURL(request, footerPortalCss, rootPortlet.getTimestamp());
                }
                footerCssSet.add(footerPortalCss);
            }
            for (String footerPortalJavaScript : portlet.getFooterPortalJavaScript()) {
                if (!HttpUtil.hasProtocol(footerPortalJavaScript)) {
                    footerPortalJavaScript = String.valueOf(PortalUtil.getPathContext()) + footerPortalJavaScript;
                    footerPortalJavaScript = PortalUtil.getStaticResourceURL(request, footerPortalJavaScript, rootPortlet.getTimestamp());
                }
                footerJavaScriptSet.add(footerPortalJavaScript);
            }
            for (String footerPortletCss : portlet.getFooterPortletCss()) {
                if (!HttpUtil.hasProtocol(footerPortletCss)) {
                    footerPortletCss = String.valueOf(portlet.getStaticResourcePath()) + footerPortletCss;
                    footerPortletCss = PortalUtil.getStaticResourceURL(request, footerPortletCss, rootPortlet.getTimestamp());
                }
                footerCssSet.add(footerPortletCss);
            }
            for (String footerPortletJavaScript : portlet.getFooterPortletJavaScript()) {
                if (!HttpUtil.hasProtocol(footerPortletJavaScript)) {
                    footerPortletJavaScript = String.valueOf(portlet.getStaticResourcePath()) + footerPortletJavaScript;
                    footerPortletJavaScript = PortalUtil.getStaticResourceURL(request, footerPortletJavaScript, rootPortlet.getTimestamp());
                }
                footerJavaScriptSet.add(footerPortletJavaScript);
            }
            for (String headerPortalCss : portlet.getHeaderPortalCss()) {
                if (!HttpUtil.hasProtocol(headerPortalCss)) {
                    headerPortalCss = String.valueOf(PortalUtil.getPathContext()) + headerPortalCss;
                    headerPortalCss = PortalUtil.getStaticResourceURL(request, headerPortalCss, rootPortlet.getTimestamp());
                }
                headerCssSet.add(headerPortalCss);
            }
            for (String headerPortalJavaScript : portlet.getHeaderPortalJavaScript()) {
                if (!HttpUtil.hasProtocol(headerPortalJavaScript)) {
                    headerPortalJavaScript = String.valueOf(PortalUtil.getPathContext()) + headerPortalJavaScript;
                    headerPortalJavaScript = PortalUtil.getStaticResourceURL(request, headerPortalJavaScript, rootPortlet.getTimestamp());
                }
                headerJavaScriptSet.add(headerPortalJavaScript);
            }
            for (String headerPortletCss : portlet.getHeaderPortletCss()) {
                if (!HttpUtil.hasProtocol(headerPortletCss)) {
                    headerPortletCss = String.valueOf(portlet.getStaticResourcePath()) + headerPortletCss;
                    headerPortletCss = PortalUtil.getStaticResourceURL(request, headerPortletCss, rootPortlet.getTimestamp());
                }
                headerCssSet.add(headerPortletCss);
            }
            for (String headerPortletJavaScript : portlet.getHeaderPortletJavaScript()) {
                if (!HttpUtil.hasProtocol(headerPortletJavaScript)) {
                    headerPortletJavaScript = String.valueOf(portlet.getStaticResourcePath()) + headerPortletJavaScript;
                    headerPortletJavaScript = PortalUtil.getStaticResourceURL(request, headerPortletJavaScript, rootPortlet.getTimestamp());
                }
                headerJavaScriptSet.add(headerPortletJavaScript);
            }
        }
        String footerCssPaths = JSONFactoryUtil.serialize(footerCssSet.toArray(new String[footerCssSet.size()]));
        jsonObject.put("footerCssPaths", JSONFactoryUtil.createJSONArray(footerCssPaths));
        String footerJavaScriptPaths = JSONFactoryUtil.serialize(footerJavaScriptSet.toArray(new String[footerJavaScriptSet.size()]));
        jsonObject.put("footerJavaScriptPaths", JSONFactoryUtil.createJSONArray(footerJavaScriptPaths));
        String headerCssPaths = JSONFactoryUtil.serialize(headerCssSet.toArray(new String[headerCssSet.size()]));
        jsonObject.put("headerCssPaths", JSONFactoryUtil.createJSONArray(headerCssPaths));
        String headerJavaScriptPaths = JSONFactoryUtil.serialize(headerJavaScriptSet.toArray(new String[headerJavaScriptSet.size()]));
        jsonObject.put("headerJavaScriptPaths", JSONFactoryUtil.createJSONArray(headerJavaScriptPaths));
        List markupHeadElements = (List)request.getAttribute("javax.portlet.markup.head.element");
        if (markupHeadElements != null) {
            jsonObject.put("markupHeadElements", StringUtil.merge(markupHeadElements, ""));
        }
        jsonObject.put("portletHTML", portletHTML);
        jsonObject.put("refresh", !portlet.isAjaxable());
    }

    public static void writeFooterPaths(HttpServletResponse response, JSONObject jsonObject) throws IOException {
        PortletJSONUtil._writePaths(response, jsonObject.getJSONArray("footerCssPaths"), jsonObject.getJSONArray("footerJavaScriptPaths"));
    }

    public static void writeHeaderPaths(HttpServletResponse response, JSONObject jsonObject) throws IOException {
        PortletJSONUtil._writePaths(response, jsonObject.getJSONArray("headerCssPaths"), jsonObject.getJSONArray("headerJavaScriptPaths"));
    }

    private static String _getRootPortletId(Portlet portlet) {
        Portlet rootPortlet = portlet.getRootPortlet();
        return rootPortlet.getPortletId();
    }

    private static void _writePaths(HttpServletResponse response, JSONArray cssPathsJSONArray, JSONArray javaScriptPathsJSONArray) throws IOException {
        String value;
        if (cssPathsJSONArray.length() == 0 && javaScriptPathsJSONArray.length() == 0) {
            return;
        }
        PrintWriter printWriter = response.getWriter();
        int i = 0;
        while (i < cssPathsJSONArray.length()) {
            value = cssPathsJSONArray.getString(i);
            printWriter.print("<link href=\"");
            printWriter.print(HtmlUtil.escape(value));
            printWriter.println("\" rel=\"stylesheet\" type=\"text/css\" />");
            ++i;
        }
        i = 0;
        while (i < javaScriptPathsJSONArray.length()) {
            value = javaScriptPathsJSONArray.getString(i);
            printWriter.print("<script src=\"");
            printWriter.print(HtmlUtil.escape(value));
            printWriter.println("\" type=\"text/javascript\"></script>");
            ++i;
        }
    }
}

