/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ExceptionProcessCallable;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ReturnProcessCallable;
import com.liferay.portal.kernel.process.log.ProcessOutputStream;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class ProcessExecutor {
    private static Log _log = LogFactoryUtil.getLog(ProcessExecutor.class);
    private static volatile ExecutorService _executorService;
    private static Set<Process> _managedProcesses;

    static {
        _managedProcesses = new ConcurrentHashSet<Process>();
    }

    public static <T extends Serializable> Future<T> execute(String classPath, List<String> arguments, ProcessCallable<? extends Serializable> processCallable) throws ProcessException {
        return ProcessExecutor.execute("java", classPath, arguments, processCallable);
    }

    public static <T extends Serializable> Future<T> execute(String classPath, ProcessCallable<? extends Serializable> processCallable) throws ProcessException {
        return ProcessExecutor.execute("java", classPath, Collections.<String>emptyList(), processCallable);
    }

    public static <T extends Serializable> Future<T> execute(String java, String classPath, List<String> arguments, ProcessCallable<? extends Serializable> processCallable) throws ProcessException {
        try {
            ArrayList<String> commands = new ArrayList<String>(arguments.size() + 4);
            commands.add(java);
            commands.add("-cp");
            commands.add(classPath);
            commands.addAll(arguments);
            commands.add(ProcessExecutor.class.getName());
            ProcessBuilder processBuilder = new ProcessBuilder(commands);
            Process process = processBuilder.start();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(process.getOutputStream());
            try {
                objectOutputStream.writeObject(processCallable);
            }
            finally {
                objectOutputStream.close();
            }
            ExecutorService executorService = ProcessExecutor._getExecutorService();
            SubprocessReactor subprocessReactor = new SubprocessReactor(process);
            try {
                Future<ProcessCallable<? extends Serializable>> futureResponseProcessCallable = executorService.submit(subprocessReactor);
                _managedProcesses.add(process);
                return new ProcessExecutionFutureResult(futureResponseProcessCallable, process);
            }
            catch (RejectedExecutionException ree) {
                process.destroy();
                throw new ProcessException("Cancelled execution because of a concurrent destroy", ree);
            }
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) throws ClassNotFoundException, IOException {
        PrintStream oldOutPrintStream = System.out;
        ObjectOutputStream objectOutputStream = null;
        ProcessOutputStream outProcessOutputStream = null;
        PrintStream printStream = oldOutPrintStream;
        synchronized (printStream) {
            oldOutPrintStream.flush();
            FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
            objectOutputStream = new ObjectOutputStream(new UnsyncBufferedOutputStream(fileOutputStream));
            outProcessOutputStream = new ProcessOutputStream(objectOutputStream, false);
            ProcessContext._setProcessOutputStream(outProcessOutputStream);
            PrintStream newOutPrintStream = new PrintStream(outProcessOutputStream, true);
            System.setOut(newOutPrintStream);
        }
        ProcessOutputStream errProcessOutputStream = new ProcessOutputStream(objectOutputStream, true);
        PrintStream errPrintStream = new PrintStream(errProcessOutputStream, true);
        System.setErr(errPrintStream);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(System.in);
            ProcessCallable processCallable = (ProcessCallable)objectInputStream.readObject();
            String logPrefixString = "[".concat(processCallable.toString()).concat("]");
            byte[] logPrefix = logPrefixString.getBytes("UTF-8");
            outProcessOutputStream.setLogPrefix(logPrefix);
            errProcessOutputStream.setLogPrefix(logPrefix);
            Object result = processCallable.call();
            System.out.flush();
            outProcessOutputStream.writeProcessCallable(new ReturnProcessCallable(result));
            outProcessOutputStream.flush();
        }
        catch (ProcessException pe) {
            errPrintStream.flush();
            errProcessOutputStream.writeProcessCallable(new ExceptionProcessCallable(pe));
            errProcessOutputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (_executorService == null) {
            return;
        }
        Class<ProcessExecutor> clazz = ProcessExecutor.class;
        synchronized (ProcessExecutor.class) {
            if (_executorService != null) {
                _executorService.shutdownNow();
                Iterator<Process> iterator = _managedProcesses.iterator();
                while (iterator.hasNext()) {
                    Process process = iterator.next();
                    process.destroy();
                    iterator.remove();
                }
                _managedProcesses.clear();
                _executorService = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService _getExecutorService() {
        if (_executorService != null) {
            return _executorService;
        }
        Class<ProcessExecutor> clazz = ProcessExecutor.class;
        synchronized (ProcessExecutor.class) {
            if (_executorService == null) {
                _executorService = Executors.newCachedThreadPool(new NamedThreadFactory(ProcessExecutor.class.getName(), 1, PortalClassLoaderUtil.getClassLoader()));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _executorService;
        }
    }

    private static class HeartbeatThread
    extends Thread {
        private volatile boolean _detach;
        private final long _interval;
        private final ProcessCallable<String> _pringBackProcessCallable;
        private final ShutdownHook _shutdownHook;

        public HeartbeatThread(String message, long interval, ShutdownHook shutdownHook) {
            if (shutdownHook == null) {
                throw new IllegalArgumentException("Shutdown hook is null");
            }
            this._interval = interval;
            this._shutdownHook = shutdownHook;
            this._pringBackProcessCallable = new PingbackProcessCallable(message);
            this.setDaemon(true);
            this.setName(HeartbeatThread.class.getSimpleName());
        }

        public void detach() {
            this._detach = true;
            this.interrupt();
        }

        @Override
        public void run() {
            ProcessOutputStream processOutputStream = ProcessContext.getProcessOutputStream();
            int shutdownCode = 0;
            Throwable shutdownThrowable = null;
            while (!this._detach) {
                try {
                    HeartbeatThread.sleep(this._interval);
                    processOutputStream.writeProcessCallable(this._pringBackProcessCallable);
                }
                catch (InterruptedException ie) {
                    if (this._detach) {
                        return;
                    }
                    shutdownThrowable = ie;
                    shutdownCode = 2;
                }
                catch (IOException ioe) {
                    shutdownThrowable = ioe;
                    shutdownCode = 1;
                }
                catch (Throwable throwable) {
                    shutdownThrowable = throwable;
                    shutdownCode = 3;
                }
                if (shutdownCode == 0) continue;
                this._detach = this._shutdownHook.shutdown(shutdownCode, shutdownThrowable);
            }
        }
    }

    private static class PingbackProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final String _message;

        public PingbackProcessCallable(String message) {
            this._message = message;
        }

        @Override
        public String call() {
            return this._message;
        }
    }

    public static class ProcessContext {
        private static ConcurrentMap<String, Object> _attributes = new ConcurrentHashMap<String, Object>();
        private static AtomicReference<HeartbeatThread> _heartbeatThreadReference = new AtomicReference();
        private static ProcessOutputStream _processOutputStream;

        public static boolean attach(String message, long interval, ShutdownHook shutdownHook) {
            HeartbeatThread heartbeatThread = new HeartbeatThread(message, interval, shutdownHook);
            boolean value = _heartbeatThreadReference.compareAndSet(null, heartbeatThread);
            if (value) {
                heartbeatThread.start();
            }
            return value;
        }

        public static void detach() throws InterruptedException {
            HeartbeatThread heartbeatThread = _heartbeatThreadReference.getAndSet(null);
            if (heartbeatThread != null) {
                heartbeatThread.detach();
                heartbeatThread.join();
            }
        }

        public static ConcurrentMap<String, Object> getAttributes() {
            return _attributes;
        }

        public static ProcessOutputStream getProcessOutputStream() {
            return _processOutputStream;
        }

        public static boolean isAttached() {
            HeartbeatThread attachThread = _heartbeatThreadReference.get();
            return attachThread != null;
        }

        private static void _setProcessOutputStream(ProcessOutputStream processOutputStream) {
            _processOutputStream = processOutputStream;
        }

        private ProcessContext() {
        }
    }

    private static class ProcessExecutionFutureResult<T>
    implements Future<T> {
        private final Future<ProcessCallable<?>> _future;
        private final Process _process;

        public ProcessExecutionFutureResult(Future<ProcessCallable<? extends Serializable>> future, Process process) {
            this._future = future;
            this._process = process;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this._future.isCancelled() || this._future.isDone()) {
                return false;
            }
            this._future.cancel(true);
            this._process.destroy();
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this._future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._future.isDone();
        }

        @Override
        public T get() throws ExecutionException, InterruptedException {
            ProcessCallable<?> processCallable = this._future.get();
            return this.get(processCallable);
        }

        @Override
        public T get(long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
            ProcessCallable<?> processCallable = this._future.get(timeout, timeUnit);
            return this.get(processCallable);
        }

        private T get(ProcessCallable<?> processCallable) throws ExecutionException {
            try {
                if (processCallable instanceof ReturnProcessCallable) {
                    return (T)processCallable.call();
                }
                ExceptionProcessCallable exceptionProcessCallable = (ExceptionProcessCallable)processCallable;
                throw exceptionProcessCallable.call();
            }
            catch (ProcessException pe) {
                throw new ExecutionException(pe);
            }
        }
    }

    public static interface ShutdownHook {
        public static final int BROKEN_PIPE_CODE = 1;
        public static final int INTERRUPTION_CODE = 2;
        public static final int UNKNOWN_CODE = 3;

        public boolean shutdown(int var1, Throwable var2);
    }

    private static class SubprocessReactor
    implements Callable<ProcessCallable<? extends Serializable>> {
        private final Process _process;

        public SubprocessReactor(Process process) {
            this._process = process;
        }

        @Override
        public ProcessCallable<? extends Serializable> call() throws Exception {
            ProcessCallable resultProcessCallable = null;
            UnsyncBufferedInputStream unsyncBufferedInputStream = new UnsyncBufferedInputStream(this._process.getInputStream());
            try {
                try {
                    ClassLoaderObjectInputStream objectInputStream = null;
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    while (true) {
                        try {
                            unsyncBufferedInputStream.mark(4);
                            objectInputStream = new ClassLoaderObjectInputStream(unsyncBufferedInputStream, PortalClassLoaderUtil.getClassLoader());
                            if (unsyncByteArrayOutputStream.size() > 0 && _log.isWarnEnabled()) {
                                _log.warn("Found corrupt leading log " + unsyncByteArrayOutputStream.toString());
                            }
                            unsyncByteArrayOutputStream = null;
                        }
                        catch (StreamCorruptedException streamCorruptedException) {
                            unsyncBufferedInputStream.reset();
                            unsyncByteArrayOutputStream.write(unsyncBufferedInputStream.read());
                            continue;
                        }
                        break;
                    }
                    while (true) {
                        ProcessCallable processCallable;
                        if ((processCallable = (ProcessCallable)objectInputStream.readObject()) instanceof ExceptionProcessCallable || processCallable instanceof ReturnProcessCallable) {
                            resultProcessCallable = processCallable;
                            continue;
                        }
                        Object returnValue = processCallable.call();
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug("Invoked generic process callable " + processCallable + " with return value " + returnValue);
                    }
                }
                catch (StreamCorruptedException sce) {
                    File file = File.createTempFile("corrupted-stream-dump-" + System.currentTimeMillis(), ".log");
                    _log.error("Dumping content of corrupted object input stream to " + file.getAbsolutePath(), sce);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    StreamUtil.transfer(unsyncBufferedInputStream, fileOutputStream);
                    throw new ProcessException("Corrupted object input stream", sce);
                }
                catch (EOFException eofe) {
                    throw new ProcessException("Subprocess piping back ended prematurely", eofe);
                }
            }
            catch (Throwable throwable) {
                try {
                    int exitCode = this._process.waitFor();
                    if (exitCode != 0) {
                        throw new ProcessException("Subprocess terminated with exit code " + exitCode);
                    }
                }
                catch (InterruptedException ie) {
                    this._process.destroy();
                    throw new ProcessException("Forcibly killed subprocess on interruption", ie);
                }
                _managedProcesses.remove(this._process);
                if (resultProcessCallable != null) {
                    return resultProcessCallable;
                }
                throw throwable;
            }
        }
    }
}

