/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.ReceiverKey;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.util.Date;

public class SchedulerEventMessageListenerWrapper
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(SchedulerEventMessageListenerWrapper.class);
    private String _groupName;
    private String _jobName;
    private MessageListener _messageListener;
    private String _messageListenerUUID;
    private ReceiverKey _receiverKey;

    public void afterPropertiesSet() {
        if (this._jobName.length() > SchedulerEngine.GROUP_NAME_MAX_LENGTH) {
            this._jobName = this._jobName.substring(0, SchedulerEngine.GROUP_NAME_MAX_LENGTH);
        }
        if (this._groupName.length() > SchedulerEngine.JOB_NAME_MAX_LENGTH) {
            this._groupName = this._groupName.substring(0, SchedulerEngine.JOB_NAME_MAX_LENGTH);
        }
        this._receiverKey = new ReceiverKey(this._jobName, this._groupName);
        if (this._messageListenerUUID == null) {
            this._messageListenerUUID = PortalUUIDUtil.generate();
        }
    }

    public String getMessageListenerUUID() {
        return this._messageListenerUUID;
    }

    @Override
    public void receive(Message message) throws MessageListenerException {
        ReceiverKey receiverKey;
        String destinationName = GetterUtil.getString(message.getString("DESTINATION_NAME"));
        if (destinationName.equals("liferay/scheduler_dispatch") && !this._receiverKey.equals(receiverKey = (ReceiverKey)message.get("RECEIVER_KEY"))) {
            return;
        }
        try {
            try {
                this._messageListener.receive(message);
            }
            catch (Exception e) {
                this.handleException(message, e);
                if (e instanceof MessageListenerException) {
                    throw (MessageListenerException)e;
                }
                throw new MessageListenerException(e);
            }
        }
        finally {
            block20: {
                TriggerState triggerState = null;
                if (message.getBoolean("DISABLE")) {
                    triggerState = TriggerState.COMPLETE;
                    if (destinationName.equals("liferay/scheduler_dispatch")) {
                        MessageBusUtil.unregisterMessageListener(destinationName, this);
                    }
                    String jobName = message.getString("JOB_NAME");
                    String groupName = message.getString("GROUP_NAME");
                    StorageType storageType = (StorageType)((Object)message.get("STORAGE_TYPE"));
                    try {
                        SchedulerEngineHelperUtil.delete(jobName, groupName, storageType);
                    }
                    catch (SchedulerException se) {
                        if (_log.isInfoEnabled()) {
                            _log.info("Unable to delete job " + jobName + " in group " + groupName, se);
                        }
                    }
                } else {
                    triggerState = TriggerState.NORMAL;
                }
                try {
                    SchedulerEngineHelperUtil.auditSchedulerJobs(message, triggerState);
                }
                catch (Exception e) {
                    if (!_log.isInfoEnabled()) break block20;
                    _log.info("Unable to send audit message", e);
                }
            }
        }
    }

    public void setClassName(String className) {
        this._groupName = className;
        this._jobName = className;
    }

    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    public void setJobName(String jobName) {
        this._jobName = jobName;
    }

    public void setMessageListener(MessageListener messageListener) {
        this._messageListener = messageListener;
    }

    public void setMessageListenerUUID(String messageListenerUUID) {
        this._messageListenerUUID = messageListenerUUID;
    }

    protected void handleException(Message message, Exception exception) {
        JobState jobState = (JobState)message.get("JOB_STATE");
        if (jobState != null) {
            jobState.addException(exception, new Date());
        }
    }
}

