/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.Type;

public class ExpressionAccessor
extends Expression {
    ExpressionAccessor(Expression left, Expression right) {
        super(99);
        this.nodes = new Expression[]{left, right};
    }

    public ColumnSchema getColumn() {
        return this.nodes[0].getColumn();
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].dataType == null) {
            throw Error.error(5567);
        }
        if (!this.nodes[0].dataType.isArrayType()) {
            throw Error.error(5563);
        }
        this.dataType = this.nodes[0].dataType.collectionBaseType();
        if (this.nodes[1].opType == 8) {
            this.nodes[1].dataType = Type.SQL_INTEGER;
        }
    }

    public Object getValue(Session session) {
        Object[] array = (Object[])this.nodes[0].getValue(session);
        if (array == null) {
            return null;
        }
        Number index = (Number)this.nodes[1].getValue(session);
        if (index == null) {
            return null;
        }
        if (index.intValue() < 1 || index.intValue() > array.length) {
            throw Error.error(3490);
        }
        return array[index.intValue() - 1];
    }

    public Object[] getUpdatedArray(Session session, Object[] array, Object value, boolean copy) {
        if (array == null) {
            throw Error.error(3413);
        }
        Number index = (Number)this.nodes[1].getValue(session);
        if (index == null) {
            throw Error.error(3490);
        }
        int i = index.intValue() - 1;
        if (i < 0) {
            throw Error.error(3490);
        }
        if (i >= this.nodes[0].dataType.arrayLimitCardinality()) {
            throw Error.error(3490);
        }
        Object[] newArray = array;
        if (i >= array.length) {
            newArray = new Object[i + 1];
            System.arraycopy(array, 0, newArray, 0, array.length);
        } else if (copy) {
            newArray = new Object[array.length];
            System.arraycopy(array, 0, newArray, 0, array.length);
        }
        newArray[i] = value;
        return newArray;
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        String left = ExpressionAccessor.getContextSQL(this.nodes[0]);
        sb.append(left).append('[');
        sb.append(this.nodes[1].getSQL()).append(']');
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("ARRAY ACCESS");
        if (this.getLeftNode() != null) {
            sb.append(" array=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.getRightNode() != null) {
            sb.append(" array_index=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }
}

