/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.Util;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.BlobInputStream;

public class JDBCBlobClient
implements Blob {
    BlobDataID blob;
    SessionInterface session;
    boolean isClosed;

    public synchronized long length() throws SQLException {
        try {
            return this.blob.length(this.session);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.blob.getBytes(this.session, pos - 1L, length);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized InputStream getBinaryStream() throws SQLException {
        return new BlobInputStream(this.session, this.blob, 0L, this.length());
    }

    public synchronized long position(byte[] pattern, long start) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, start, 0L)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.blob.position(this.session, pattern, start - 1L);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized long position(Blob pattern, long start) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Integer.MAX_VALUE, 0L, pattern.length())) {
            throw Util.outOfRangeArgument();
        }
        byte[] bytePattern = pattern.getBytes(1L, (int)pattern.length());
        return this.position(bytePattern, start);
    }

    public synchronized int setBytes(long pos, byte[] bytes) throws SQLException {
        throw Util.notSupported();
    }

    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw Util.notSupported();
    }

    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        throw Util.notSupported();
    }

    public synchronized void truncate(long len) throws SQLException {
        try {
            this.blob.truncate(this.session, len);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized void free() throws SQLException {
        this.isClosed = true;
    }

    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw Util.outOfRangeArgument();
        }
        return new BlobInputStream(this.session, this.blob, pos - 1L, length);
    }

    public JDBCBlobClient(SessionInterface session, BlobDataID blob) {
        this.session = session;
        this.blob = blob;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public BlobDataID getBlob() {
        return this.blob;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(1251);
        }
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }
}

