/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Enumeration;
import java.util.HashSet;
import org.hsqldb.lib.RefCapablePropertyResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingResourceBundle {
    protected boolean validated = false;
    protected Class<? extends Enum<?>> enumType;
    public static final int THROW_BEHAVIOR = 0;
    public static final int EMPTYSTRING_BEHAVIOR = 1;
    public static final int NOOP_BEHAVIOR = 2;
    protected RefCapablePropertyResourceBundle wrappedRCPRB;
    private int missingPropertyBehavior = 0;
    private int missingPosValueBehavior = 0;

    public static String resourceKeyFor(Enum<?> enumKey) {
        return enumKey.name().replace('_', '.');
    }

    public ValidatingResourceBundle(String baseName, Class<? extends Enum<?>> enumType) {
        this.enumType = enumType;
        try {
            this.wrappedRCPRB = RefCapablePropertyResourceBundle.getBundle(baseName, enumType.getClassLoader());
            this.validate();
        }
        catch (RuntimeException re) {
            System.err.println("Failed to initialize resource bundle: " + re);
            throw re;
        }
    }

    public String getString(Enum<?> key) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.wrappedRCPRB.getString(key.toString());
    }

    public String getString(Enum<?> key, String ... strings) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.wrappedRCPRB.getString(key.toString(), strings, this.missingPosValueBehavior);
    }

    public String getExpandedString(Enum<?> key) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.wrappedRCPRB.getExpandedString(key.toString(), this.missingPropertyBehavior);
    }

    public String getExpandedString(Enum<?> key, String ... strings) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.wrappedRCPRB.getExpandedString(key.toString(), strings, this.missingPropertyBehavior, this.missingPosValueBehavior);
    }

    public void setMissingPropertyBehavior(int missingPropertyBehavior) {
        this.missingPropertyBehavior = missingPropertyBehavior;
    }

    public void setMissingPosValueBehavior(int missingPosValueBehavior) {
        this.missingPosValueBehavior = missingPosValueBehavior;
    }

    public int getMissingPropertyBehavior() {
        return this.missingPropertyBehavior;
    }

    public int getMissingPosValueBehavior() {
        return this.missingPosValueBehavior;
    }

    public void validate() {
        if (this.validated) {
            return;
        }
        this.validated = true;
        HashSet<String> resKeysFromEls = new HashSet<String>();
        for (Enum<?> e : this.enumType.getEnumConstants()) {
            resKeysFromEls.add(e.toString());
        }
        Enumeration<String> allKeys = this.wrappedRCPRB.getKeys();
        while (allKeys.hasMoreElements()) {
            String val = allKeys.nextElement();
            this.wrappedRCPRB.getString(val);
            resKeysFromEls.remove(val);
        }
        if (resKeysFromEls.size() > 0) {
            throw new RuntimeException("Resource Bundle pre-validation failed.  Missing property with key:  " + resKeysFromEls);
        }
    }

    public String getString(Enum<?> key, int i1) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, Integer.toString(i1));
    }

    public String getString(Enum<?> key, int i1, int i2) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, Integer.toString(i1), Integer.toString(i2));
    }

    public String getString(Enum<?> key, int i1, int i2, int i3) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, Integer.toString(i1), Integer.toString(i2), Integer.toString(i3));
    }

    public String getString(Enum<?> key, int i1, String s2) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, Integer.toString(i1), s2);
    }

    public String getString(Enum<?> key, String s1, int i2) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, s1, Integer.toString(i2));
    }

    public String getString(Enum<?> key, int i1, int i2, String s3) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, Integer.toString(i1), Integer.toString(i2), s3);
    }

    public String getString(Enum<?> key, int i1, String s2, int i3) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, Integer.toString(i1), s2, Integer.toString(i3));
    }

    public String getString(Enum<?> key, String s1, int i2, int i3) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, s1, Integer.toString(i2), Integer.toString(i3));
    }

    public String getString(Enum<?> key, int i1, String s2, String s3) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, Integer.toString(i1), s2, s3);
    }

    public String getString(Enum<?> key, String s1, String s2, int i3) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, s1, s2, Integer.toString(i3));
    }

    public String getString(Enum<?> key, String s1, int i2, String s3) {
        if (!this.enumType.isInstance(key)) {
            throw new IllegalArgumentException("Key is a " + key.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + key);
        }
        return this.getString(key, s1, Integer.toString(i2), s3);
    }
}

