/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;

public class DataFileCacheSession
extends DataFileCache {
    public DataFileCacheSession(Database db, String baseFileName) {
        super(db, baseFileName);
    }

    protected void initParams(Database database, String baseFileName) {
        this.dataFileName = baseFileName + ".data.tmp";
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        this.cachedRowPadding = 64;
        this.cacheFileScale = 64;
        this.maxCacheRows = 2048;
        int cacheSizeScale = 10;
        int avgRowBytes = 1 << cacheSizeScale;
        this.maxCacheBytes = this.maxCacheRows * avgRowBytes;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.cacheFileScale;
        this.dataFile = null;
    }

    public void open(boolean readonly) {
        try {
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, false, 0);
            this.fileFreePosition = 32L;
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0L);
        }
        catch (Throwable t) {
            this.database.logger.logWarningEvent("Failed to open RA file", t);
            this.close(false);
            throw Error.error(t, 452, 52, new Object[]{t.toString(), this.dataFileName});
        }
    }

    public void close(boolean write) {
        this.writeLock.lock();
        try {
            block4: {
                try {
                    this.cache.clear();
                    if (this.dataFile == null) break block4;
                    this.dataFile.close();
                    this.dataFile = null;
                    this.fa.removeElement(this.dataFileName);
                }
                catch (Throwable t) {
                    this.database.logger.logWarningEvent("Failed to close RA file", t);
                    throw Error.error(t, 452, 53, new Object[]{t.toString(), this.dataFileName});
                }
            }
            Object var4_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }
}

