/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileNIO;

public final class ScaledRAFileHybrid
implements RandomAccessInterface {
    final Database database;
    final String fileName;
    final boolean isReadOnly;
    boolean wasNio;
    long maxLength = Long.MAX_VALUE;
    RandomAccessInterface store;

    public ScaledRAFileHybrid(Database database, String name, boolean readOnly) throws IOException {
        this.database = database;
        this.fileName = name;
        this.isReadOnly = readOnly;
        File fi = new File(name);
        long fileLength = fi.length();
        this.newStore(fileLength);
    }

    public long length() throws IOException {
        return this.store.length();
    }

    public void seek(long position) throws IOException {
        this.store.seek(position);
    }

    public long getFilePointer() throws IOException {
        return this.store.getFilePointer();
    }

    public int read() throws IOException {
        return this.store.read();
    }

    public void read(byte[] b, int offset, int length) throws IOException {
        this.store.read(b, offset, length);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.store.write(b, offset, length);
    }

    public int readInt() throws IOException {
        return this.store.readInt();
    }

    public void writeInt(int i) throws IOException {
        this.store.writeInt(i);
    }

    public long readLong() throws IOException {
        return this.store.readLong();
    }

    public void writeLong(long i) throws IOException {
        this.store.writeLong(i);
    }

    public void close() throws IOException {
        this.store.close();
    }

    public boolean isReadOnly() {
        return this.store.isReadOnly();
    }

    public boolean wasNio() {
        return this.wasNio;
    }

    public boolean ensureLength(long newLength) {
        if (newLength < this.maxLength && this.store.ensureLength(newLength)) {
            return true;
        }
        if (this.wasNio && !this.store.wasNio()) {
            return false;
        }
        try {
            this.newStore(newLength);
        }
        catch (IOException e) {
            return false;
        }
        return this.store.ensureLength(newLength);
    }

    public boolean setLength(long newLength) {
        return this.store.setLength(newLength);
    }

    public Database getDatabase() {
        return null;
    }

    public void synch() {
        this.store.synch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newStore(long requiredPosition) throws IOException {
        long currentPosition = 0L;
        if (this.store != null) {
            currentPosition = this.store.getFilePointer();
            this.store.synch();
            this.store.close();
        }
        if (this.wasNio) {
            this.maxLength = Long.MAX_VALUE;
        } else if (requiredPosition <= this.database.logger.propNioMaxSize) {
            if (requiredPosition >= 0x800000L) {
                try {
                    try {
                        this.store = new ScaledRAFileNIO(this.database, this.fileName, this.isReadOnly, requiredPosition, this.database.logger.propNioMaxSize);
                        this.store.seek(currentPosition);
                        this.wasNio = true;
                        Object var7_3 = null;
                        this.maxLength = Long.MAX_VALUE;
                        return;
                    }
                    catch (Throwable e) {
                        Object var7_4 = null;
                        this.maxLength = Long.MAX_VALUE;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    this.maxLength = Long.MAX_VALUE;
                    throw throwable;
                }
            } else {
                this.maxLength = 0x800000L;
            }
        }
        this.store = new ScaledRAFile(this.database, this.fileName, this.isReadOnly, true);
        this.store.seek(currentPosition);
    }
}

