/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.WikiException;
import org.jamwiki.WikiMessage;
import org.jamwiki.utils.SortedProperties;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.WikiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment {
    private static final WikiLogger logger = WikiLogger.getLogger(Environment.class.getName());
    public static final String PROP_BASE_COOKIE_EXPIRE = "cookie-expire";
    public static final String PROP_BASE_DEFAULT_TOPIC = "default-topic";
    public static final String PROP_BASE_FILE_DIR = "homeDir";
    public static final String PROP_BASE_INITIALIZED = "props-initialized";
    public static final String PROP_BASE_LOGO_IMAGE = "logo-image";
    public static final String PROP_BASE_META_DESCRIPTION = "meta-description";
    public static final String PROP_BASE_PERSISTENCE_TYPE = "persistenceType";
    public static final String PROP_BASE_SEARCH_ENGINE = "search-engine";
    public static final String PROP_BASE_WIKI_VERSION = "wiki-version";
    public static final String PROP_CACHE_INDIVIDUAL_SIZE = "cache-individual-size";
    public static final String PROP_CACHE_MAX_AGE = "cache-max-age";
    public static final String PROP_CACHE_MAX_IDLE_AGE = "cache-max-idle-age";
    public static final String PROP_CACHE_TOTAL_SIZE = "cache-total-size";
    public static final String PROP_DATE_PATTERN_DATE_AND_TIME = "date-pattern-date-and-time";
    public static final String PROP_DATE_PATTERN_DATE_ONLY = "date-pattern-date-only";
    public static final String PROP_DATE_PATTERN_TIME_ONLY = "date-pattern-time-only";
    public static final String PROP_DB_DRIVER = "driver";
    public static final String PROP_DB_PASSWORD = "db-password";
    public static final String PROP_DB_TYPE = "database-type";
    public static final String PROP_DB_URL = "url";
    public static final String PROP_DB_USERNAME = "db-user";
    public static final String PROP_DBCP_MAX_ACTIVE = "dbcp-max-active";
    public static final String PROP_DBCP_MAX_IDLE = "dbcp-max-idle";
    public static final String PROP_DBCP_MIN_EVICTABLE_IDLE_TIME = "dbcp-min-evictable-idle-time";
    public static final String PROP_DBCP_NUM_TESTS_PER_EVICTION_RUN = "dbcp-num-tests-per-eviction-run";
    public static final String PROP_DBCP_TEST_ON_BORROW = "dbcp-test-on-borrow";
    public static final String PROP_DBCP_TEST_ON_RETURN = "dbcp-test-on-return";
    public static final String PROP_DBCP_TEST_WHILE_IDLE = "dbcp-test-while-idle";
    public static final String PROP_DBCP_TIME_BETWEEN_EVICTION_RUNS = "dbcp-time-between-eviction-runs";
    public static final String PROP_DBCP_WHEN_EXHAUSTED_ACTION = "dbcp-when-exhausted-action";
    public static final String PROP_EMAIL_REPLY_ADDRESS = "reply-address";
    public static final String PROP_EMAIL_SMTP_HOST = "smtp-host";
    public static final String PROP_EMAIL_SMTP_PASSWORD = "smtp-password";
    public static final String PROP_EMAIL_SMTP_USERNAME = "smtp-username";
    public static final String PROP_ENCRYPTION_ALGORITHM = "encryption-algorithm";
    public static final String PROP_EXTERNAL_LINK_NEW_WINDOW = "external-link-new-window";
    public static final String PROP_FILE_BLACKLIST = "file-blacklist";
    public static final String PROP_FILE_BLACKLIST_TYPE = "file-blacklist-type";
    public static final String PROP_FILE_DIR_FULL_PATH = "file-dir-full-path";
    public static final String PROP_FILE_DIR_RELATIVE_PATH = "file-dir-relative-path";
    public static final String PROP_FILE_MAX_FILE_SIZE = "max-file-size";
    public static final String PROP_FILE_SERVER_URL = "file-server-url";
    public static final String PROP_FILE_WHITELIST = "file-whitelist";
    public static final String PROP_IMAGE_RESIZE_INCREMENT = "image-resize-increment";
    public static final String PROP_MAX_TOPIC_VERSION_EXPORT = "max-topic-version-export";
    public static final String PROP_PARSER_ALLOW_CAPITALIZATION = "allow-capitalization";
    public static final String PROP_PARSER_ALLOW_HTML = "allowHTML";
    public static final String PROP_PARSER_ALLOW_JAVASCRIPT = "allow-javascript";
    public static final String PROP_PARSER_ALLOW_TEMPLATES = "allow-templates";
    public static final String PROP_PARSER_CLASS = "parser";
    public static final String PROP_PARSER_DISPLAY_INTERWIKI_LINKS_INLINE = "parser-interwiki-links-inline";
    public static final String PROP_PARSER_DISPLAY_VIRTUALWIKI_LINKS_INLINE = "parser-virtualwiki-links-inline";
    public static final String PROP_PARSER_MAX_INCLUSIONS = "parser-max-inclusions";
    public static final String PROP_PARSER_MAXIMUM_INFINITE_LOOP_LIMIT = "parser-infinite-loop-limit";
    public static final String PROP_PARSER_MAX_PARSER_ITERATIONS = "parser-max-iterations";
    public static final String PROP_PARSER_MAX_TEMPLATE_DEPTH = "parser-max-template-depth";
    public static final String PROP_PARSER_SIGNATURE_DATE_PATTERN = "signature-date";
    public static final String PROP_PARSER_SIGNATURE_USER_PATTERN = "signature-user";
    public static final String PROP_PARSER_TOC = "allow-toc";
    public static final String PROP_PARSER_TOC_DEPTH = "toc-depth";
    public static final String PROP_PATTERN_INVALID_NAMESPACE_NAME = "pattern-namespace-name-invalid";
    public static final String PROP_PATTERN_INVALID_ROLE_NAME = "pattern-role-name-invalid";
    public static final String PROP_PATTERN_INVALID_TOPIC_NAME = "pattern-topic-name-invalid";
    public static final String PROP_PATTERN_VALID_USER_LOGIN = "pattern-login-valid";
    public static final String PROP_PATTERN_VALID_VIRTUAL_WIKI = "pattern-virtualwiki-valid";
    public static final String PROP_PRINT_NEW_WINDOW = "print-new-window";
    public static final String PROP_RECENT_CHANGES_NUM = "recent-changes-days";
    public static final String PROP_RSS_ALLOWED = "rss-allowed";
    public static final String PROP_RSS_TITLE = "rss-title";
    public static final String PROP_SERVER_URL = "server-url";
    public static final String PROP_SHARED_UPLOAD_VIRTUAL_WIKI = "shared-upload-virtual-wiki";
    public static final String PROP_SITE_NAME = "site-name";
    public static final String PROP_TOPIC_EDITOR = "default-editor";
    public static final String PROP_TOPIC_SPAM_FILTER = "use-spam-filter";
    public static final String PROP_TOPIC_USE_PREVIEW = "use-preview";
    public static final String PROP_TOPIC_USE_SHOW_CHANGES = "use-show-changes";
    public static final String PROP_VIRTUAL_WIKI_DEFAULT = "virtual-wiki-default";
    private static final String PROPERTY_FILE_NAME = System.getProperty("jamwiki.property.file", "jamwiki.properties");
    private static Environment ENVIRONMENT_INSTANCE = null;
    private Properties defaults = null;
    private SortedProperties props = null;

    private Environment() {
        this.initDefaultProperties();
        logger.debug("Default properties initialized: " + this.defaults.toString());
        this.props = Environment.loadProperties(PROPERTY_FILE_NAME, this.defaults);
        if ("true".equals(System.getProperty("jamwiki.override.file.properties"))) {
            this.overrideFromSystemProperties();
        }
        logger.debug("JAMWiki properties initialized: " + this.props.toString());
    }

    private void overrideFromSystemProperties() {
        logger.info("Overriding file properties with system properties.");
        Map<String, String> properties = Environment.propertiesToMap(this.props);
        for (String key : properties.keySet()) {
            String value = System.getProperty("jamwiki." + key);
            if (value == null) continue;
            this.props.setProperty(key, value);
            logger.info("Replaced property " + key + " with value: " + value);
        }
    }

    private static File findProperties(String filename) throws FileNotFoundException {
        File file = new File(filename);
        if (file.exists()) {
            return file;
        }
        return Environment.retrievePropertyFile(filename);
    }

    private void initDefaultProperties() {
        this.defaults = new Properties();
        this.defaults.setProperty(PROP_BASE_COOKIE_EXPIRE, "31104000");
        this.defaults.setProperty(PROP_BASE_DEFAULT_TOPIC, "StartingPoints");
        this.defaults.setProperty(PROP_BASE_FILE_DIR, "");
        this.defaults.setProperty(PROP_BASE_INITIALIZED, Boolean.FALSE.toString());
        this.defaults.setProperty(PROP_BASE_LOGO_IMAGE, "logo_oliver.gif");
        this.defaults.setProperty(PROP_BASE_META_DESCRIPTION, "");
        this.defaults.setProperty(PROP_BASE_PERSISTENCE_TYPE, "INTERNAL");
        this.defaults.setProperty(PROP_BASE_SEARCH_ENGINE, "org.jamwiki.search.LuceneSearchEngine");
        this.defaults.setProperty(PROP_BASE_WIKI_VERSION, "0.0.0");
        this.defaults.setProperty(PROP_CACHE_INDIVIDUAL_SIZE, "1500");
        this.defaults.setProperty(PROP_CACHE_MAX_AGE, "300");
        this.defaults.setProperty(PROP_CACHE_MAX_IDLE_AGE, "150");
        this.defaults.setProperty(PROP_CACHE_TOTAL_SIZE, "3000");
        this.defaults.setProperty(PROP_DATE_PATTERN_DATE_AND_TIME, "dd MMMM yyyy HH:mm");
        this.defaults.setProperty(PROP_DATE_PATTERN_DATE_ONLY, "dd MMMM yyyy");
        this.defaults.setProperty(PROP_DATE_PATTERN_TIME_ONLY, "HH:mm");
        this.defaults.setProperty(PROP_DB_DRIVER, "");
        this.defaults.setProperty(PROP_DB_PASSWORD, "");
        this.defaults.setProperty(PROP_DB_TYPE, "");
        this.defaults.setProperty(PROP_DB_URL, "");
        this.defaults.setProperty(PROP_DB_USERNAME, "");
        this.defaults.setProperty(PROP_DBCP_MAX_ACTIVE, "15");
        this.defaults.setProperty(PROP_DBCP_MAX_IDLE, "5");
        this.defaults.setProperty(PROP_DBCP_MIN_EVICTABLE_IDLE_TIME, "600");
        this.defaults.setProperty(PROP_DBCP_NUM_TESTS_PER_EVICTION_RUN, "5");
        this.defaults.setProperty(PROP_DBCP_TEST_ON_BORROW, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_DBCP_TEST_ON_RETURN, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_DBCP_TEST_WHILE_IDLE, Boolean.FALSE.toString());
        this.defaults.setProperty(PROP_DBCP_TIME_BETWEEN_EVICTION_RUNS, "120");
        this.defaults.setProperty(PROP_DBCP_WHEN_EXHAUSTED_ACTION, String.valueOf(2));
        this.defaults.setProperty(PROP_EMAIL_REPLY_ADDRESS, "");
        this.defaults.setProperty(PROP_EMAIL_SMTP_HOST, "");
        this.defaults.setProperty(PROP_EMAIL_SMTP_PASSWORD, "");
        this.defaults.setProperty(PROP_EMAIL_SMTP_USERNAME, "");
        this.defaults.setProperty(PROP_ENCRYPTION_ALGORITHM, "SHA-512");
        this.defaults.setProperty(PROP_EXTERNAL_LINK_NEW_WINDOW, Boolean.FALSE.toString());
        this.defaults.setProperty(PROP_FILE_BLACKLIST, "bat,bin,exe,htm,html,js,jsp,php,sh");
        this.defaults.setProperty(PROP_FILE_BLACKLIST_TYPE, String.valueOf(2));
        this.defaults.setProperty(PROP_FILE_MAX_FILE_SIZE, "2000000");
        this.defaults.setProperty(PROP_FILE_SERVER_URL, "");
        this.defaults.setProperty(PROP_FILE_WHITELIST, "bmp,gif,jpeg,jpg,pdf,png,properties,svg,txt,zip");
        this.defaults.setProperty(PROP_IMAGE_RESIZE_INCREMENT, "100");
        this.defaults.setProperty(PROP_MAX_TOPIC_VERSION_EXPORT, "200");
        this.defaults.setProperty(PROP_PARSER_ALLOW_CAPITALIZATION, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_PARSER_ALLOW_HTML, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_PARSER_ALLOW_JAVASCRIPT, Boolean.FALSE.toString());
        this.defaults.setProperty(PROP_PARSER_ALLOW_TEMPLATES, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_PARSER_CLASS, "org.jamwiki.parser.jflex.JFlexParser");
        this.defaults.setProperty(PROP_PARSER_DISPLAY_INTERWIKI_LINKS_INLINE, Boolean.FALSE.toString());
        this.defaults.setProperty(PROP_PARSER_DISPLAY_VIRTUALWIKI_LINKS_INLINE, Boolean.FALSE.toString());
        this.defaults.setProperty(PROP_PARSER_MAX_INCLUSIONS, "250");
        this.defaults.setProperty(PROP_PARSER_MAXIMUM_INFINITE_LOOP_LIMIT, "5");
        this.defaults.setProperty(PROP_PARSER_MAX_PARSER_ITERATIONS, "100");
        this.defaults.setProperty(PROP_PARSER_MAX_TEMPLATE_DEPTH, "100");
        this.defaults.setProperty(PROP_PARSER_SIGNATURE_DATE_PATTERN, "dd-MMM-yyyy HH:mm zzz");
        this.defaults.setProperty(PROP_PARSER_SIGNATURE_USER_PATTERN, "[[{0}|{4}]]");
        this.defaults.setProperty(PROP_PARSER_TOC, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_PARSER_TOC_DEPTH, "5");
        this.defaults.setProperty(PROP_PATTERN_INVALID_NAMESPACE_NAME, "([\\n\\r\\\\<>\\[\\]\\:_%/?&#]+)");
        this.defaults.setProperty(PROP_PATTERN_INVALID_ROLE_NAME, "([A-Za-z0-9_]+)");
        this.defaults.setProperty(PROP_PATTERN_INVALID_TOPIC_NAME, "([\\n\\r\\\\<>\\[\\]?#]+)");
        this.defaults.setProperty(PROP_PATTERN_VALID_USER_LOGIN, "([A-Za-z0-9_]+)");
        this.defaults.setProperty(PROP_PATTERN_VALID_VIRTUAL_WIKI, "([A-Za-z0-9_]+)");
        this.defaults.setProperty(PROP_PRINT_NEW_WINDOW, Boolean.FALSE.toString());
        this.defaults.setProperty(PROP_RECENT_CHANGES_NUM, "100");
        this.defaults.setProperty(PROP_RSS_ALLOWED, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_RSS_TITLE, "Wiki Recent Changes");
        this.defaults.setProperty(PROP_SERVER_URL, "");
        this.defaults.setProperty(PROP_SHARED_UPLOAD_VIRTUAL_WIKI, "");
        this.defaults.setProperty(PROP_SITE_NAME, "JAMWiki");
        this.defaults.setProperty(PROP_TOPIC_EDITOR, "toolbar");
        this.defaults.setProperty(PROP_TOPIC_SPAM_FILTER, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_TOPIC_USE_PREVIEW, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_TOPIC_USE_SHOW_CHANGES, Boolean.TRUE.toString());
        this.defaults.setProperty(PROP_VIRTUAL_WIKI_DEFAULT, "en");
        this.processDefaultUploadDirectories();
    }

    public static boolean getBooleanValue(String name) {
        return Boolean.valueOf(Environment.getValue(name));
    }

    public static String getDatePatternValue(String name, boolean date, boolean time) {
        String result = Environment.getValue(name);
        int style = -1;
        if (StringUtils.equalsIgnoreCase((String)result, (String)"SHORT")) {
            style = 3;
        } else if (StringUtils.equalsIgnoreCase((String)result, (String)"MEDIUM")) {
            style = 2;
        } else if (StringUtils.equalsIgnoreCase((String)result, (String)"LONG")) {
            style = 1;
        } else if (StringUtils.equalsIgnoreCase((String)result, (String)"FULL")) {
            style = 0;
        }
        if (style != -1) {
            if (date && time) {
                result = ((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(style, style)).toPattern();
            } else if (date) {
                result = ((SimpleDateFormat)SimpleDateFormat.getDateInstance(style)).toPattern();
            } else if (time) {
                result = ((SimpleDateFormat)SimpleDateFormat.getTimeInstance(style)).toPattern();
            }
        }
        return result;
    }

    public static Properties getInstance() {
        if (ENVIRONMENT_INSTANCE == null) {
            ENVIRONMENT_INSTANCE = new Environment();
        }
        return Environment.ENVIRONMENT_INSTANCE.props;
    }

    public static int getIntValue(String name) {
        int value = NumberUtils.toInt((String)Environment.getValue(name), (int)-1);
        if (value == -1) {
            logger.warn("Invalid integer property " + name + " with value " + value);
        }
        return value;
    }

    public static long getLongValue(String name) {
        long value = NumberUtils.toLong((String)Environment.getValue(name), (long)-1L);
        if (value == -1L) {
            logger.warn("Invalid long property " + name + " with value " + value);
        }
        return value;
    }

    public static String getValue(String name) {
        return Environment.getInstance().getProperty(name);
    }

    public static SortedProperties loadProperties(String propertyFile) {
        return Environment.loadProperties(propertyFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedProperties loadProperties(String propertyFile, Properties def) {
        SortedProperties properties = new SortedProperties();
        if (def != null) {
            properties = new SortedProperties(def);
        }
        File file = null;
        FileInputStream fis = null;
        try {
            file = Environment.findProperties(propertyFile);
            if (file == null) {
                logger.warn("Property file " + propertyFile + " does not exist");
            } else if (!file.exists()) {
                logger.warn("Property file " + file.getPath() + " does not exist");
            } else {
                logger.info("Loading properties from " + file.getPath());
                fis = new FileInputStream(file);
                properties.load(fis);
            }
        }
        catch (IOException e) {
            logger.error("Failure while trying to load properties file " + file.getPath(), e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    private static Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            map.put(key.toString(), properties.get(key).toString());
        }
        return map;
    }

    private void processDefaultUploadDirectories() {
        String defaultUploadDirectory = "";
        String defaultRelativeUploadDirectory = "";
        try {
            File webAppRoot = Utilities.getClassLoaderRoot();
            if (webAppRoot.getParentFile() != null && webAppRoot.getName().equalsIgnoreCase("classes") && (webAppRoot = webAppRoot.getParentFile()).getParentFile() != null && webAppRoot.getName().equalsIgnoreCase("web-inf")) {
                webAppRoot = webAppRoot.getParentFile();
            }
            defaultRelativeUploadDirectory = "/" + webAppRoot.getName() + "/upload/";
            defaultUploadDirectory = new File(webAppRoot, "upload").getPath();
        }
        catch (Throwable t) {
            logger.error("Failure while setting file upload defaults", t);
        }
        this.defaults.setProperty(PROP_FILE_DIR_FULL_PATH, defaultUploadDirectory);
        this.defaults.setProperty(PROP_FILE_DIR_RELATIVE_PATH, defaultRelativeUploadDirectory);
    }

    private static File retrievePropertyFile(String filename) {
        try {
            return Utilities.getClassLoaderFile(filename);
        }
        catch (FileNotFoundException e) {
            try {
                return new File(Utilities.getClassLoaderRoot(), filename);
            }
            catch (FileNotFoundException e2) {
                logger.error("Error while searching for resource " + filename, e2);
                return null;
            }
        }
    }

    public static void saveConfiguration() throws WikiException {
        try {
            Environment.saveProperties(PROPERTY_FILE_NAME, Environment.getInstance(), null);
            WikiUtil.dataHandlerInstance().writeConfiguration(Environment.propertiesToMap(Environment.getInstance()));
        }
        catch (IOException e) {
            throw new WikiException(new WikiMessage("error.unknown", e.getMessage()));
        }
        catch (DataAccessException e) {
            throw new WikiException(new WikiMessage("error.unknown", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(String propertyFile, Properties properties, String comments) throws IOException {
        File file = Environment.findProperties(propertyFile);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            properties.store(out, comments);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void setBooleanValue(String name, boolean value) {
        Environment.getInstance().setProperty(name, Boolean.toString(value));
    }

    public static void setIntValue(String name, int value) {
        Environment.getInstance().setProperty(name, Integer.toString(value));
    }

    public static void setValue(String name, String value) {
        if (value == null) {
            value = "";
        }
        Environment.getInstance().setProperty(name, value);
    }
}

