/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.model;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.model.Topic;
import org.jamwiki.model.WikiUser;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicVersion
implements Serializable {
    public static final int EDIT_NORMAL = 1;
    public static final int EDIT_MINOR = 2;
    public static final int EDIT_REVERT = 3;
    public static final int EDIT_MOVE = 4;
    public static final int EDIT_DELETE = 5;
    public static final int EDIT_PERMISSION = 6;
    public static final int EDIT_UNDELETE = 7;
    public static final int EDIT_IMPORT = 8;
    public static final int EDIT_UPLOAD = 9;
    private Integer authorId = null;
    private String authorDisplay = null;
    private int charactersChanged = 0;
    private String editComment = null;
    private Timestamp editDate = new Timestamp(System.currentTimeMillis());
    private int editType = 1;
    private boolean loggable = true;
    private Integer previousTopicVersionId = null;
    private boolean recentChangeAllowed = true;
    private int topicId = -1;
    private int topicVersionId = -1;
    private String versionContent = null;
    private List<String> versionParams = null;
    private static final WikiLogger logger = WikiLogger.getLogger(TopicVersion.class.getName());

    public TopicVersion() {
    }

    public TopicVersion(WikiUser user, String authorDisplay, String editComment, String versionContent, int charactersChanged) {
        if (user != null && user.getUserId() > 0) {
            this.authorId = user.getUserId();
        }
        this.authorDisplay = authorDisplay;
        this.editComment = editComment;
        this.versionContent = versionContent;
        this.charactersChanged = charactersChanged;
    }

    public void initializeVersionParams(Topic topic) {
        switch (this.editType) {
            case 5: 
            case 7: {
                this.addVersionParam(topic.getName());
                break;
            }
            case 4: {
                if (StringUtils.isBlank((String)topic.getRedirectTo())) break;
                this.addVersionParam(topic.getName());
                this.addVersionParam(topic.getRedirectTo());
                break;
            }
            case 6: {
                this.addVersionParam(topic.getName());
                break;
            }
            case 8: {
                this.addVersionParam(topic.getName());
                break;
            }
            case 9: {
                this.addVersionParam(topic.getName());
                break;
            }
        }
    }

    public Integer getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Integer authorId) {
        this.authorId = authorId;
    }

    public String getAuthorDisplay() {
        return this.authorDisplay;
    }

    public void setAuthorDisplay(String authorDisplay) {
        this.authorDisplay = authorDisplay;
    }

    public int getCharactersChanged() {
        return this.charactersChanged;
    }

    public void setCharactersChanged(int charactersChanged) {
        this.charactersChanged = charactersChanged;
    }

    public String getEditComment() {
        return this.editComment;
    }

    public void setEditComment(String editComment) {
        this.editComment = editComment;
    }

    public Timestamp getEditDate() {
        return this.editDate;
    }

    public void setEditDate(Timestamp editDate) {
        this.editDate = editDate;
    }

    public int getEditType() {
        return this.editType;
    }

    public void setEditType(int editType) {
        this.editType = editType;
    }

    public boolean isLoggable() {
        return this.loggable;
    }

    public void setLoggable(boolean loggable) {
        this.loggable = loggable;
    }

    public Integer getPreviousTopicVersionId() {
        return this.previousTopicVersionId;
    }

    public void setPreviousTopicVersionId(Integer previousTopicVersionId) {
        this.previousTopicVersionId = previousTopicVersionId;
    }

    public boolean isRecentChangeAllowed() {
        return this.recentChangeAllowed;
    }

    public void setRecentChangeAllowed(boolean recentChangeAllowed) {
        this.recentChangeAllowed = recentChangeAllowed;
    }

    public int getTopicId() {
        return this.topicId;
    }

    public void setTopicId(int topicId) {
        this.topicId = topicId;
    }

    public int getTopicVersionId() {
        return this.topicVersionId;
    }

    public void setTopicVersionId(int topicVersionId) {
        this.topicVersionId = topicVersionId;
    }

    public String getVersionContent() {
        return this.versionContent;
    }

    public void setVersionContent(String versionContent) {
        this.versionContent = versionContent;
    }

    private void addVersionParam(String param) {
        if (this.versionParams == null) {
            this.versionParams = new ArrayList<String>();
        }
        this.versionParams.add(param);
    }

    public List<String> getVersionParams() {
        return this.versionParams;
    }

    public void setVersionParams(List<String> versionParams) {
        this.versionParams = versionParams;
    }

    public String getVersionParamString() {
        return Utilities.listToDelimitedString(this.versionParams, "|");
    }

    public void setVersionParamString(String versionParamsString) {
        this.setVersionParams(Utilities.delimitedStringToList(versionParamsString, "|"));
    }
}

