/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.jamwiki.utils.WikiLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil {
    public static final WikiLogger logger = WikiLogger.getLogger(XMLUtil.class.getName());

    private XMLUtil() {
    }

    public static String buildTag(String tagName, String tagValue, boolean escape) {
        if (tagValue == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('<').append(tagName).append('>');
        if (escape) {
            tagValue = StringEscapeUtils.escapeXml((String)tagValue);
        }
        buffer.append(tagValue);
        buffer.append("</").append(tagName).append('>');
        return buffer.toString();
    }

    public static String buildTag(String tagName, String tagValue, Map<String, String> attributes, boolean escape) {
        if (tagValue == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('<').append(tagName);
        String value = null;
        for (String key : attributes.keySet()) {
            value = attributes.get(key);
            if (escape) {
                key = StringEscapeUtils.escapeXml((String)key);
                value = StringEscapeUtils.escapeXml((String)value);
            }
            buffer.append(" ").append(key).append("=\"").append(value).append("\"");
        }
        buffer.append('>');
        if (escape) {
            tagValue = StringEscapeUtils.escapeXml((String)tagValue);
        }
        buffer.append(tagValue);
        buffer.append("</").append(tagName).append('>');
        return buffer.toString();
    }

    public static String buildTag(String tagName, int tagValue) {
        return XMLUtil.buildTag(tagName, Integer.toString(tagValue), false);
    }

    public static String buildTag(String tagName, Integer tagValue) {
        return tagValue == null ? "" : XMLUtil.buildTag(tagName, tagValue.toString(), false);
    }

    public static String buildTag(String tagName, boolean tagValue) {
        return XMLUtil.buildTag(tagName, Boolean.toString(tagValue), false);
    }

    public static String buildTag(String tagName, Timestamp tagValue) {
        return tagValue == null ? "" : XMLUtil.buildTag(tagName, tagValue.toString(), false);
    }

    public static String buildTag(String tagName, long tagValue) {
        return XMLUtil.buildTag(tagName, Long.toString(tagValue), false);
    }

    public static String getTextContent(Node baseNode) {
        Node child = baseNode.getFirstChild();
        if (child != null && child.getNodeType() == 3) {
            return child.getNodeValue();
        }
        return "";
    }

    public static Document parseXML(File file, boolean validating) throws FileNotFoundException, ParseException {
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            InputSource source = new InputSource(stream);
            try {
                Document document = XMLUtil.parseXML(source, validating);
                return document;
            }
            catch (ParseException e) {
                ParseException pe = new ParseException("The file " + file.getAbsolutePath() + " could not be parsed", -1);
                pe.initCause(e);
                throw pe;
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Document parseXML(InputSource source, boolean validating) throws ParseException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        try {
            return factory.newDocumentBuilder().parse(source);
        }
        catch (IOException e) {
            ParseException pe = new ParseException("IO exception while parsing XML", -1);
            pe.initCause(e);
            throw pe;
        }
        catch (ParserConfigurationException e) {
            ParseException pe = new ParseException("XML could not be parsed", -1);
            pe.initCause(e);
            throw pe;
        }
        catch (SAXException e) {
            ParseException pe = new ParseException("XML contains invalid XML", -1);
            pe.initCause(e);
            throw pe;
        }
    }
}

