/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.support.tomcat.jasper.runtime;

import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public class TagHandlerPool
extends org.apache.jasper.runtime.TagHandlerPool {
    private AtomicInteger _counter = new AtomicInteger();
    private int _maxSize;
    private Queue<Tag> _tags = new ConcurrentLinkedQueue<Tag>();

    public Tag get(Class tagClass) throws JspException {
        Tag tag = this._tags.poll();
        if (tag == null) {
            try {
                tag = (Tag)tagClass.newInstance();
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        }
        return tag;
    }

    public void release() {
        Tag tag = null;
        while ((tag = this._tags.poll()) != null) {
            tag.release();
        }
    }

    public void reuse(Tag tag) {
        if (this._counter.get() < this._maxSize) {
            this._counter.getAndIncrement();
            this._tags.offer(tag);
        } else {
            tag.release();
        }
    }

    protected void init(ServletConfig config) {
        this._maxSize = GetterUtil.getInteger((String)TagHandlerPool.getOption((ServletConfig)config, (String)"tagpoolMaxSize", null), (int)5);
    }
}

