/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.support.tomcat.poller.comet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.poller.comet.CometHandler;
import com.liferay.portal.kernel.poller.comet.CometHandlerPoolUtil;
import com.liferay.portal.kernel.poller.comet.CometRequest;
import com.liferay.portal.kernel.poller.comet.CometSession;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.support.tomcat.poller.comet.CatalinaCometRequest;
import com.liferay.support.tomcat.poller.comet.CatalinaCometResponse;
import com.liferay.support.tomcat.poller.comet.CatalinaCometSession;
import com.liferay.support.tomcat.poller.comet.CatalinaCometSessionUtil;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;

public class CatalinaCometProcessor
extends HttpServlet
implements CometProcessor {
    private static Log _log = LogFactoryUtil.getLog(CatalinaCometProcessor.class);
    private CometHandler _cometHandler;

    public void destroy() {
        super.destroy();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy comet processor");
        }
    }

    public void event(CometEvent cometEvent) throws ServletException {
        try {
            this.doEvent(cometEvent);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize comet processor");
        }
        String cometHandlerImpl = servletConfig.getInitParameter("comet-handler-impl");
        try {
            this._cometHandler = (CometHandler)InstanceFactory.newInstance((String)cometHandlerImpl);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void closeConnection(CometEvent cometEvent, HttpServletRequest request, HttpSession session) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Close comet connection " + session.getId()));
        }
        String sessionId = CatalinaCometSessionUtil.getSessionId(cometEvent);
        CometHandlerPoolUtil.closeCometHandler((String)sessionId);
        cometEvent.close();
    }

    protected void doEvent(CometEvent cometEvent) throws Exception {
        CometEvent.EventType eventType = cometEvent.getEventType();
        HttpServletRequest request = cometEvent.getHttpServletRequest();
        HttpSession session = request.getSession();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(session.getId()) + " " + eventType));
        }
        if (eventType.equals((Object)CometEvent.EventType.BEGIN)) {
            this.startCometHandler(cometEvent, request, session);
        } else if (eventType.equals((Object)CometEvent.EventType.END) || eventType.equals((Object)CometEvent.EventType.ERROR)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(String.valueOf(session.getId()) + " " + cometEvent.getEventSubType()));
            }
            this.closeConnection(cometEvent, request, session);
        } else if (eventType.equals((Object)CometEvent.EventType.READ)) {
            this.readData(cometEvent, request, session);
        }
    }

    protected void readData(CometEvent cometEvent, HttpServletRequest request, HttpSession session) throws Exception {
        ServletInputStream inputStream = request.getInputStream();
        byte[] buffer = new byte[512];
        StringBundler sb = new StringBundler();
        while (inputStream.available() > 0) {
            int read = inputStream.read(buffer);
            if (read > 0) {
                String dataSegment = new String(buffer);
                sb.append(dataSegment);
                continue;
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)(String.valueOf(session.getId()) + " " + cometEvent.getEventSubType()));
        }
        String data = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Read " + data));
        }
        CometHandler cometHandler = CometHandlerPoolUtil.getCometHandler((String)session.getId());
        cometHandler.receiveData(data);
    }

    protected void startCometHandler(CometEvent cometEvent, HttpServletRequest request, HttpSession session) throws Exception {
        CatalinaCometSession cometSession = new CatalinaCometSession(cometEvent);
        cometSession.setCometRequest((CometRequest)new CatalinaCometRequest(cometEvent));
        cometSession.setCometResponse(new CatalinaCometResponse(cometEvent));
        String sessionId = CatalinaCometSessionUtil.getSessionId(cometEvent);
        cometSession.setSessionId(sessionId);
        CometHandler cometHandler = this._cometHandler.clone();
        CometHandlerPoolUtil.startCometHandler((CometSession)cometSession, (CometHandler)cometHandler);
        HttpServletResponse response = cometEvent.getHttpServletResponse();
        response.setContentType("text/plain; charset=UTF-8");
    }
}

