/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import com.liferay.util.RSSUtil;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;

public class RSSTag
extends IncludeTag {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = true;
    private static final String _PAGE = "/html/taglib/ui/rss/page.jsp";
    private int _delta = SearchContainer.DEFAULT_DELTA;
    private String _displayStyle = RSSUtil.DISPLAY_STYLE_DEFAULT;
    private String _feedType = RSSUtil.FEED_TYPE_DEFAULT;
    private String _message = "rss";
    private String _name;
    private ResourceURL _resourceURL;
    private String _url;

    public void setDelta(int delta) {
        this._delta = delta;
    }

    public void setDisplayStyle(String displayStyle) {
        this._displayStyle = displayStyle;
    }

    public void setFeedType(String feedType) {
        this._feedType = feedType;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setResourceURL(ResourceURL resourceURL) {
        this._resourceURL = resourceURL;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    @Override
    protected void cleanUp() {
        this._delta = SearchContainer.DEFAULT_DELTA;
        this._displayStyle = RSSUtil.DISPLAY_STYLE_DEFAULT;
        this._feedType = RSSUtil.FEED_TYPE_DEFAULT;
        this._message = "RSS";
        this._name = null;
        this._resourceURL = null;
        this._url = null;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return true;
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        request.setAttribute("liferay-ui:rss:message", (Object)this._message);
        request.setAttribute("liferay-ui:rss:url", (Object)this.getURL());
    }

    private String getURL() {
        if (this._resourceURL != null) {
            this._resourceURL.setCacheability("cacheLevelFull");
            if (this._delta > 0 && this._delta != SearchContainer.DEFAULT_DELTA) {
                this._resourceURL.setParameter("max", String.valueOf(this._delta));
            }
            if (Validator.isNotNull((String)this._displayStyle) && !this._displayStyle.equals(RSSUtil.DISPLAY_STYLE_DEFAULT)) {
                this._resourceURL.setParameter("displayStyle", this._displayStyle);
            }
            if (Validator.isNotNull((String)this._feedType) && !this._feedType.equals(RSSUtil.FEED_TYPE_DEFAULT)) {
                this._resourceURL.setParameter("type", RSSUtil.getFeedTypeFormat((String)this._feedType));
                this._resourceURL.setParameter("version", String.valueOf(RSSUtil.getFeedTypeVersion((String)this._feedType)));
            }
            if (Validator.isNotNull((String)this._name)) {
                this._resourceURL.setParameter("feedTitle", this._name);
            }
            return this._resourceURL.toString();
        }
        if (Validator.isNotNull((String)this._url)) {
            if (this._delta > 0 && this._delta != SearchContainer.DEFAULT_DELTA) {
                this._url = HttpUtil.addParameter((String)this._url, (String)"max", (int)this._delta);
            }
            if (Validator.isNotNull((String)this._displayStyle) && !this._displayStyle.equals(RSSUtil.DISPLAY_STYLE_DEFAULT)) {
                this._url = HttpUtil.addParameter((String)this._url, (String)"displayStyle", (String)this._displayStyle);
            }
            if (Validator.isNotNull((String)this._feedType) && !this._feedType.equals(RSSUtil.FEED_TYPE_DEFAULT)) {
                this._url = HttpUtil.addParameter((String)this._url, (String)"type", (String)RSSUtil.getFeedTypeFormat((String)this._feedType));
                this._url = HttpUtil.addParameter((String)this._url, (String)"version", (String)String.valueOf(RSSUtil.getFeedTypeVersion((String)this._feedType)));
            }
            if (Validator.isNotNull((String)this._name)) {
                this._url = HttpUtil.addParameter((String)this._url, (String)"feedTitle", (String)this._name);
            }
            return this._url;
        }
        return "";
    }
}

