/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValueConstraint;

public class NodeTypeDefDiff {
    public static final int NONE = 0;
    public static final int TRIVIAL = 1;
    public static final int MINOR = 2;
    public static final int MAJOR = 3;
    private final QNodeTypeDefinition oldDef;
    private final QNodeTypeDefinition newDef;
    private int type;
    private List<PropDefDiff> propDefDiffs = new ArrayList<PropDefDiff>();
    private List childNodeDefDiffs = new ArrayList();

    private NodeTypeDefDiff(QNodeTypeDefinition oldDef, QNodeTypeDefinition newDef) {
        this.oldDef = oldDef;
        this.newDef = newDef;
        this.init();
    }

    private void init() {
        if (this.oldDef.equals(this.newDef)) {
            this.type = 0;
        } else {
            this.type = 1;
            int tmpType = this.supertypesDiff();
            if (tmpType > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.mixinFlagDiff()) > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.abstractFlagDiff()) > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.buildPropDefDiffs()) > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.buildChildNodeDefDiffs()) > this.type) {
                this.type = tmpType;
            }
        }
    }

    public static NodeTypeDefDiff create(QNodeTypeDefinition oldDef, QNodeTypeDefinition newDef) {
        if (oldDef == null || newDef == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        if (!oldDef.getName().equals(newDef.getName())) {
            throw new IllegalArgumentException("at least node type names must be matching");
        }
        return new NodeTypeDefDiff(oldDef, newDef);
    }

    public boolean isModified() {
        return this.type != 0;
    }

    public boolean isTrivial() {
        return this.type == 1;
    }

    public boolean isMinor() {
        return this.type == 2;
    }

    public boolean isMajor() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public int mixinFlagDiff() {
        return this.oldDef.isMixin() != this.newDef.isMixin() ? 3 : 0;
    }

    public int abstractFlagDiff() {
        return this.oldDef.isAbstract() && !this.newDef.isAbstract() ? 3 : 0;
    }

    public int supertypesDiff() {
        return !Arrays.equals(this.oldDef.getSupertypes(), this.newDef.getSupertypes()) ? 3 : 0;
    }

    private int buildPropDefDiffs() {
        int maxType = 0;
        HashMap<PropDefId, QPropertyDefinition> oldDefs = new HashMap<PropDefId, QPropertyDefinition>();
        for (QPropertyDefinition def : this.oldDef.getPropertyDefs()) {
            oldDefs.put(new PropDefId(def), def);
        }
        HashMap<PropDefId, QPropertyDefinition> newDefs = new HashMap<PropDefId, QPropertyDefinition>();
        for (QPropertyDefinition def : this.newDef.getPropertyDefs()) {
            newDefs.put(new PropDefId(def), def);
        }
        for (Map.Entry entry : oldDefs.entrySet()) {
            QPropertyDefinition def2;
            PropDefId id = (PropDefId)entry.getKey();
            QPropertyDefinition def1 = (QPropertyDefinition)entry.getValue();
            PropDefDiff diff = new PropDefDiff(def1, def2 = (QPropertyDefinition)newDefs.get(id));
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.propDefDiffs.add(diff);
            newDefs.remove(id);
        }
        for (Map.Entry entry : newDefs.entrySet()) {
            QPropertyDefinition def = (QPropertyDefinition)entry.getValue();
            PropDefDiff diff = new PropDefDiff(null, def);
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.propDefDiffs.add(diff);
        }
        return maxType;
    }

    private int buildChildNodeDefDiffs() {
        NodeDefId id;
        int maxType = 0;
        QNodeDefinition[] cnda1 = this.oldDef.getChildNodeDefs();
        HashMap<NodeDefId, QNodeDefinition> defs1 = new HashMap<NodeDefId, QNodeDefinition>();
        for (int i = 0; i < cnda1.length; ++i) {
            defs1.put(new NodeDefId(cnda1[i]), cnda1[i]);
        }
        QNodeDefinition[] cnda2 = this.newDef.getChildNodeDefs();
        HashMap<NodeDefId, QNodeDefinition> defs2 = new HashMap<NodeDefId, QNodeDefinition>();
        for (int i = 0; i < cnda2.length; ++i) {
            defs2.put(new NodeDefId(cnda2[i]), cnda2[i]);
        }
        for (Map.Entry entry : defs1.entrySet()) {
            QItemDefinition def2;
            id = (NodeDefId)entry.getKey();
            QItemDefinition def1 = (QItemDefinition)entry.getValue();
            ChildNodeDefDiff diff = new ChildNodeDefDiff(def1, def2 = (QItemDefinition)defs2.get(id));
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.childNodeDefDiffs.add(diff);
            defs2.remove(id);
        }
        for (Map.Entry entry : defs2.entrySet()) {
            id = (NodeDefId)entry.getKey();
            QItemDefinition def = (QItemDefinition)entry.getValue();
            ChildNodeDefDiff diff = new ChildNodeDefDiff(null, def);
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.childNodeDefDiffs.add(diff);
        }
        return maxType;
    }

    public String toString() {
        String result = this.getClass().getName() + "[\n\tnodeTypeName=" + this.oldDef.getName();
        result = result + ",\n\tmixinFlagDiff=" + this.modificationTypeToString(this.mixinFlagDiff());
        result = result + ",\n\tsupertypesDiff=" + this.modificationTypeToString(this.supertypesDiff());
        result = result + ",\n\tpropertyDifferences=[\n";
        result = result + this.toString(this.propDefDiffs);
        result = result + "\t]";
        result = result + ",\n\tchildNodeDifferences=[\n";
        result = result + this.toString(this.childNodeDefDiffs);
        result = result + "\t]\n";
        result = result + "]\n";
        return result;
    }

    private String toString(List childItemDefDiffs) {
        String result = "";
        Iterator iter = childItemDefDiffs.iterator();
        while (iter.hasNext()) {
            ChildItemDefDiff propDefDiff = (ChildItemDefDiff)iter.next();
            result = result + "\t\t" + propDefDiff;
            if (iter.hasNext()) {
                result = result + ",";
            }
            result = result + "\n";
        }
        return result;
    }

    private String modificationTypeToString(int modifcationType) {
        switch (modifcationType) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "TRIVIAL";
            }
            case 2: {
                return "MINOR";
            }
            case 3: {
                return "MAJOR";
            }
        }
        return "unknown";
    }

    public class ChildNodeDefDiff
    extends ChildItemDefDiff {
        ChildNodeDefDiff(QItemDefinition oldDef, QItemDefinition newDef) {
            super(oldDef, newDef);
        }

        public QNodeDefinition getOldDef() {
            return (QNodeDefinition)this.oldDef;
        }

        public QNodeDefinition getNewDef() {
            return (QNodeDefinition)this.newDef;
        }

        protected void init() {
            super.init();
            if (this.isModified() && this.type != 0 && this.type != 3) {
                List<Name> l2;
                List<Name> l1;
                boolean b2;
                boolean b1 = this.getOldDef().allowsSameNameSiblings();
                if (b1 != (b2 = this.getNewDef().allowsSameNameSiblings()) && !b2) {
                    this.type = 3;
                }
                if (this.type == 1 && !((Object)(l1 = Arrays.asList(this.getOldDef().getRequiredPrimaryTypes()))).equals(l2 = Arrays.asList(this.getNewDef().getRequiredPrimaryTypes()))) {
                    this.type = l1.containsAll(l2) ? 2 : 3;
                }
            }
        }
    }

    public class PropDefDiff
    extends ChildItemDefDiff {
        PropDefDiff(QPropertyDefinition oldDef, QPropertyDefinition newDef) {
            super((QItemDefinition)oldDef, (QItemDefinition)newDef);
        }

        public QPropertyDefinition getOldDef() {
            return (QPropertyDefinition)this.oldDef;
        }

        public QPropertyDefinition getNewDef() {
            return (QPropertyDefinition)this.newDef;
        }

        protected void init() {
            super.init();
            if (this.isModified() && this.type != 0 && this.type != 3) {
                QValueConstraint[] vca1 = this.getOldDef().getValueConstraints();
                HashSet<String> set1 = new HashSet<String>();
                for (int i = 0; i < vca1.length; ++i) {
                    set1.add(vca1[i].getString());
                }
                QValueConstraint[] vca2 = this.getNewDef().getValueConstraints();
                HashSet<String> set2 = new HashSet<String>();
                for (int i = 0; i < vca2.length; ++i) {
                    set2.add(vca2[i].getString());
                }
                if (set1.isEmpty() && !set2.isEmpty()) {
                    this.type = 3;
                } else if (!set2.containsAll(set1) && !set2.isEmpty()) {
                    this.type = 3;
                }
                if (this.type == 1) {
                    boolean b2;
                    boolean b1;
                    int t2;
                    int t1 = this.getOldDef().getRequiredType();
                    if (t1 != (t2 = this.getNewDef().getRequiredType())) {
                        this.type = t2 == 0 ? 2 : 3;
                    }
                    if ((b1 = this.getOldDef().isMultiple()) != (b2 = this.getNewDef().isMultiple())) {
                        this.type = b2 ? 2 : 3;
                    }
                }
            }
        }
    }

    abstract class ChildItemDefDiff {
        protected final QItemDefinition oldDef;
        protected final QItemDefinition newDef;
        protected int type;

        ChildItemDefDiff(QItemDefinition oldDef, QItemDefinition newDef) {
            this.oldDef = oldDef;
            this.newDef = newDef;
            this.init();
        }

        protected void init() {
            this.type = this.isAdded() ? (!this.newDef.isMandatory() ? 1 : 3) : (this.isRemoved() ? 3 : (this.oldDef.equals(this.newDef) ? 0 : (this.oldDef.isMandatory() != this.newDef.isMandatory() && this.newDef.isMandatory() ? 3 : (!this.oldDef.definesResidual() && this.newDef.definesResidual() ? 2 : (!this.oldDef.getName().equals(this.newDef.getName()) ? 3 : 1)))));
        }

        public int getType() {
            return this.type;
        }

        public boolean isAdded() {
            return this.oldDef == null && this.newDef != null;
        }

        public boolean isRemoved() {
            return this.oldDef != null && this.newDef == null;
        }

        public boolean isModified() {
            return this.oldDef != null && this.newDef != null && !this.oldDef.equals(this.newDef);
        }

        public String toString() {
            String typeString = NodeTypeDefDiff.this.modificationTypeToString(this.getType());
            String operationString = this.isAdded() ? "ADDED" : (this.isModified() ? "MODIFIED" : (this.isRemoved() ? "REMOVED" : "NONE"));
            QItemDefinition itemDefinition = this.oldDef != null ? this.oldDef : this.newDef;
            return this.getClass().getName() + "[itemName=" + itemDefinition.getName() + ", type=" + typeString + ", operation=" + operationString + "]";
        }
    }
}

