/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.adapter;

import java.nio.CharBuffer;
import jodd.lagarto.LagartoParserContext;
import jodd.lagarto.Tag;
import jodd.lagarto.TagAdapter;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.util.CharUtil;

public class StripHtmlTagAdapter
extends TagAdapter {
    protected int strippedCharsCount;
    protected boolean strip;

    public StripHtmlTagAdapter(TagVisitor target) {
        super(target);
    }

    public void start(LagartoParserContext parserContext) {
        this.strippedCharsCount = 0;
        this.strip = true;
        super.start(parserContext);
    }

    public void comment(CharSequence comment) {
        this.strippedCharsCount += comment.length() + 7;
    }

    public void tag(Tag tag) {
        String tagName = tag.getName();
        if (tag.getType() == TagType.START && tagName.equals("pre")) {
            this.strip = false;
        }
        if (tag.getType() == TagType.END && tagName.equals("pre")) {
            this.strip = true;
        }
        super.tag(tag);
    }

    public void text(CharSequence text) {
        if (!this.strip) {
            super.text(text);
            return;
        }
        int textLength = text.length();
        char[] dest = new char[textLength];
        int ndx = 0;
        boolean regularChar = true;
        for (int i = 0; i < textLength; ++i) {
            int c = text.charAt(i);
            if (CharUtil.isWhitespace((char)c)) {
                if (!regularChar) continue;
                regularChar = false;
                c = 32;
            } else {
                regularChar = true;
            }
            dest[ndx] = c;
            ++ndx;
        }
        if (regularChar || ndx != 1) {
            super.text(CharBuffer.wrap(dest, 0, ndx));
            this.strippedCharsCount += textLength - ndx;
        } else {
            this.strippedCharsCount += textLength;
        }
    }

    public int getStrippedCharsCount() {
        return this.strippedCharsCount;
    }
}

