/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.scope;

import java.util.HashMap;
import java.util.Map;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SingletonScope;
import jodd.util.ArraysUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalScope
implements Scope {
    protected static ThreadLocal<Map<String, Object>> context = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected synchronized Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    protected Class[] acceptedScopes = new Class[]{ThreadLocalScope.class, SingletonScope.class};

    @Override
    public Object lookup(String name) {
        Map<String, Object> threadLocalMap = context.get();
        return threadLocalMap.get(name);
    }

    @Override
    public void register(String name, Object bean) {
        Map<String, Object> threadLocalMap = context.get();
        threadLocalMap.put(name, bean);
    }

    @Override
    public void remove(String name) {
        Map<String, Object> threadLocalMap = context.get();
        threadLocalMap.remove(name);
    }

    @Override
    public boolean accept(Scope referenceScope) {
        Class<?> refScopeType = referenceScope.getClass();
        for (int i = 0; i < this.acceptedScopes.length; ++i) {
            if (refScopeType != this.acceptedScopes[i]) continue;
            return true;
        }
        return false;
    }

    protected void acceptScope(Class<? extends Scope> scope) {
        this.acceptedScopes = ArraysUtil.append(this.acceptedScopes, scope);
    }
}

