/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.util.List;
import java.util.Map;
import jodd.typeconverter.Convert;
import jodd.util.CharUtil;
import jodd.util.HtmlEncoder;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlFormUtil {
    private static final String EMPTY = "";
    private static final String CHECKED = "checked";
    private static final String IGNORE = " _i=\"";
    private static final String TRUE = "true";
    private static final String ENDQUOTE = "\" ";
    private static final String SELECTED = "selected";

    public static String checked(boolean data) {
        return data ? CHECKED : EMPTY;
    }

    public static String checked(Object data) {
        if (data == null) {
            return EMPTY;
        }
        if (Convert.toBooleanValue(data)) {
            return CHECKED;
        }
        return EMPTY;
    }

    public static String checkedExist(Object data) {
        return data != null ? CHECKED : EMPTY;
    }

    public static String checked(Object data, String value) {
        if (data == null) {
            return EMPTY;
        }
        if (data.getClass().isArray()) {
            String[] vs;
            for (String vsk : vs = StringUtil.toStringArray(data)) {
                if (vsk == null || !vsk.equals(value)) continue;
                return CHECKED;
            }
        } else if (data.toString().equals(value)) {
            return CHECKED;
        }
        return EMPTY;
    }

    public static <T> String checked(T[] array, int index) {
        if (array == null || index >= array.length || index < 0) {
            return EMPTY;
        }
        return HtmlFormUtil.checked(array[index]);
    }

    public static String checked(boolean[] array, int index) {
        if (array == null || index >= array.length || index < 0) {
            return EMPTY;
        }
        return HtmlFormUtil.checked(array[index]);
    }

    public static String checked(byte[] array, int index) {
        if (array == null || index >= array.length || index < 0) {
            return EMPTY;
        }
        return array[index] != 0 ? CHECKED : EMPTY;
    }

    public static String checked(short[] array, int index) {
        if (array == null || index >= array.length || index < 0) {
            return EMPTY;
        }
        return array[index] != 0 ? CHECKED : EMPTY;
    }

    public static String array(int[] array, int index) {
        if (array == null || index >= array.length || index < 0) {
            return EMPTY;
        }
        return array[index] != 0 ? CHECKED : EMPTY;
    }

    public static String array(long[] array, int index) {
        if (array == null || index >= array.length || index < 0) {
            return EMPTY;
        }
        return array[index] != 0L ? CHECKED : EMPTY;
    }

    public static String array(float[] array, int index) {
        if (array == null || index >= array.length || index < 0) {
            return EMPTY;
        }
        return array[index] != 0.0f ? CHECKED : EMPTY;
    }

    public static String array(double[] array, int index) {
        if (array == null || index >= array.length || index < 0) {
            return EMPTY;
        }
        return array[index] != 0.0 ? CHECKED : EMPTY;
    }

    public static String checkedValue(Object data, String value) {
        return value + ENDQUOTE + HtmlFormUtil.checked(data, value) + IGNORE;
    }

    public static String checkedValue(boolean data, String value) {
        return value + ENDQUOTE + HtmlFormUtil.checked(data) + IGNORE;
    }

    public static String checkedValue(Boolean data, String value) {
        return value + ENDQUOTE + HtmlFormUtil.checked(data) + IGNORE;
    }

    public static String checkedValue(Object data) {
        return "true\" " + HtmlFormUtil.checked(data) + IGNORE;
    }

    public static String checkedValueExist(Object data) {
        return "true\" " + HtmlFormUtil.checkedExist(data) + IGNORE;
    }

    public static String selected(Object data, String value) {
        if (data == null) {
            return EMPTY;
        }
        if (data.toString().equals(value)) {
            return SELECTED;
        }
        return EMPTY;
    }

    public static String selectedValue(Object data, String value) {
        return value + ENDQUOTE + HtmlFormUtil.selected(data, value) + IGNORE;
    }

    public static String multiSelected(Object data, String value) {
        if (data == null) {
            return EMPTY;
        }
        Class<?> arrayType = data.getClass().getComponentType();
        if (arrayType != null) {
            if (arrayType.equals(Integer.TYPE)) {
                return HtmlFormUtil.multiSelected((int[])data, value);
            }
            if (arrayType.equals(Long.TYPE)) {
                return HtmlFormUtil.multiSelected((long[])data, value);
            }
            return HtmlFormUtil.multiSelected((Object[])data, value);
        }
        if (data instanceof List) {
            return HtmlFormUtil.multiSelected((List)data, value);
        }
        throw new IllegalArgumentException("Invalid multi-selected field data");
    }

    public static String multiSelected(Object[] data, String value) {
        if (data == null) {
            return EMPTY;
        }
        for (Object obj : data) {
            if (!obj.toString().equals(value)) continue;
            return SELECTED;
        }
        return EMPTY;
    }

    public static String multiSelected(int[] data, String value) {
        if (data == null) {
            return EMPTY;
        }
        for (int i : data) {
            if (!Integer.toString(i).equals(value)) continue;
            return SELECTED;
        }
        return EMPTY;
    }

    public static String multiSelected(long[] data, String value) {
        if (data == null) {
            return EMPTY;
        }
        for (long l : data) {
            if (!Long.toString(l).equals(value)) continue;
            return SELECTED;
        }
        return EMPTY;
    }

    public static String multiSelected(List data, String value) {
        if (data == null) {
            return EMPTY;
        }
        if (data.contains(value)) {
            return SELECTED;
        }
        return EMPTY;
    }

    public static String multiSelectedValue(Object data, String value) {
        return value + ENDQUOTE + HtmlFormUtil.multiSelected(data, value) + IGNORE;
    }

    public static String multiSelectedValue(Object[] data, String value) {
        return value + ENDQUOTE + HtmlFormUtil.multiSelected(data, value) + IGNORE;
    }

    public static String multiSelectedValue(int[] data, String value) {
        return value + ENDQUOTE + HtmlFormUtil.multiSelected(data, value) + IGNORE;
    }

    public static String multiSelectedValue(long[] data, String value) {
        return value + ENDQUOTE + HtmlFormUtil.multiSelected(data, value) + IGNORE;
    }

    public static String multiSelectedValue(List data, String value) {
        return value + ENDQUOTE + HtmlFormUtil.multiSelected(data, value) + IGNORE;
    }

    public static String name2id(String name) {
        char[] str = name.toCharArray();
        for (int i = 0; i < str.length; ++i) {
            if (CharUtil.isAlphaOrDigit(str[i])) continue;
            str[i] = 95;
        }
        return new String(str);
    }

    public static Object list(List list, int index) {
        if (list == null || index >= list.size() || index < 0) {
            return null;
        }
        return list.get(index);
    }

    public static Object map(Map map, Object key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static String text(Object value) {
        if (value == null) {
            return EMPTY;
        }
        return HtmlEncoder.text(value.toString());
    }
}

