/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.uri.Mint;
import org.gcube.common.uri.ap.AuthorityProvider;
import org.gcube.common.uri.ap.InfrastructureFilterSAP;
import org.gcube.common.uri.ap.ScopedAPAdapter;
import org.gcube.common.uri.ap.ScopedPropertyAP;

public class HttpMint
implements Mint {
    private static final String scheme = "http";
    private final AuthorityProvider provider;

    public HttpMint() {
        this(new ScopedAPAdapter(new InfrastructureFilterSAP(new ScopedPropertyAP())));
    }

    public HttpMint(AuthorityProvider provider) {
        this.provider = provider;
    }

    @Override
    public URI mint(List<String> elements) throws IllegalStateException {
        String path = this.check(elements);
        String scope = ScopeProvider.instance.get();
        this.check(scope);
        String authority = this.provider.authority();
        try {
            return new URI(scheme, authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("cannot create URI", e);
        }
    }

    private String check(List<String> elements) {
        if (elements == null || elements.isEmpty()) {
            throw new IllegalArgumentException("resource path is null or empty");
        }
        for (String string : elements) {
            if (string != null && !string.isEmpty()) continue;
            throw new IllegalArgumentException("resource path " + elements + " contains a null or empty element");
        }
        StringBuilder builder = new StringBuilder();
        for (String e : elements) {
            builder.append("/" + e);
        }
        String string = builder.toString();
        return string;
    }

    private void check(String scope) {
        if (scope == null || scope.isEmpty()) {
            throw new IllegalStateException("cannot mint a URI outside a scope");
        }
    }
}

