/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.uri.ap;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.common.uri.ap.ScopedAuthorityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingSDP
implements ScopedAuthorityProvider {
    private static Logger log = LoggerFactory.getLogger(CachingSDP.class);
    private static final int DEFAULT_SIZE = 10;
    private final Map<String, String> authorities;
    private final ScopedAuthorityProvider target;

    public CachingSDP(ScopedAuthorityProvider cached) {
        this(cached, 10);
    }

    public CachingSDP(ScopedAuthorityProvider cached, final int size) {
        this.target = cached;
        this.authorities = Collections.synchronizedMap(new LinkedHashMap<String, String>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > size;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authorityIn(String scope) {
        String authority = this.authorities.get(scope);
        if (authority == null) {
            String string = scope;
            synchronized (string) {
                authority = this.target.authorityIn(scope);
                log.info("cached authority {} for scope {}", (Object)authority, (Object)scope);
            }
        }
        this.authorities.put(scope, authority);
        return authority;
    }
}

