/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.Execution;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.IsRetryableException;
import com.netflix.astyanax.retry.RetryPolicy;

public abstract class AbstractExecutionImpl<R>
implements Execution<R> {
    public OperationResult<R> executeWithRetry(RetryPolicy retry) throws ConnectionException {
        ConnectionException lastException = null;
        retry.begin();
        while (true) {
            try {
                return this.execute();
            }
            catch (ConnectionException ex) {
                if (!(ex instanceof IsRetryableException)) {
                    throw ex;
                }
                lastException = ex;
                if (retry.allowRetry()) continue;
                throw lastException;
            }
            break;
        }
    }
}

