/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Packet.Received;

import JOscarLib.Core.OscarConnection;
import JOscarLib.Integration.Event.IncomingUserEvent;
import JOscarLib.Integration.Event.StatusListener;
import JOscarLib.Packet.Received.ReceivedPacket;
import JOscarLib.RawData;
import JOscarLib.Setting.Enum.StatusFlagEnum;
import JOscarLib.Setting.Enum.StatusModeEnum;
import JOscarLib.Setting.Enum.TcpConnectionFlagEnum;
import JOscarLib.Tlv;

public class IncomingUser__3_11
extends ReceivedPacket {
    private RawData userId;
    private RawData internalIp;
    private RawData port;
    private RawData tcpFlag;
    private RawData tcpVersion;
    private RawData cookie;
    private RawData versioning1;
    private RawData versioning2;
    private Tlv externalIp;
    private Tlv userStatus;
    private Tlv capabilities;
    private Tlv onlineSince;
    private Tlv idleTime;
    private Tlv memberSince;
    private Tlv timeUpdate;
    private boolean isContainingCapabilities = false;
    private boolean isConstainingDirectConnectionInformation = false;

    public IncomingUser__3_11(byte[] array) {
        super(array, true);
        int position = 0;
        byte[] data = this.getSnac().getDataFieldByteArray();
        RawData idLen = new RawData(data, position, 1);
        this.userId = new RawData(data, ++position, idLen.getValue());
        position += this.userId.getByteArray().length;
        RawData nbTLV = new RawData(data, position += 2, 2);
        position += 2;
        for (int i = 0; i < nbTLV.getValue(); ++i) {
            Tlv tmpTlv = new Tlv(data, position);
            switch (tmpTlv.getType()) {
                case 12: {
                    this.parseCli2Cli(tmpTlv.getByteArray());
                    this.isConstainingDirectConnectionInformation = true;
                    break;
                }
                case 10: {
                    this.externalIp = tmpTlv;
                    break;
                }
                case 6: {
                    this.userStatus = tmpTlv;
                    break;
                }
                case 13: {
                    this.capabilities = tmpTlv;
                    this.isContainingCapabilities = true;
                    break;
                }
                case 15: {
                    this.idleTime = tmpTlv;
                    break;
                }
                case 3: {
                    this.onlineSince = tmpTlv;
                    break;
                }
                case 5: {
                    this.memberSince = tmpTlv;
                    break;
                }
                case 17: {
                    this.timeUpdate = tmpTlv;
                }
            }
            position += tmpTlv.getByteArray().length;
        }
    }

    public void notifyEvent(OscarConnection connection) {
        IncomingUserEvent e = new IncomingUserEvent(this);
        for (int i = 0; i < connection.getStatusListeners().size(); ++i) {
            StatusListener l = (StatusListener)connection.getStatusListeners().elementAt(i);
            l.onIncomingUser(e);
        }
    }

    private void parseCli2Cli(byte[] data) {
        int position = 4;
        this.internalIp = new RawData(data, position, 4);
        this.port = new RawData(data, position += 4, 4);
        this.tcpFlag = new RawData(data, position += 4, 1);
        this.tcpVersion = new RawData(data, ++position, 2);
        this.cookie = new RawData(data, position += 2, 4);
        position += 4;
        this.versioning1 = new RawData(data, position += 8, 4);
        this.versioning2 = new RawData(data, position += 4, 4);
    }

    public boolean getIsContainingCapabilities() {
        return this.isContainingCapabilities;
    }

    public boolean isConstainingDirectConnectionInformation() {
        return this.isConstainingDirectConnectionInformation;
    }

    public String getUserId() {
        return this.userId.getStringValue();
    }

    public String getInterlnalIp() {
        String add = "";
        add = add + (this.internalIp.getValue() >> 24 & 0xFF) + ".";
        add = add + (this.internalIp.getValue() >> 16 & 0xFF) + ".";
        add = add + (this.internalIp.getValue() >> 8 & 0xFF) + ".";
        add = add + (this.internalIp.getValue() & 0xFF);
        return add;
    }

    public int getPort() {
        return this.port.getValue();
    }

    public TcpConnectionFlagEnum getTcpFlag() {
        return new TcpConnectionFlagEnum(this.tcpFlag.getValue());
    }

    public int getTcpVersion() {
        return this.tcpVersion.getValue();
    }

    public int getCookie() {
        return this.cookie.getValue();
    }

    public int getVersionning1() {
        return this.versioning1.getValue();
    }

    public int getVersionning2() {
        return this.versioning2.getValue();
    }

    public String getExternalIp() {
        String add = "";
        add = add + (this.externalIp.getValue() >> 24 & 0xFF) + ".";
        add = add + (this.externalIp.getValue() >> 16 & 0xFF) + ".";
        add = add + (this.externalIp.getValue() >> 8 & 0xFF) + ".";
        add = add + (this.externalIp.getValue() & 0xFF);
        return add;
    }

    public StatusModeEnum getStatusMode() {
        if (this.userStatus == null) {
            return new StatusModeEnum(0);
        }
        return new StatusModeEnum(this.userStatus.getValue() & 0xFFFF);
    }

    public StatusFlagEnum getStatusFlag() {
        if (this.userStatus == null) {
            return new StatusFlagEnum(0);
        }
        return new StatusFlagEnum(this.userStatus.getValue());
    }

    public Tlv getCapabilities() {
        return this.capabilities;
    }

    public int getOnlineSince() {
        return this.onlineSince.getValue();
    }
}

