/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.MutableRoot;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexProvider;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.QueryEngineImpl;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public final class ImmutableRoot
implements Root {
    private final ImmutableTree rootTree;

    public ImmutableRoot(@Nonnull NodeState rootState) {
        this(new ImmutableTree(rootState));
    }

    public ImmutableRoot(@Nonnull Root root) {
        if (root instanceof MutableRoot) {
            this.rootTree = new ImmutableTree(((MutableRoot)root).getBaseState());
        } else if (root instanceof ImmutableRoot) {
            this.rootTree = ((ImmutableRoot)root).getTree("/");
        } else {
            throw new IllegalArgumentException("Unsupported Root implementation: " + root.getClass());
        }
    }

    public ImmutableRoot(@Nonnull ImmutableTree rootTree) {
        Preconditions.checkArgument((boolean)rootTree.isRoot());
        this.rootTree = rootTree;
    }

    @Override
    @Nonnull
    public ImmutableTree getTree(@Nonnull String path) {
        Preconditions.checkArgument((boolean)PathUtils.isAbsolute((String)path));
        ImmutableTree child = this.rootTree;
        for (String name : PathUtils.elements((String)path)) {
            child = child.getChild(name);
        }
        return child;
    }

    @Override
    public boolean move(String sourcePath, String destPath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commit(Map<String, Object> info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasPendingChanges() {
        return false;
    }

    @Override
    @Nonnull
    public QueryEngine getQueryEngine() {
        return new QueryEngineImpl(){

            @Override
            protected ExecutionContext getExecutionContext() {
                return new ExecutionContext(ImmutableRoot.this.rootTree.getNodeState(), ImmutableRoot.this, new QueryEngineSettings(), new PropertyIndexProvider());
            }
        };
    }

    @Override
    @Nonnull
    public Blob createBlob(@Nonnull InputStream stream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(@Nonnull String reference) {
        return null;
    }

    @Override
    @Nonnull
    public ContentSession getContentSession() {
        throw new UnsupportedOperationException();
    }
}

