/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.kernel;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.kernel.KernelBlob;
import org.apache.jackrabbit.oak.kernel.KernelNodeState;
import org.apache.jackrabbit.oak.kernel.KernelNodeStoreBranch;
import org.apache.jackrabbit.oak.kernel.KernelRootBuilder;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class KernelNodeStore
implements NodeStore,
Observable {
    public static final long DEFAULT_CACHE_SIZE = 0x1000000L;
    private final MicroKernel kernel;
    private final LoadingCache<String, KernelNodeState> cache;
    private final CacheStats cacheStats;
    private final Lock mergeLock = new ReentrantLock();
    private final ChangeDispatcher changeDispatcher;
    private KernelNodeState root;

    public KernelNodeStore(MicroKernel kernel, long cacheSize) {
        this.kernel = (MicroKernel)Preconditions.checkNotNull((Object)kernel);
        Weigher<String, KernelNodeState> weigher = new Weigher<String, KernelNodeState>(){

            public int weigh(String key, KernelNodeState state) {
                return state.getMemory();
            }
        };
        this.cache = CacheLIRS.newBuilder().maximumWeight(cacheSize).recordStats().weigher(weigher).build(new CacheLoader<String, KernelNodeState>(){

            public KernelNodeState load(String key) {
                int slash = key.indexOf(47);
                String revision = key.substring(0, slash);
                String path = key.substring(slash);
                return new KernelNodeState(KernelNodeStore.this, path, revision, (LoadingCache<String, KernelNodeState>)KernelNodeStore.this.cache);
            }

            public ListenableFuture<KernelNodeState> reload(String key, KernelNodeState oldValue) {
                SettableFuture future = SettableFuture.create();
                future.set((Object)oldValue);
                return future;
            }
        });
        this.cacheStats = new CacheStats((Cache<?, ?>)this.cache, "NodeStore", weigher, cacheSize);
        try {
            this.root = (KernelNodeState)this.cache.get((Object)(kernel.getHeadRevision() + '/'));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.changeDispatcher = new ChangeDispatcher(this.root);
    }

    public KernelNodeStore(MicroKernel kernel) {
        this(kernel, 0x1000000L);
    }

    public String toString() {
        return this.getRoot().toString();
    }

    @Override
    public Closeable addObserver(Observer observer) {
        return this.changeDispatcher.addObserver(observer);
    }

    @Override
    public synchronized KernelNodeState getRoot() {
        String revision = this.kernel.getHeadRevision();
        if (!revision.equals(this.root.getRevision())) {
            this.root = this.getRootState(revision);
        }
        return this.root;
    }

    @Override
    public NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nullable CommitInfo info) throws CommitFailedException {
        Preconditions.checkArgument((boolean)(builder instanceof KernelRootBuilder));
        return ((KernelRootBuilder)builder).merge((CommitHook)Preconditions.checkNotNull((Object)commitHook), info);
    }

    @Override
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof KernelRootBuilder));
        return ((KernelRootBuilder)builder).rebase();
    }

    @Override
    public NodeState reset(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof KernelRootBuilder));
        return ((KernelRootBuilder)builder).reset();
    }

    @Override
    public KernelBlob createBlob(InputStream inputStream) throws IOException {
        try {
            String blobId = this.kernel.write(inputStream);
            return new KernelBlob(blobId, this.kernel);
        }
        catch (MicroKernelException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Blob getBlob(@Nonnull String reference) {
        try {
            this.kernel.getLength(reference);
            return new KernelBlob(reference, this.kernel);
        }
        catch (MicroKernelException e) {
            return null;
        }
    }

    @Override
    @Nonnull
    public String checkpoint(long lifetime) {
        Preconditions.checkArgument((lifetime > 0L ? 1 : 0) != 0);
        return this.kernel.checkpoint(lifetime);
    }

    @Override
    @CheckForNull
    public NodeState retrieve(@Nonnull String checkpoint) {
        try {
            return this.getRootState((String)Preconditions.checkNotNull((Object)checkpoint));
        }
        catch (MicroKernelException e) {
            return null;
        }
    }

    public CacheStats getCacheStats() {
        return this.cacheStats;
    }

    private KernelNodeState getRootState(String revision) {
        try {
            return (KernelNodeState)this.cache.get((Object)(revision + "/"));
        }
        catch (ExecutionException e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    KernelNodeStoreBranch createBranch(KernelNodeState base) {
        return new KernelNodeStoreBranch(this, this.changeDispatcher, this.mergeLock, base);
    }

    MicroKernel getKernel() {
        return this.kernel;
    }

    KernelNodeState commit(String jsop, KernelNodeState base) {
        if (jsop.isEmpty()) {
            return base;
        }
        KernelNodeState rootState = this.getRootState(this.kernel.commit("", jsop, base.getRevision(), null));
        if (base.isBranch()) {
            rootState.setBranch();
        }
        return rootState;
    }

    KernelNodeState branch(KernelNodeState base) {
        return this.getRootState(this.kernel.branch(base.getRevision())).setBranch();
    }

    KernelNodeState rebase(KernelNodeState branchHead, KernelNodeState base) {
        return this.getRootState(this.kernel.rebase(branchHead.getRevision(), base.getRevision())).setBranch();
    }

    KernelNodeState merge(KernelNodeState branchHead) {
        return this.getRootState(this.kernel.merge(branchHead.getRevision(), null));
    }

    KernelNodeState reset(KernelNodeState branchHead, KernelNodeState ancestor) {
        return this.getRootState(this.kernel.reset(branchHead.getRevision(), ancestor.getRevision()));
    }
}

