/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConflictValidator
extends DefaultValidator {
    private static Logger log = LoggerFactory.getLogger(ConflictValidator.class);
    private final Tree parentAfter;

    public ConflictValidator(Tree parentAfter) {
        this.parentAfter = parentAfter;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.failOnMergeConflict(after);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.failOnMergeConflict(after);
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) {
        return new ConflictValidator(this.parentAfter.getChild(name));
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) {
        return new ConflictValidator(this.parentAfter.getChild(name));
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) {
        return null;
    }

    private void failOnMergeConflict(PropertyState property) throws CommitFailedException {
        if ("jcr:mixinTypes".equals(property.getName())) {
            assert (property.isArray());
            for (String v : property.getValue(Type.STRINGS)) {
                if (!"rep:MergeConflict".equals(v)) continue;
                CommitFailedException ex = new CommitFailedException("State", 1, "Unresolved conflicts in " + this.parentAfter.getPath());
                if (log.isDebugEnabled()) {
                    log.debug(this.getConflictMessage(), (Throwable)ex);
                }
                throw ex;
            }
        }
    }

    private String getConflictMessage() {
        StringBuilder sb = new StringBuilder("Commit failed due to unresolved conflicts in ");
        sb.append(this.parentAfter.getPath());
        sb.append(" = {");
        for (Tree conflict : this.parentAfter.getChild("rep:ours").getChildren()) {
            ConflictType ct = ConflictType.fromName(conflict.getName());
            sb.append(ct.getName()).append(" = {");
            if (ct.effectsNode()) {
                sb.append(ConflictValidator.getChildNodeNamesAsString(conflict));
            } else {
                for (PropertyState propertyState : conflict.getProperties()) {
                    PropertyState ours = null;
                    PropertyState theirs = null;
                    switch (ct) {
                        case DELETE_CHANGED_PROPERTY: {
                            ours = null;
                            theirs = propertyState;
                            break;
                        }
                        case ADD_EXISTING_PROPERTY: 
                        case CHANGE_CHANGED_PROPERTY: {
                            ours = propertyState;
                            theirs = this.parentAfter.getProperty(propertyState.getName());
                            break;
                        }
                        case CHANGE_DELETED_PROPERTY: {
                            ours = propertyState;
                            theirs = null;
                        }
                    }
                    sb.append(propertyState.getName()).append(" = {").append(ConflictValidator.toString(ours)).append(',').append(ConflictValidator.toString(theirs)).append('}');
                    sb.append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("},");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append('}');
        return sb.toString();
    }

    private static String getChildNodeNamesAsString(Tree t) {
        return Joiner.on((char)',').join(Iterables.transform(t.getChildren(), Tree.GET_NAME));
    }

    private static String toString(PropertyState ps) {
        if (ps == null) {
            return "<N/A>";
        }
        Type<?> type = ps.getType();
        if (type.isArray()) {
            return "<ARRAY>";
        }
        if (Type.BINARY == type) {
            return "<BINARY>";
        }
        String value = ps.getValue(Type.STRING);
        if (Type.STRING == type && value.length() > 10) {
            value = value.substring(0, 10) + "...";
        }
        return value;
    }
}

