/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.kernel.BlobSerializer;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.BatchCommitQueue;
import org.apache.jackrabbit.oak.plugins.document.BlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.CommitQueue;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.document.DocumentRootBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.LastRevRecoveryAgent;
import org.apache.jackrabbit.oak.plugins.document.MergeCommit;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.ResetDiff;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.UnmergedBranches;
import org.apache.jackrabbit.oak.plugins.document.UnsavedModifications;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.LoggingDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.plugins.document.util.TimingDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentNodeStore
implements NodeStore,
RevisionContext,
Observable {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNodeStore.class);
    static final int NUM_CHILDREN_CACHE_LIMIT = Integer.getInteger("oak.documentMK.childrenCacheLimit", 16384);
    private static final int WARN_REVISION_AGE = Integer.getInteger("oak.documentMK.revisionAge", 60000);
    private static final boolean ENABLE_BACKGROUND_OPS = Boolean.parseBoolean(System.getProperty("oak.documentMK.backgroundOps", "true"));
    private static final int REMEMBER_REVISION_ORDER_MILLIS = 3600000;
    protected final DocumentStore store;
    protected final DocumentNodeState missing;
    protected final CommitQueue commitQueue;
    protected final BatchCommitQueue batchCommitQueue;
    protected final ChangeDispatcher dispatcher;
    protected int asyncDelay = 1000;
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final ClusterNodeInfo clusterNodeInfo;
    private final int clusterId;
    private final Revision.RevisionComparator revisionComparator;
    private final UnmergedBranches branches;
    private final UnsavedModifications unsavedLastRevisions = new UnsavedModifications();
    private final Map<String, String> splitCandidates = Maps.newConcurrentMap();
    private final Map<Integer, Revision> lastKnownRevision = new ConcurrentHashMap<Integer, Revision>();
    private volatile Revision headRevision;
    private Thread backgroundThread;
    private Thread leaseUpdateThread;
    private final ReadWriteLock backgroundOperationLock = new ReentrantReadWriteLock();
    private final ReadWriteLock mergeLock = new ReentrantReadWriteLock();
    private AtomicInteger simpleRevisionCounter;
    private final Cache<CacheValue, DocumentNodeState> nodeCache;
    private final CacheStats nodeCacheStats;
    private final Cache<CacheValue, DocumentNodeState.Children> nodeChildrenCache;
    private final CacheStats nodeChildrenCacheStats;
    private final Cache<CacheValue, NodeDocument.Children> docChildrenCache;
    private final CacheStats docChildrenCacheStats;
    private final DiffCache diffCache;
    private final BlobStore blobStore;
    private final BlobSerializer blobSerializer = new BlobSerializer(){

        @Override
        public String serialize(Blob blob) {
            String id;
            if (blob instanceof BlobStoreBlob) {
                return ((BlobStoreBlob)blob).getBlobId();
            }
            String reference = blob.getReference();
            if (reference != null && (id = DocumentNodeStore.this.blobStore.getBlobId(reference)) != null) {
                return id;
            }
            try {
                id = DocumentNodeStore.this.createBlob(blob.getNewStream()).getBlobId();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return id;
        }
    };
    private final Clock clock;
    private final Checkpoints checkpoints;
    private final VersionGarbageCollector versionGarbageCollector;
    private final Executor executor;
    private final LastRevRecoveryAgent lastRevRecoveryAgent;
    private final boolean disableBranches;

    public DocumentNodeStore(DocumentMK.Builder builder) {
        this.blobStore = builder.getBlobStore();
        if (builder.isUseSimpleRevision()) {
            this.simpleRevisionCounter = new AtomicInteger(0);
        }
        DocumentStore s = builder.getDocumentStore();
        if (builder.getTiming()) {
            s = new TimingDocumentStoreWrapper(s);
        }
        if (builder.getLogging()) {
            s = new LoggingDocumentStoreWrapper(s);
        }
        this.store = s;
        this.executor = builder.getExecutor();
        this.clock = builder.getClock();
        int cid = builder.getClusterId();
        if ((cid = Integer.getInteger("oak.documentMK.clusterId", cid).intValue()) == 0) {
            this.clusterNodeInfo = ClusterNodeInfo.getInstance(this.store);
            cid = this.clusterNodeInfo.getId();
        } else {
            this.clusterNodeInfo = null;
        }
        this.clusterId = cid;
        this.revisionComparator = new Revision.RevisionComparator(this.clusterId);
        this.branches = new UnmergedBranches(this.getRevisionComparator());
        this.asyncDelay = builder.getAsyncDelay();
        this.versionGarbageCollector = new VersionGarbageCollector(this);
        this.lastRevRecoveryAgent = new LastRevRecoveryAgent(this);
        this.disableBranches = builder.isDisableBranches();
        this.missing = new DocumentNodeState(this, "MISSING", new Revision(0L, 0, 0)){

            @Override
            public int getMemory() {
                return 8;
            }
        };
        this.nodeCache = builder.buildCache(builder.getNodeCacheSize());
        this.nodeCacheStats = new CacheStats(this.nodeCache, "Document-NodeState", builder.getWeigher(), builder.getNodeCacheSize());
        this.nodeChildrenCache = builder.buildCache(builder.getChildrenCacheSize());
        this.nodeChildrenCacheStats = new CacheStats(this.nodeChildrenCache, "Document-NodeChildren", builder.getWeigher(), builder.getChildrenCacheSize());
        this.docChildrenCache = builder.buildCache(builder.getDocChildrenCacheSize());
        this.docChildrenCacheStats = new CacheStats(this.docChildrenCache, "Document-DocChildren", builder.getWeigher(), builder.getDocChildrenCacheSize());
        this.diffCache = builder.getDiffCache();
        this.checkpoints = new Checkpoints(this);
        if (this.store.find(Collection.NODES, Utils.getIdFromPath("/")) == null) {
            Revision head = this.newRevision();
            Commit commit = new Commit(this, null, head);
            DocumentNodeState n = new DocumentNodeState(this, "/", head);
            commit.addNode(n);
            commit.applyToDocumentStore();
            commit.applyToCache(new Revision(0L, 0, this.clusterId), false);
            this.setHeadRevision(commit.getRevision());
            this.backgroundWrite();
        } else {
            this.branches.init(this.store, this);
            this.backgroundRead(false);
            if (this.headRevision == null) {
                this.setHeadRevision(this.newRevision());
            }
        }
        this.getRevisionComparator().add(this.headRevision, Revision.newRevision(0));
        this.dispatcher = new ChangeDispatcher(this.getRoot());
        this.commitQueue = new CommitQueue(this, this.dispatcher);
        this.batchCommitQueue = new BatchCommitQueue(this.store, this.revisionComparator);
        this.backgroundThread = new Thread((Runnable)new BackgroundOperation(this, this.isDisposed), "DocumentNodeStore background thread");
        this.backgroundThread.setDaemon(true);
        this.checkLastRevRecovery();
        this.renewClusterIdLease();
        this.backgroundThread.start();
        if (this.clusterNodeInfo != null) {
            this.leaseUpdateThread = new Thread((Runnable)new BackgroundLeaseUpdate(this, this.isDisposed), "DocumentNodeStore lease update thread");
            this.leaseUpdateThread.start();
        }
        LOG.info("Initialized DocumentNodeStore with clusterNodeId: {}", (Object)this.clusterId);
    }

    private void checkLastRevRecovery() {
        this.lastRevRecoveryAgent.recover(this.clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.runBackgroundOperations();
        if (!this.isDisposed.getAndSet(true)) {
            AtomicBoolean atomicBoolean = this.isDisposed;
            synchronized (atomicBoolean) {
                this.isDisposed.notifyAll();
            }
            try {
                this.backgroundThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.leaseUpdateThread != null) {
                try {
                    this.leaseUpdateThread.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.clusterNodeInfo != null) {
                this.clusterNodeInfo.dispose();
            }
            this.store.dispose();
            LOG.info("Disposed DocumentNodeStore with clusterNodeId: {}", (Object)this.clusterId);
            if (this.blobStore instanceof Closeable) {
                try {
                    ((Closeable)this.blobStore).close();
                }
                catch (IOException ex) {
                    LOG.debug("Error closing blob store " + this.blobStore, (Throwable)ex);
                }
            }
        }
    }

    @Nonnull
    Revision getHeadRevision() {
        return this.headRevision;
    }

    Revision setHeadRevision(@Nonnull Revision newHead) {
        Preconditions.checkArgument((!newHead.isBranch() ? 1 : 0) != 0);
        Revision previous = this.headRevision;
        if (!((Revision)Preconditions.checkNotNull((Object)newHead)).equals(previous)) {
            this.headRevision = newHead;
        }
        return previous;
    }

    @Nonnull
    public DocumentStore getDocumentStore() {
        return this.store;
    }

    @Nonnull
    Revision newRevision() {
        if (this.simpleRevisionCounter != null) {
            return new Revision(this.simpleRevisionCounter.getAndIncrement(), 0, this.clusterId);
        }
        return Revision.newRevision(this.clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Commit newCommit(@Nullable Revision base) {
        Commit c;
        if (base == null) {
            base = this.headRevision;
        }
        this.backgroundOperationLock.readLock().lock();
        boolean success = false;
        try {
            c = new Commit(this, base, this.commitQueue.createRevision());
            success = true;
        }
        finally {
            if (!success) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    MergeCommit newMergeCommit(@Nullable Revision base, int numBranchCommits) {
        MergeCommit c;
        if (base == null) {
            base = this.headRevision;
        }
        this.backgroundOperationLock.readLock().lock();
        boolean success = false;
        try {
            c = new MergeCommit(this, base, this.commitQueue.createRevisions(numBranchCommits));
            success = true;
        }
        finally {
            if (!success) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done(@Nonnull Commit c, boolean isBranch, @Nullable CommitInfo info) {
        try {
            this.commitQueue.done(c, isBranch, info);
        }
        finally {
            this.backgroundOperationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void canceled(Commit c) {
        try {
            this.commitQueue.canceled(c.getRevision());
        }
        finally {
            this.backgroundOperationLock.readLock().unlock();
        }
    }

    public void setAsyncDelay(int delay) {
        this.asyncDelay = delay;
    }

    public int getAsyncDelay() {
        return this.asyncDelay;
    }

    @CheckForNull
    public ClusterNodeInfo getClusterInfo() {
        return this.clusterNodeInfo;
    }

    public CacheStats getNodeCacheStats() {
        return this.nodeCacheStats;
    }

    public CacheStats getNodeChildrenCacheStats() {
        return this.nodeChildrenCacheStats;
    }

    public CacheStats getDocChildrenCacheStats() {
        return this.docChildrenCacheStats;
    }

    void invalidateDocChildrenCache() {
        this.docChildrenCache.invalidateAll();
    }

    public int getPendingWriteCount() {
        return this.unsavedLastRevisions.getPaths().size();
    }

    public boolean isDisableBranches() {
        return this.disableBranches;
    }

    boolean isRevisionNewer(@Nonnull Revision x, @Nonnull Revision previous) {
        return this.getRevisionComparator().compare(x, previous) > 0;
    }

    void addSplitCandidate(String id) {
        this.splitCandidates.put(id, id);
    }

    void copyNode(DocumentNodeState source, String targetPath, Commit commit) {
        this.moveOrCopyNode(false, source, targetPath, commit);
    }

    void moveNode(DocumentNodeState source, String targetPath, Commit commit) {
        this.moveOrCopyNode(true, source, targetPath, commit);
    }

    void markAsDeleted(DocumentNodeState node, Commit commit, boolean subTreeAlso) {
        commit.removeNode(node.getPath());
        if (subTreeAlso) {
            for (DocumentNodeState child : this.getChildNodes(node, null, Integer.MAX_VALUE)) {
                this.markAsDeleted(child, commit, true);
            }
        }
    }

    @CheckForNull
    DocumentNodeState getNode(final @Nonnull String path, final @Nonnull Revision rev) {
        this.checkRevisionAge((Revision)Preconditions.checkNotNull((Object)rev), (String)Preconditions.checkNotNull((Object)path));
        try {
            PathRev key = new PathRev(path, rev);
            DocumentNodeState node = (DocumentNodeState)this.nodeCache.get((Object)key, (Callable)new Callable<DocumentNodeState>(){

                @Override
                public DocumentNodeState call() throws Exception {
                    DocumentNodeState n = DocumentNodeStore.this.readNode(path, rev);
                    if (n == null) {
                        n = DocumentNodeStore.this.missing;
                    }
                    return n;
                }
            });
            return node == this.missing ? null : node;
        }
        catch (ExecutionException e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    DocumentNodeState.Children getChildren(final @Nonnull DocumentNodeState parent, final @Nullable String name, final int limit) throws MicroKernelException {
        DocumentNodeState.Children children;
        if (((DocumentNodeState)Preconditions.checkNotNull((Object)parent)).hasNoChildren()) {
            return DocumentNodeState.NO_CHILDREN;
        }
        String path = ((DocumentNodeState)Preconditions.checkNotNull((Object)parent)).getPath();
        Revision readRevision = parent.getLastRevision();
        PathRev key = DocumentNodeStore.childNodeCacheKey(path, readRevision, name);
        while (true) {
            try {
                children = (DocumentNodeState.Children)this.nodeChildrenCache.get((Object)key, (Callable)new Callable<DocumentNodeState.Children>(){

                    @Override
                    public DocumentNodeState.Children call() throws Exception {
                        return DocumentNodeStore.this.readChildren(parent, name, limit);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new MicroKernelException("Error occurred while fetching children for path " + path, e.getCause());
            }
            if (!children.hasMore || limit <= children.children.size()) break;
            this.nodeChildrenCache.invalidate((Object)key);
        }
        return children;
    }

    DocumentNodeState.Children readChildren(DocumentNodeState parent, String name, int limit) {
        String path = parent.getPath();
        Revision rev = parent.getLastRevision();
        DocumentNodeState.Children c = new DocumentNodeState.Children();
        int rawLimit = (int)Math.min(Integer.MAX_VALUE, (long)limit + 1L);
        while (true) {
            c.children.clear();
            Iterable<NodeDocument> docs = this.readChildDocs(path, name, rawLimit);
            int numReturned = 0;
            for (NodeDocument doc : docs) {
                ++numReturned;
                String p = doc.getPath();
                DocumentNodeState child = this.getNode(p, rev);
                if (child == null) continue;
                if (c.children.size() < limit) {
                    c.children.add(Utils.unshareString(PathUtils.getName((String)p)));
                    continue;
                }
                c.hasMore = true;
                return c;
            }
            if (numReturned < rawLimit) {
                c.hasMore = false;
                return c;
            }
            rawLimit = (int)Math.min((long)rawLimit * 2L, Integer.MAX_VALUE);
        }
    }

    @Nonnull
    Iterable<NodeDocument> readChildDocs(final @Nonnull String path, @Nullable String name, int limit) {
        String to = Utils.getKeyUpperLimit((String)Preconditions.checkNotNull((Object)path));
        String from = name != null ? Utils.getIdFromPath(PathUtils.concat((String)path, (String)name)) : Utils.getKeyLowerLimit(path);
        if (name != null || limit > NUM_CHILDREN_CACHE_LIMIT) {
            return this.store.query(Collection.NODES, from, to, limit);
        }
        StringValue key = new StringValue(path);
        NodeDocument.Children c = (NodeDocument.Children)this.docChildrenCache.getIfPresent((Object)key);
        if (c == null) {
            c = new NodeDocument.Children();
            List<NodeDocument> docs = this.store.query(Collection.NODES, from, to, limit);
            for (NodeDocument doc : docs) {
                String p = doc.getPath();
                c.childNames.add(PathUtils.getName((String)p));
            }
            c.isComplete = docs.size() < limit;
            this.docChildrenCache.put((Object)key, (Object)c);
            return docs;
        }
        if (c.childNames.size() < limit && !c.isComplete) {
            String lastName = c.childNames.get(c.childNames.size() - 1);
            String lastPath = PathUtils.concat((String)path, (String)lastName);
            from = Utils.getIdFromPath(lastPath);
            int remainingLimit = limit - c.childNames.size();
            List<NodeDocument> docs = this.store.query(Collection.NODES, from, to, remainingLimit);
            NodeDocument.Children clone = c.clone();
            for (NodeDocument doc : docs) {
                String p = doc.getPath();
                clone.childNames.add(PathUtils.getName((String)p));
            }
            clone.isComplete = docs.size() < remainingLimit;
            this.docChildrenCache.put((Object)key, (Object)clone);
            c = clone;
        }
        Iterable it = Iterables.transform(c.childNames, (Function)new Function<String, NodeDocument>(){

            public NodeDocument apply(String name) {
                String p = PathUtils.concat((String)path, (String)name);
                NodeDocument doc = DocumentNodeStore.this.store.find(Collection.NODES, Utils.getIdFromPath(p));
                if (doc == null) {
                    DocumentNodeStore.this.docChildrenCache.invalidateAll();
                    throw new NullPointerException("Document " + p + " not found");
                }
                return doc;
            }
        });
        if (c.childNames.size() > limit * 2) {
            it = Iterables.limit((Iterable)it, (int)(limit * 2));
        }
        return it;
    }

    @Nonnull
    Iterable<DocumentNodeState> getChildNodes(final @Nonnull DocumentNodeState parent, @Nullable String name, int limit) {
        if (((DocumentNodeState)Preconditions.checkNotNull((Object)parent)).hasNoChildren()) {
            return Collections.emptyList();
        }
        final Revision readRevision = parent.getLastRevision();
        return Iterables.transform(this.getChildren((DocumentNodeState)parent, (String)name, (int)limit).children, (Function)new Function<String, DocumentNodeState>(){

            public DocumentNodeState apply(String input) {
                String p = PathUtils.concat((String)parent.getPath(), (String)input);
                return DocumentNodeStore.this.getNode(p, readRevision);
            }
        });
    }

    @CheckForNull
    DocumentNodeState readNode(String path, Revision readRevision) {
        String id = Utils.getIdFromPath(path);
        Revision lastRevision = this.getPendingModifications().get(path);
        NodeDocument doc = this.store.find(Collection.NODES, id);
        if (doc == null) {
            return null;
        }
        return doc.getNodeAtRevision(this, readRevision, lastRevision);
    }

    public void applyChanges(Revision rev, String path, boolean isNew, boolean pendingLastRev, boolean isBranchCommit, List<String> added, List<String> removed, List<String> changed, DiffCache.Entry cacheEntry) {
        StringValue docChildrenKey;
        NodeDocument.Children docChildren;
        UnsavedModifications unsaved = this.unsavedLastRevisions;
        if (this.disableBranches) {
            if (pendingLastRev) {
                unsaved.put(path, rev);
            }
        } else {
            if (isBranchCommit) {
                Revision branchRev = rev.asBranchRevision();
                unsaved = this.branches.getBranch(branchRev).getModifications(branchRev);
            }
            if (isBranchCommit || pendingLastRev) {
                unsaved.put(path, rev);
            }
        }
        if (isNew) {
            PathRev key = DocumentNodeStore.childNodeCacheKey(path, rev, null);
            DocumentNodeState.Children c = new DocumentNodeState.Children();
            TreeSet set = Sets.newTreeSet();
            for (String p : added) {
                set.add(Utils.unshareString(PathUtils.getName((String)p)));
            }
            c.children.addAll(set);
            this.nodeChildrenCache.put((Object)key, (Object)c);
        }
        JsopStream w = new JsopStream();
        for (String p : added) {
            w.tag('+').key(PathUtils.getName((String)p)).object().endObject().newline();
        }
        for (String p : removed) {
            w.tag('-').value(PathUtils.getName((String)p)).newline();
        }
        for (String p : changed) {
            w.tag('^').key(PathUtils.getName((String)p)).object().endObject().newline();
        }
        cacheEntry.append(path, w.toString());
        if (!added.isEmpty() && (docChildren = (NodeDocument.Children)this.docChildrenCache.getIfPresent((Object)(docChildrenKey = new StringValue(path)))) != null) {
            int currentSize = docChildren.childNames.size();
            TreeSet names = Sets.newTreeSet(docChildren.childNames);
            if (!docChildren.isComplete) {
                for (String childPath : added) {
                    String name = PathUtils.getName((String)childPath);
                    if (names.higher(name) == null) continue;
                    names.add(Utils.unshareString(name));
                }
            } else {
                for (String childPath : added) {
                    names.add(Utils.unshareString(PathUtils.getName((String)childPath)));
                }
            }
            if (names.size() != currentSize) {
                boolean complete = docChildren.isComplete;
                docChildren = new NodeDocument.Children();
                docChildren.isComplete = complete;
                docChildren.childNames.addAll(names);
                this.docChildrenCache.put((Object)docChildrenKey, (Object)docChildren);
            }
        }
    }

    @CheckForNull
    NodeDocument updateCommitRoot(UpdateOp commit) throws MicroKernelException {
        boolean batch = true;
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> op : commit.getChanges().entrySet()) {
            String name = op.getKey().getName();
            if (NodeDocument.isRevisionsEntry(name) || "_modified".equals(name) || "_collisions".equals(name)) continue;
            batch = false;
            break;
        }
        if (batch) {
            return this.batchUpdateCommitRoot(commit);
        }
        return this.store.findAndUpdate(Collection.NODES, commit);
    }

    private NodeDocument batchUpdateCommitRoot(UpdateOp commit) throws MicroKernelException {
        try {
            return this.batchCommitQueue.updateDocument(commit).call();
        }
        catch (InterruptedException e) {
            throw new MicroKernelException("Interrupted while updating commit root document");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MicroKernelException) {
                throw (MicroKernelException)e.getCause();
            }
            String msg = "Update of commit root document failed";
            throw new MicroKernelException(msg, e.getCause());
        }
        catch (Exception e) {
            if (e instanceof MicroKernelException) {
                throw (MicroKernelException)((Object)e);
            }
            String msg = "Update of commit root document failed";
            throw new MicroKernelException(msg, (Throwable)e);
        }
    }

    @Nonnull
    DocumentNodeState getRoot(@Nonnull Revision revision) {
        DocumentNodeState root = this.getNode("/", revision);
        if (root == null) {
            throw new IllegalStateException("root node does not exist at revision " + revision);
        }
        return root;
    }

    @Nonnull
    DocumentNodeStoreBranch createBranch(DocumentNodeState base) {
        DocumentNodeStoreBranch b = DocumentNodeStoreBranch.getCurrentBranch();
        if (b != null) {
            return b;
        }
        return new DocumentNodeStoreBranch(this, base, this.mergeLock);
    }

    @Nonnull
    Revision rebase(@Nonnull Revision branchHead, @Nonnull Revision base) {
        Preconditions.checkNotNull((Object)branchHead);
        Preconditions.checkNotNull((Object)base);
        if (this.disableBranches) {
            return branchHead;
        }
        Branch b = this.getBranches().getBranch(branchHead);
        if (b == null) {
            return base.asBranchRevision();
        }
        if (b.getBase(branchHead).equals(base)) {
            return branchHead;
        }
        Revision head = this.newRevision().asBranchRevision();
        b.rebase(head, base);
        return head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Revision reset(@Nonnull Revision branchHead, @Nonnull Revision ancestor) {
        Preconditions.checkNotNull((Object)branchHead);
        Preconditions.checkNotNull((Object)ancestor);
        Branch b = this.getBranches().getBranch(branchHead);
        if (b == null) {
            throw new MicroKernelException("Empty branch cannot be reset");
        }
        if (!b.getCommits().last().equals(branchHead)) {
            throw new MicroKernelException(branchHead + " is not the head " + "of a branch");
        }
        if (!b.containsCommit(ancestor)) {
            throw new MicroKernelException(ancestor + " is not " + "an ancestor revision of " + branchHead);
        }
        if (branchHead.equals(ancestor)) {
            return branchHead;
        }
        boolean success = false;
        Commit commit = this.newCommit(branchHead);
        try {
            Iterator it = b.getCommits().tailSet(ancestor).iterator();
            Revision base = (Revision)it.next();
            HashMap operations = Maps.newHashMap();
            while (it.hasNext()) {
                Revision reset = (Revision)it.next();
                this.getRoot(reset).compareAgainstBaseState(this.getRoot(base), new ResetDiff(reset.asTrunkRevision(), operations));
                UpdateOp rootOp = (UpdateOp)operations.get("/");
                if (rootOp == null) {
                    rootOp = new UpdateOp(Utils.getIdFromPath("/"), false);
                    NodeDocument.setModified(rootOp, commit.getRevision());
                    operations.put("/", rootOp);
                }
                NodeDocument.removeCollision(rootOp, reset.asTrunkRevision());
                NodeDocument.removeRevision(rootOp, reset.asTrunkRevision());
            }
            if (this.store.findAndUpdate(Collection.NODES, (UpdateOp)operations.get("/")) != null) {
                ArrayList revs = Lists.newArrayList(b.getCommits().tailSet(ancestor));
                for (Revision r : revs.subList(1, revs.size())) {
                    b.removeCommit(r);
                }
                success = true;
            }
            operations.remove("/");
            for (UpdateOp op : operations.values()) {
                this.store.findAndUpdate(Collection.NODES, op);
            }
        }
        finally {
            if (!success) {
                this.canceled(commit);
            } else {
                this.done(commit, true, null);
            }
        }
        return ancestor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Revision merge(@Nonnull Revision branchHead, @Nullable CommitInfo info) throws CommitFailedException {
        Branch b = this.getBranches().getBranch(branchHead);
        Revision base = branchHead;
        if (b != null) {
            base = b.getBase(branchHead);
        }
        int numBranchCommits = b != null ? b.getCommits().size() : 1;
        boolean success = false;
        MergeCommit commit = this.newMergeCommit(base, numBranchCommits);
        try {
            UpdateOp op = new UpdateOp(Utils.getIdFromPath("/"), false);
            NodeDocument.setModified(op, commit.getRevision());
            if (b != null) {
                Iterator mergeCommits = commit.getMergeRevisions().iterator();
                for (Revision rev : b.getCommits()) {
                    rev = rev.asTrunkRevision();
                    String commitTag = "c-" + mergeCommits.next();
                    NodeDocument.setRevision(op, rev, commitTag);
                    op.containsMapEntry("_collisions", rev, false);
                }
                if (this.store.findAndUpdate(Collection.NODES, op) != null) {
                    b.applyTo(this.getPendingModifications(), commit.getRevision());
                    this.getBranches().remove(b);
                } else {
                    throw new CommitFailedException("Merge", 2, "Conflicting concurrent change. Update operation failed: " + op);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.canceled(commit);
            } else {
                this.done(commit, false, info);
            }
        }
        return commit.getRevision();
    }

    String diffChildren(@Nonnull DocumentNodeState node, @Nonnull DocumentNodeState base) {
        if (node.hasNoChildren() && base.hasNoChildren()) {
            return "";
        }
        String diff = this.diffCache.getChanges(base.getLastRevision(), node.getLastRevision(), node.getPath());
        if (diff == null) {
            diff = this.diffImpl(base, node);
        }
        return diff;
    }

    String diff(@Nonnull String fromRevisionId, @Nonnull String toRevisionId, @Nonnull String path) throws MicroKernelException {
        int r;
        if (fromRevisionId.equals(toRevisionId)) {
            return "";
        }
        Revision fromRev = Revision.fromString(fromRevisionId);
        Revision toRev = Revision.fromString(toRevisionId);
        DocumentNodeState from = this.getNode(path, fromRev);
        DocumentNodeState to = this.getNode(path, toRev);
        if (from == null || to == null) {
            String msg = String.format("Diff is only supported if the node exists in both cases. Node [%s], fromRev [%s] -> %s, toRev [%s] -> %s", path, fromRev, from != null, toRev, to != null);
            throw new MicroKernelException(msg);
        }
        String compactDiff = this.diffCache.getChanges(fromRev, toRev, path);
        if (compactDiff == null) {
            compactDiff = this.diffImpl(from, to);
        }
        JsopStream writer = new JsopStream();
        DocumentNodeStore.diffProperties(from, to, (JsopWriter)writer);
        JsopTokenizer t = new JsopTokenizer(compactDiff);
        do {
            r = t.read();
            switch (r) {
                case 43: 
                case 94: {
                    String name = t.readString();
                    t.read(58);
                    t.read(123);
                    t.read(125);
                    writer.tag((char)r).key(PathUtils.concat((String)path, (String)name));
                    writer.object().endObject().newline();
                    break;
                }
                case 45: {
                    String name = t.readString();
                    writer.tag('-').value(PathUtils.concat((String)path, (String)name));
                    writer.newline();
                }
            }
        } while (r != 0);
        return writer.toString();
    }

    @Override
    public Closeable addObserver(Observer observer) {
        return this.dispatcher.addObserver(observer);
    }

    @Override
    @Nonnull
    public DocumentNodeState getRoot() {
        return this.getRoot(this.headRevision);
    }

    @Override
    @Nonnull
    public NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nonnull CommitInfo info) throws CommitFailedException {
        return DocumentNodeStore.asDocumentRootBuilder(builder).merge(commitHook, info);
    }

    @Override
    @Nonnull
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        return DocumentNodeStore.asDocumentRootBuilder(builder).rebase();
    }

    @Override
    public NodeState reset(@Nonnull NodeBuilder builder) {
        return DocumentNodeStore.asDocumentRootBuilder(builder).reset();
    }

    @Override
    public BlobStoreBlob createBlob(InputStream inputStream) throws IOException {
        return new BlobStoreBlob(this.blobStore, this.blobStore.writeBlob(inputStream));
    }

    @Override
    public Blob getBlob(String reference) {
        String blobId = this.blobStore.getBlobId(reference);
        if (blobId != null) {
            return new BlobStoreBlob(this.blobStore, blobId);
        }
        LOG.debug("No blobId found matching reference [{}]", (Object)reference);
        return null;
    }

    public Blob getBlobFromBlobId(String blobId) {
        return new BlobStoreBlob(this.blobStore, blobId);
    }

    @Override
    @Nonnull
    public String checkpoint(long lifetime) {
        return this.checkpoints.create(lifetime).toString();
    }

    @Override
    @CheckForNull
    public NodeState retrieve(@Nonnull String checkpoint) {
        return this.getRoot(Revision.fromString(checkpoint));
    }

    @Override
    public UnmergedBranches getBranches() {
        return this.branches;
    }

    @Override
    public UnsavedModifications getPendingModifications() {
        return this.unsavedLastRevisions;
    }

    public Revision.RevisionComparator getRevisionComparator() {
        return this.revisionComparator;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    public synchronized void runBackgroundOperations() {
        if (this.isDisposed.get()) {
            return;
        }
        if (this.simpleRevisionCounter != null) {
            return;
        }
        if (!ENABLE_BACKGROUND_OPS) {
            return;
        }
        try {
            this.backgroundSplit();
            this.backgroundWrite();
            this.backgroundRead(true);
        }
        catch (RuntimeException e) {
            if (this.isDisposed.get()) {
                return;
            }
            throw e;
        }
    }

    void renewClusterIdLease() {
        if (this.clusterNodeInfo == null) {
            return;
        }
        this.clusterNodeInfo.renewLease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void backgroundRead(boolean dispatchChange) {
        String id = Utils.getIdFromPath("/");
        NodeDocument doc = this.store.find(Collection.NODES, id, this.asyncDelay);
        if (doc == null) {
            return;
        }
        Map<Integer, Revision> lastRevMap = doc.getLastRev();
        Revision.RevisionComparator revisionComparator = this.getRevisionComparator();
        Revision headSeen = Revision.newRevision(0);
        Revision otherSeen = Revision.newRevision(0);
        HashMap externalChanges = Maps.newHashMap();
        for (Map.Entry<Integer, Revision> entry : lastRevMap.entrySet()) {
            int machineId = entry.getKey();
            if (machineId == this.clusterId) continue;
            Revision r = entry.getValue();
            Revision last = this.lastKnownRevision.get(machineId);
            if (last != null && r.compareRevisionTime(last) <= 0) continue;
            this.lastKnownRevision.put(machineId, r);
            externalChanges.put(r, otherSeen);
        }
        if (!externalChanges.isEmpty()) {
            this.store.invalidateCache();
            this.docChildrenCache.invalidateAll();
            this.backgroundOperationLock.writeLock().lock();
            try {
                revisionComparator.add(this.newRevision(), headSeen);
                for (Map.Entry<Integer, Revision> entry : externalChanges.entrySet()) {
                    revisionComparator.add((Revision)((Object)entry.getKey()), entry.getValue());
                }
                this.setHeadRevision(this.newRevision());
                if (dispatchChange) {
                    this.dispatcher.contentChanged(this.getRoot(), null);
                }
            }
            finally {
                this.backgroundOperationLock.writeLock().unlock();
            }
        }
        revisionComparator.purge(Revision.getCurrentTimestamp() - 3600000L);
    }

    private void backgroundSplit() {
        Iterator<String> it = this.splitCandidates.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            NodeDocument doc = this.store.find(Collection.NODES, id);
            if (doc == null) continue;
            for (UpdateOp op : doc.split(this)) {
                NodeDocument before = this.store.createOrUpdate(Collection.NODES, op);
                if (before != null) {
                    NodeDocument after = this.store.find(Collection.NODES, op.getId());
                    if (after == null) continue;
                    LOG.debug("Split operation on {}. Size before: {}, after: {}", new Object[]{id, before.getMemory(), after.getMemory()});
                    continue;
                }
                LOG.debug("Split operation created {}", (Object)op.getId());
            }
            it.remove();
        }
    }

    void backgroundWrite() {
        this.unsavedLastRevisions.persist(this, this.backgroundOperationLock.writeLock());
    }

    private static void diffProperties(DocumentNodeState from, DocumentNodeState to, JsopWriter w) {
        for (PropertyState propertyState : from.getProperties()) {
            String name;
            PropertyState toValue;
            if (propertyState.equals(toValue = to.getProperty(name = propertyState.getName()))) continue;
            w.tag('^').key(PathUtils.concat((String)from.getPath(), (String)name));
            if (toValue == null) {
                w.value(null);
                continue;
            }
            w.encodedValue(to.getPropertyAsString(name)).newline();
        }
        for (String string : to.getPropertyNames()) {
            if (from.hasProperty(string)) continue;
            w.tag('^').key(PathUtils.concat((String)from.getPath(), (String)string)).encodedValue(to.getPropertyAsString(string)).newline();
        }
    }

    private String diffImpl(DocumentNodeState from, DocumentNodeState to) throws MicroKernelException {
        JsopStream w = new JsopStream();
        int max = DocumentMK.MANY_CHILDREN_THRESHOLD;
        DocumentNodeState.Children fromChildren = this.getChildren(from, null, max);
        DocumentNodeState.Children toChildren = this.getChildren(to, null, max);
        if (!fromChildren.hasMore && !toChildren.hasMore) {
            this.diffFewChildren((JsopWriter)w, from.getPath(), fromChildren, from.getLastRevision(), toChildren, to.getLastRevision());
        } else if (DocumentMK.FAST_DIFF) {
            this.diffManyChildren((JsopWriter)w, from.getPath(), from.getLastRevision(), to.getLastRevision());
        } else {
            max = Integer.MAX_VALUE;
            fromChildren = this.getChildren(from, null, max);
            toChildren = this.getChildren(to, null, max);
            this.diffFewChildren((JsopWriter)w, from.getPath(), fromChildren, from.getLastRevision(), toChildren, to.getLastRevision());
        }
        return w.toString();
    }

    private void diffManyChildren(JsopWriter w, String path, Revision fromRev, Revision toRev) {
        long minTimestamp = Math.min(fromRev.getTimestamp(), toRev.getTimestamp());
        long minValue = Commit.getModifiedInSecs(minTimestamp);
        String fromKey = Utils.getKeyLowerLimit(path);
        String toKey = Utils.getKeyUpperLimit(path);
        HashSet paths = Sets.newHashSet();
        for (NodeDocument doc : this.store.query(Collection.NODES, fromKey, toKey, "_modified", minValue, Integer.MAX_VALUE)) {
            paths.add(doc.getPath());
        }
        Revision minRev = new Revision(minTimestamp, 0, this.getClusterId());
        DocumentNodeStore.addPathsForDiff(path, paths, this.getPendingModifications(), minRev);
        for (Revision r : new Revision[]{fromRev, toRev}) {
            Branch b;
            if (!r.isBranch() || (b = this.getBranches().getBranch(r)) == null) continue;
            DocumentNodeStore.addPathsForDiff(path, paths, b.getModifications(r), r);
        }
        for (String p : paths) {
            DocumentNodeState fromNode = this.getNode(p, fromRev);
            DocumentNodeState toNode = this.getNode(p, toRev);
            String name = PathUtils.getName((String)p);
            if (fromNode != null) {
                if (toNode != null) {
                    if (fromNode.getLastRevision().equals(toNode.getLastRevision())) continue;
                    w.tag('^').key(name).object().endObject().newline();
                    continue;
                }
                w.tag('-').value(name).newline();
                continue;
            }
            if (toNode == null) continue;
            w.tag('+').key(name).object().endObject().newline();
        }
    }

    private static void addPathsForDiff(String path, Set<String> paths, UnsavedModifications pending, Revision minRev) {
        for (String p : pending.getPaths(minRev)) {
            String parent;
            if (PathUtils.denotesRoot((String)p) || !path.equals(parent = PathUtils.getParentPath((String)p))) continue;
            paths.add(p);
        }
    }

    private void diffFewChildren(JsopWriter w, String parentPath, DocumentNodeState.Children fromChildren, Revision fromRev, DocumentNodeState.Children toChildren, Revision toRev) {
        HashSet childrenSet = Sets.newHashSet(toChildren.children);
        for (String n : fromChildren.children) {
            if (!childrenSet.contains(n)) {
                w.tag('-').value(n).newline();
                continue;
            }
            String path = PathUtils.concat((String)parentPath, (String)n);
            DocumentNodeState n1 = this.getNode(path, fromRev);
            DocumentNodeState n2 = this.getNode(path, toRev);
            Preconditions.checkNotNull((Object)n1, (String)"Node at [%s] not found for fromRev [%s]", (Object[])new Object[]{path, fromRev});
            Preconditions.checkNotNull((Object)n2, (String)"Node at [%s] not found for toRev [%s]", (Object[])new Object[]{path, toRev});
            if (n1.getLastRevision().equals(n2.getLastRevision())) continue;
            w.tag('^').key(n).object().endObject().newline();
        }
        childrenSet = Sets.newHashSet(fromChildren.children);
        for (String n : toChildren.children) {
            if (childrenSet.contains(n)) continue;
            w.tag('+').key(n).object().endObject().newline();
        }
    }

    private static PathRev childNodeCacheKey(@Nonnull String path, @Nonnull Revision readRevision, @Nullable String name) {
        return new PathRev((name == null ? "" : name) + path, readRevision);
    }

    private static DocumentRootBuilder asDocumentRootBuilder(NodeBuilder builder) throws IllegalArgumentException {
        if (!(builder instanceof DocumentRootBuilder)) {
            throw new IllegalArgumentException("builder must be a " + DocumentRootBuilder.class.getName());
        }
        return (DocumentRootBuilder)builder;
    }

    private void moveOrCopyNode(boolean move, DocumentNodeState source, String targetPath, Commit commit) {
        DocumentNodeState newNode = new DocumentNodeState(this, targetPath, commit.getRevision());
        source.copyTo(newNode);
        commit.addNode(newNode);
        if (move) {
            this.markAsDeleted(source, commit, false);
        }
        for (DocumentNodeState child : this.getChildNodes(source, null, Integer.MAX_VALUE)) {
            String childName = PathUtils.getName((String)child.getPath());
            String destChildPath = PathUtils.concat((String)targetPath, (String)childName);
            this.moveOrCopyNode(move, child, destChildPath, commit);
        }
    }

    private void checkRevisionAge(Revision r, String path) {
        if (LOG.isDebugEnabled() && this.headRevision.getTimestamp() - r.getTimestamp() > (long)WARN_REVISION_AGE) {
            LOG.debug("Requesting an old revision for path " + path + ", " + (this.headRevision.getTimestamp() - r.getTimestamp()) / 1000L + " seconds old");
        }
    }

    @CheckForNull
    public MarkSweepGarbageCollector createBlobGarbageCollector(long blobGcMaxAgeInSecs) {
        MarkSweepGarbageCollector blobGC = null;
        if (this.blobStore instanceof GarbageCollectableBlobStore) {
            try {
                blobGC = new MarkSweepGarbageCollector(new DocumentBlobReferenceRetriever(this), (GarbageCollectableBlobStore)this.blobStore, this.executor, TimeUnit.SECONDS.toMillis(blobGcMaxAgeInSecs));
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while initializing the MarkSweepGarbageCollector", e);
            }
        }
        return blobGC;
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    BlobSerializer getBlobSerializer() {
        return this.blobSerializer;
    }

    public Iterator<Blob> getReferencedBlobsIterator() {
        if (this.store instanceof MongoDocumentStore) {
            return new MongoBlobReferenceIterator(this, (MongoDocumentStore)this.store);
        }
        return new BlobReferenceIterator(this);
    }

    public DiffCache getDiffCache() {
        return this.diffCache;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Checkpoints getCheckpoints() {
        return this.checkpoints;
    }

    @Nonnull
    public VersionGarbageCollector getVersionGarbageCollector() {
        return this.versionGarbageCollector;
    }

    @Nonnull
    public LastRevRecoveryAgent getLastRevRecoveryAgent() {
        return this.lastRevRecoveryAgent;
    }

    static class BackgroundLeaseUpdate
    extends NodeStoreTask {
        BackgroundLeaseUpdate(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed);
        }

        @Override
        protected void execute(@Nonnull DocumentNodeStore nodeStore) {
            nodeStore.renewClusterIdLease();
        }
    }

    static class BackgroundOperation
    extends NodeStoreTask {
        BackgroundOperation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed);
        }

        @Override
        protected void execute(@Nonnull DocumentNodeStore nodeStore) {
            nodeStore.runBackgroundOperations();
        }
    }

    static abstract class NodeStoreTask
    implements Runnable {
        final WeakReference<DocumentNodeStore> ref;
        private final AtomicBoolean isDisposed;
        private int delay;

        NodeStoreTask(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            this.ref = new WeakReference<DocumentNodeStore>(nodeStore);
            this.delay = nodeStore.getAsyncDelay();
            this.isDisposed = isDisposed;
        }

        protected abstract void execute(@Nonnull DocumentNodeStore var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.delay != 0 && !this.isDisposed.get()) {
                AtomicBoolean atomicBoolean = this.isDisposed;
                synchronized (atomicBoolean) {
                    try {
                        this.isDisposed.wait(this.delay);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                DocumentNodeStore nodeStore = (DocumentNodeStore)this.ref.get();
                if (nodeStore == null) break;
                try {
                    this.execute(nodeStore);
                }
                catch (Throwable t) {
                    LOG.warn("Background operation failed: " + t.toString(), t);
                }
                this.delay = nodeStore.getAsyncDelay();
            }
        }
    }
}

