/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;

public class UpdateUtils {
    public static void applyChanges(@Nonnull Document doc, @Nonnull UpdateOp update, @Nonnull Comparator<Revision> comparator) {
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> e : ((UpdateOp)Preconditions.checkNotNull((Object)update)).getChanges().entrySet()) {
            UpdateOp.Key k = e.getKey();
            UpdateOp.Operation op = e.getValue();
            switch (op.type) {
                case SET: {
                    doc.put(k.toString(), op.value);
                    break;
                }
                case INCREMENT: {
                    Object old = doc.get(k.toString());
                    Long x = (Long)op.value;
                    if (old == null) {
                        old = 0L;
                    }
                    doc.put(k.toString(), (Long)old + x);
                    break;
                }
                case SET_MAP_ENTRY: {
                    Object old = doc.get(k.getName());
                    TreeMap<Revision, Object> m = (TreeMap<Revision, Object>)old;
                    if (m == null) {
                        m = new TreeMap<Revision, Object>(comparator);
                        doc.put(k.getName(), m);
                    }
                    if (k.getRevision() == null) {
                        throw new IllegalArgumentException("Cannot set map entry " + k.getName() + " with null revision");
                    }
                    m.put(k.getRevision(), op.value);
                    break;
                }
                case REMOVE_MAP_ENTRY: {
                    Object old = doc.get(k.getName());
                    TreeMap<Revision, Object> m = (Map)old;
                    if (m == null) break;
                    m.remove(k.getRevision());
                    break;
                }
            }
        }
    }

    public static boolean checkConditions(@Nonnull Document doc, @Nonnull UpdateOp update) {
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> change : update.getChanges().entrySet()) {
            UpdateOp.Operation op = change.getValue();
            if (op.type != UpdateOp.Operation.Type.CONTAINS_MAP_ENTRY) continue;
            UpdateOp.Key k = change.getKey();
            Revision r = k.getRevision();
            if (r == null) {
                throw new IllegalStateException("CONTAINS_MAP_ENTRY must not contain null revision");
            }
            Object value = doc.get(k.getName());
            if (value == null) {
                if (!Boolean.TRUE.equals(op.value)) continue;
                return false;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                if (!(Boolean.TRUE.equals(op.value) ? !map.containsKey(r) : map.containsKey(r))) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

