/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Queues;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import java.io.Closeable;
import java.util.Queue;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.document.BlobCollector;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;

public class MongoBlobReferenceIterator
extends AbstractIterator<Blob>
implements Closeable {
    private final MongoDocumentStore documentStore;
    private final BlobCollector blobCollector;
    private final Queue<Blob> blobs = Queues.newArrayDeque();
    private DBCursor cursor;

    public MongoBlobReferenceIterator(DocumentNodeStore nodeStore, MongoDocumentStore documentStore) {
        this.documentStore = documentStore;
        this.blobCollector = new BlobCollector(nodeStore);
    }

    protected Blob computeNext() {
        if (this.blobs.isEmpty()) {
            this.loadBatch();
        }
        if (!this.blobs.isEmpty()) {
            return this.blobs.remove();
        }
        return (Blob)this.endOfData();
    }

    private void loadBatch() {
        this.initializeCursor();
        while (this.cursor.hasNext() && this.blobs.isEmpty()) {
            this.collectBinaries(this.documentStore.convertFromDBObject(Collection.NODES, this.cursor.next()));
        }
    }

    private void collectBinaries(NodeDocument nodeDocument) {
        this.blobCollector.collect(nodeDocument, this.blobs);
    }

    private void initializeCursor() {
        if (this.cursor == null) {
            DBObject query = QueryBuilder.start((String)"_bin").is((Object)1L).get();
            this.cursor = this.getNodeCollection().find(query).setReadPreference(ReadPreference.secondaryPreferred());
        }
    }

    private DBCollection getNodeCollection() {
        return this.documentStore.getDBCollection(Collection.NODES);
    }

    @Override
    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }
}

