/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.Closeable;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoVersionGCSupport
extends VersionGCSupport {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MongoDocumentStore store;

    public MongoVersionGCSupport(MongoDocumentStore store) {
        super(store);
        this.store = store;
    }

    public CloseableIterable<NodeDocument> getPossiblyDeletedDocs(long lastModifiedTime) {
        DBObject query = QueryBuilder.start((String)"_deletedOnce").is((Object)Boolean.TRUE).put("_modified").lessThan((Object)Commit.getModifiedInSecs(lastModifiedTime)).get();
        DBCursor cursor = this.getNodeCollection().find(query).setReadPreference(ReadPreference.secondaryPreferred());
        return CloseableIterable.wrap(Iterables.transform((Iterable)cursor, (Function)new Function<DBObject, NodeDocument>(){

            public NodeDocument apply(DBObject input) {
                return MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, input);
            }
        }), (Closeable)cursor);
    }

    @Override
    public int deleteSplitDocuments(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp) {
        WriteResult writeResult;
        QueryBuilder orClause = QueryBuilder.start();
        for (NodeDocument.SplitDocType type : gcTypes) {
            orClause.or(new DBObject[]{QueryBuilder.start((String)"_sdType").is((Object)type.typeCode()).get()});
        }
        DBObject query = QueryBuilder.start().and(new DBObject[]{orClause.get(), QueryBuilder.start((String)"_sdMaxRevTime").lessThan((Object)Commit.getModifiedInSecs(oldestRevTimeStamp)).get()}).get();
        if (this.log.isDebugEnabled()) {
            this.logSplitDocIdsTobeDeleted(query);
        }
        if ((writeResult = this.getNodeCollection().remove(query, WriteConcern.SAFE)).getError() != null) {
            this.log.warn("Error occurred while deleting old split documents from Mongo {}", (Object)writeResult.getError());
        }
        return writeResult.getN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSplitDocIdsTobeDeleted(DBObject query) {
        ImmutableList ids;
        BasicDBObject keys = new BasicDBObject("_id", (Object)1);
        DBCursor cursor = this.getNodeCollection().find(query, (DBObject)keys).setReadPreference(ReadPreference.secondaryPreferred());
        try {
            ids = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)cursor, (Function)new Function<DBObject, String>(){

                public String apply(@Nullable DBObject input) {
                    return (String)input.get("_id");
                }
            }));
        }
        finally {
            cursor.close();
        }
        StringBuilder sb = new StringBuilder("Split documents with following ids were deleted as part of GC \n");
        Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, (Iterable)ids);
        this.log.debug(sb.toString());
    }

    private DBCollection getNodeCollection() {
        return this.store.getDBCollection(Collection.NODES);
    }
}

