/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWrapper<T extends MicroKernel>
implements MicroKernel {
    private static final Logger LOG = LoggerFactory.getLogger(LogWrapper.class);
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("mk.debug", "true"));
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    private final T mk;
    private final int id = NEXT_ID.getAndIncrement();

    public LogWrapper(T mk) {
        this.mk = mk;
    }

    public T unwrap() {
        return this.mk;
    }

    public String commit(String path, String jsonDiff, String revisionId, String message) {
        try {
            this.logMethod("commit", path, jsonDiff, revisionId, message);
            String result = this.mk.commit(path, jsonDiff, revisionId, message);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String getHeadRevision() {
        try {
            this.logMethod("getHeadRevision", new Object[0]);
            String result = this.mk.getHeadRevision();
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    @Nonnull
    public String checkpoint(long lifetime) {
        try {
            this.logMethod("checkpoint", lifetime);
            String result = this.mk.checkpoint(lifetime);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String getJournal(String fromRevisionId, String toRevisionId, String path) {
        try {
            this.logMethod("getJournal", fromRevisionId, toRevisionId);
            String result = this.mk.getJournal(fromRevisionId, toRevisionId, path);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String diff(String fromRevisionId, String toRevisionId, String path, int depth) {
        try {
            this.logMethod("diff", fromRevisionId, toRevisionId, path);
            String result = this.mk.diff(fromRevisionId, toRevisionId, path, depth);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public long getLength(String blobId) {
        try {
            this.logMethod("getLength", blobId);
            long result = this.mk.getLength(blobId);
            LogWrapper.logResult(Long.toString(result));
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) {
        try {
            this.logMethod("getNodes", path, revisionId, depth, offset, maxChildNodes, filter);
            String result = this.mk.getNodes(path, revisionId, depth, offset, maxChildNodes, filter);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String getRevisionHistory(long since, int maxEntries, String path) {
        try {
            this.logMethod("getRevisionHistory", since, maxEntries, path);
            String result = this.mk.getRevisionHistory(since, maxEntries, path);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public boolean nodeExists(String path, String revisionId) {
        try {
            this.logMethod("nodeExists", path, revisionId);
            boolean result = this.mk.nodeExists(path, revisionId);
            LogWrapper.logResult(Boolean.toString(result));
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public long getChildNodeCount(String path, String revisionId) {
        try {
            this.logMethod("getChildNodeCount", path, revisionId);
            long result = this.mk.getChildNodeCount(path, revisionId);
            LogWrapper.logResult(Long.toString(result));
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) {
        try {
            this.logMethod("read", blobId, pos, buff, off, length);
            int result = this.mk.read(blobId, pos, buff, off, length);
            LogWrapper.logResult(Integer.toString(result));
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String waitForCommit(String oldHeadRevisionId, long maxWaitMillis) throws InterruptedException {
        try {
            this.logMethod("waitForCommit", oldHeadRevisionId, maxWaitMillis);
            String result = this.mk.waitForCommit(oldHeadRevisionId, maxWaitMillis);
            LogWrapper.logResult(result);
            return result;
        }
        catch (InterruptedException e) {
            LogWrapper.logException(e);
            throw e;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String write(InputStream in) {
        try {
            this.logMethod("write", in.toString());
            String result = this.mk.write(in);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String branch(String trunkRevisionId) {
        try {
            this.logMethod("branch", trunkRevisionId);
            String result = this.mk.branch(trunkRevisionId);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String merge(String branchRevisionId, String message) {
        try {
            this.logMethod("merge", branchRevisionId, message);
            String result = this.mk.merge(branchRevisionId, message);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    public String rebase(String branchRevisionId, String newBaseRevisionId) {
        try {
            this.logMethod("rebase", branchRevisionId, newBaseRevisionId);
            String result = this.mk.rebase(branchRevisionId, newBaseRevisionId);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    @Nonnull
    public String reset(@Nonnull String branchRevisionId, @Nonnull String ancestorRevisionId) throws MicroKernelException {
        try {
            this.logMethod("reset", branchRevisionId, ancestorRevisionId);
            String result = this.mk.reset(branchRevisionId, ancestorRevisionId);
            LogWrapper.logResult(result);
            return result;
        }
        catch (Exception e) {
            LogWrapper.logException(e);
            throw LogWrapper.convert(e);
        }
    }

    private void logMethod(String methodName, Object ... args) {
        StringBuilder buff = new StringBuilder("mk");
        buff.append(this.id).append('.').append(methodName).append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(LogWrapper.quote(args[i]));
        }
        buff.append(");");
        LogWrapper.log(buff.toString());
    }

    public static String quote(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return JsopBuilder.encode((String)((String)o));
        }
        return o.toString();
    }

    private static RuntimeException convert(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        LogWrapper.log("// unexpected exception type: " + e.getClass().getName());
        return new MicroKernelException("Unexpected exception: " + e.toString(), (Throwable)e);
    }

    private static void logException(Exception e) {
        LogWrapper.log("// exception: " + e.toString());
    }

    private static void logResult(Object result) {
        LogWrapper.log("// " + LogWrapper.quote(result));
    }

    private static void log(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
        LOG.info(message);
    }
}

