/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.StringBasedBlob;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.plugins.value.ValueImpl;

public class BinaryPropertyState
extends SinglePropertyState<Blob> {
    private final Blob value;

    public BinaryPropertyState(@Nonnull String name, @Nonnull Blob value) {
        super(name);
        this.value = (Blob)Preconditions.checkNotNull((Object)value);
    }

    public static PropertyState binaryProperty(@Nonnull String name, @Nonnull byte[] value) {
        return new BinaryPropertyState(name, new ArrayBasedBlob((byte[])Preconditions.checkNotNull((Object)value)));
    }

    public static PropertyState binaryProperty(@Nonnull String name, @Nonnull String value) {
        return new BinaryPropertyState(name, new StringBasedBlob((String)Preconditions.checkNotNull((Object)value)));
    }

    public static PropertyState binaryProperty(@Nonnull String name, @Nonnull Blob value) {
        return new BinaryPropertyState(name, value);
    }

    public static PropertyState binaryProperty(@Nonnull String name, @Nonnull Value value) {
        return new BinaryPropertyState(name, ValueImpl.getBlob(value));
    }

    @Override
    public Blob getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value);
    }

    @Override
    public long size() {
        return this.value.length();
    }

    @Override
    public Type<?> getType() {
        return Type.BINARY;
    }
}

