/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DecimalPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.GenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiBinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiBooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiDecimalPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiDoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiGenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiLongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiStringPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;

public class PropertyBuilder<T> {
    private final Type<T> type;
    private String name;
    private boolean isArray;
    private List<T> values = Lists.newArrayList();

    public PropertyBuilder(Type<T> type) {
        Preconditions.checkArgument((!type.isArray() ? 1 : 0) != 0, (Object)"type must not be array");
        this.type = type;
    }

    public static <T> PropertyBuilder<T> scalar(Type<T> type) {
        return new PropertyBuilder<T>(type);
    }

    public static <T> PropertyBuilder<T> array(Type<T> type) {
        return new PropertyBuilder<T>(type).setArray();
    }

    public static <T> PropertyBuilder<T> scalar(Type<T> type, String name) {
        return PropertyBuilder.scalar(type).setName(name);
    }

    public static <T> PropertyBuilder<T> array(Type<T> type, String name) {
        return PropertyBuilder.scalar(type).setName(name).setArray();
    }

    public static <T> PropertyBuilder<T> copy(Type<T> type, PropertyState property) {
        return PropertyBuilder.scalar(type).assignFrom(property);
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.values.isEmpty() ? null : (T)this.values.get(0);
    }

    @Nonnull
    public List<T> getValues() {
        return Lists.newArrayList(this.values);
    }

    public T getValue(int index) {
        return this.values.get(index);
    }

    public boolean hasValue(Object value) {
        return this.values.contains(value);
    }

    public int count() {
        return this.values.size();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Nonnull
    public PropertyState getPropertyState() {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Property has no name");
        Preconditions.checkState((this.isArray() || this.values.size() == 1 ? 1 : 0) != 0, (Object)"Property has multiple values");
        if (this.values.isEmpty()) {
            return EmptyPropertyState.emptyProperty(this.name, Type.fromTag(this.type.tag(), true));
        }
        if (this.isArray()) {
            switch (this.type.tag()) {
                case 1: {
                    return MultiStringPropertyState.stringProperty(this.name, this.values);
                }
                case 2: {
                    return MultiBinaryPropertyState.binaryPropertyFromBlob(this.name, this.values);
                }
                case 3: {
                    return MultiLongPropertyState.createLongProperty(this.name, this.values);
                }
                case 4: {
                    return MultiDoublePropertyState.doubleProperty(this.name, this.values);
                }
                case 6: {
                    return MultiBooleanPropertyState.booleanProperty(this.name, this.values);
                }
                case 12: {
                    return MultiDecimalPropertyState.decimalProperty(this.name, this.values);
                }
            }
            return new MultiGenericPropertyState(this.name, this.values, Type.fromTag(this.type.tag(), true));
        }
        T value = this.values.get(0);
        switch (this.type.tag()) {
            case 1: {
                return StringPropertyState.stringProperty(this.name, (String)value);
            }
            case 2: {
                return BinaryPropertyState.binaryProperty(this.name, (Blob)value);
            }
            case 3: {
                return LongPropertyState.createLongProperty(this.name, (Long)value);
            }
            case 4: {
                return DoublePropertyState.doubleProperty(this.name, (Double)value);
            }
            case 6: {
                return BooleanPropertyState.booleanProperty(this.name, (Boolean)value);
            }
            case 12: {
                return DecimalPropertyState.decimalProperty(this.name, (BigDecimal)value);
            }
        }
        return new GenericPropertyState(this.name, (String)value, this.type);
    }

    @Nonnull
    public PropertyBuilder<T> assignFrom(PropertyState property) {
        if (property != null) {
            this.setName(property.getName());
            if (property.isArray()) {
                this.isArray = true;
                this.setValues((Iterable)property.getValue(this.type.getArrayType()));
            } else {
                this.isArray = false;
                this.setValue(property.getValue(this.type));
            }
        }
        return this;
    }

    @Nonnull
    public PropertyBuilder<T> setName(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public PropertyBuilder<T> setArray() {
        this.isArray = true;
        return this;
    }

    @Nonnull
    public PropertyBuilder<T> setScalar() {
        this.isArray = false;
        return this;
    }

    @Nonnull
    public PropertyBuilder<T> setValue(T value) {
        this.values.clear();
        this.values.add(value);
        return this;
    }

    @Nonnull
    public PropertyBuilder<T> addValue(T value) {
        this.values.add(value);
        return this;
    }

    @Nonnull
    public PropertyBuilder<T> setValue(T value, int index) {
        this.values.set(index, value);
        return this;
    }

    @Nonnull
    public PropertyBuilder<T> setValues(Iterable<T> values) {
        this.values = Lists.newArrayList(values);
        return this;
    }

    @Nonnull
    public PropertyBuilder<T> removeValue(int index) {
        this.values.remove(index);
        return this;
    }

    @Nonnull
    public PropertyBuilder<T> removeValue(Object value) {
        this.values.remove(value);
        return this;
    }
}

