/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.constraint;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.NumericConstraint;
import org.apache.jackrabbit.value.DateValue;

public class DateConstraint
extends NumericConstraint<Calendar> {
    public DateConstraint(String definition) {
        super(definition);
    }

    @Override
    protected Calendar getBound(String bound) {
        try {
            return DateValue.valueOf((String)bound).getDate();
        }
        catch (RepositoryException e) {
            throw (NumberFormatException)new NumberFormatException().initCause(e);
        }
    }

    @Override
    protected Calendar getValue(Value value) throws RepositoryException {
        return value.getDate();
    }

    @Override
    protected boolean less(Calendar val, Calendar bound) {
        return val.getTimeInMillis() < bound.getTimeInMillis();
    }

    @Override
    protected boolean equals(Calendar val, Calendar bound) {
        return val.getTimeInMillis() == bound.getTimeInMillis();
    }
}

