/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.core.SystemRoot;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.plugins.nodetype.NodeTypeConstants;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.write.BuiltInNodeTypes;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class InitialContent
implements RepositoryInitializer,
NodeTypeConstants {
    public static final NodeState INITIAL_CONTENT = InitialContent.createInitialContent();

    private static NodeState createInitialContent() {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        new InitialContent().initialize(builder);
        return ModifiedNodeState.squeeze(builder.getNodeState());
    }

    @Override
    public void initialize(NodeBuilder builder) {
        builder.setProperty("jcr:primaryType", "rep:root", Type.NAME);
        if (!builder.hasChildNode("jcr:system")) {
            NodeBuilder system = builder.child("jcr:system");
            system.setProperty("jcr:primaryType", "rep:system", Type.NAME);
            system.child("jcr:versionStorage").setProperty("jcr:primaryType", "rep:versionStorage", Type.NAME);
            system.child("jcr:nodeTypes").setProperty("jcr:primaryType", "rep:nodeTypes", Type.NAME);
            system.child("jcr:activities").setProperty("jcr:primaryType", "rep:Activities", Type.NAME);
            Namespaces.setupNamespaces(system);
        }
        if (!builder.hasChildNode("oak:index")) {
            NodeBuilder index = IndexUtils.getOrCreateOakIndex(builder);
            IndexUtils.createIndexDefinition(index, "uuid", true, true, (Collection<String>)ImmutableList.of((Object)"jcr:uuid"), null);
            NodeBuilder nt = IndexUtils.createIndexDefinition(index, "nodetype", true, false, (Collection<String>)ImmutableList.of((Object)"jcr:primaryType", (Object)"jcr:mixinTypes"), null);
            nt.setProperty("entryCount", Long.MAX_VALUE);
            IndexUtils.createReferenceIndex(index);
        }
        NodeState base = builder.getNodeState();
        MemoryNodeStore store = new MemoryNodeStore(base);
        BuiltInNodeTypes.register(new SystemRoot(store, new EditorHook(new CompositeEditorProvider(new NamespaceEditorProvider(), new TypeEditorProvider()))));
        NodeState target = store.getRoot();
        target.compareAgainstBaseState(base, new ApplyDiff(builder));
    }
}

