/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.observation.filter.RelativePathSelector;
import org.apache.jackrabbit.oak.plugins.observation.filter.UniversalFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public final class Selectors {
    public static final UniversalFilter.Selector THIS = new ThisSelector();
    public static final UniversalFilter.Selector PARENT = new ParentSelector();

    @Nonnull
    public static UniversalFilter.Selector fromThis(@Nonnull String relPath) {
        return new RelativePathSelector(relPath, THIS);
    }

    @Nonnull
    public static UniversalFilter.Selector fromParent(@Nonnull String relPath) {
        return new RelativePathSelector(relPath, PARENT);
    }

    private Selectors() {
    }

    private static class ParentSelector
    implements UniversalFilter.Selector {
        private ParentSelector() {
        }

        @Override
        public NodeState select(@Nonnull UniversalFilter filter, @CheckForNull PropertyState before, @CheckForNull PropertyState after) {
            return after != null ? filter.getAfterState() : filter.getBeforeState();
        }

        @Override
        public NodeState select(@Nonnull UniversalFilter filter, @Nonnull String name, @Nonnull NodeState before, @Nonnull NodeState after) {
            return after.exists() ? filter.getAfterState() : filter.getBeforeState();
        }
    }

    private static class ThisSelector
    implements UniversalFilter.Selector {
        private ThisSelector() {
        }

        @Override
        public NodeState select(@Nonnull UniversalFilter filter, @CheckForNull PropertyState before, @CheckForNull PropertyState after) {
            return EmptyNodeState.MISSING_NODE;
        }

        @Override
        public NodeState select(@Nonnull UniversalFilter filter, @Nonnull String name, @Nonnull NodeState before, @Nonnull NodeState after) {
            return after.exists() ? after : before;
        }
    }
}

