/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.segment.Record;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.memory.MemoryStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class SegmentNodeStore
implements NodeStore,
Observable {
    static final String ROOT = "root";
    private final SegmentStore store;
    private final ChangeDispatcher changeDispatcher;
    private final AtomicReference<SegmentNodeState> head;
    private final Semaphore commitSemaphore = new Semaphore(1);
    private long maximumBackoff = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS);

    public SegmentNodeStore(SegmentStore store) {
        this.store = store;
        this.head = new AtomicReference<SegmentNodeState>(store.getHead());
        this.changeDispatcher = new ChangeDispatcher(this.getRoot());
    }

    public SegmentNodeStore() {
        this(new MemoryStore());
    }

    void setMaximumBackoff(long max) {
        this.maximumBackoff = max;
    }

    private void refreshHead() {
        SegmentNodeState state = this.store.getHead();
        if (!state.getRecordId().equals(this.head.get().getRecordId())) {
            this.head.set(state);
            this.changeDispatcher.contentChanged(state.getChildNode(ROOT), null);
        }
    }

    @Override
    public Closeable addObserver(Observer observer) {
        return this.changeDispatcher.addObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public NodeState getRoot() {
        if (this.commitSemaphore.tryAcquire()) {
            try {
                this.refreshHead();
            }
            finally {
                this.commitSemaphore.release();
            }
        }
        return this.head.get().getChildNode(ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nullable CommitInfo info) throws CommitFailedException {
        Preconditions.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        Preconditions.checkNotNull((Object)commitHook);
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        this.commitSemaphore.acquire();
        try {
            Commit commit = new Commit(snb, commitHook, info);
            NodeState merged = commit.execute();
            snb.reset(merged);
            NodeState nodeState = merged;
            this.commitSemaphore.release();
            return nodeState;
        }
        catch (Throwable throwable) {
            try {
                this.commitSemaphore.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new CommitFailedException("Segment", 2, "Merge interrupted", e);
            }
        }
    }

    @Override
    @Nonnull
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        NodeState root = this.getRoot();
        SegmentNodeState before = snb.getBaseState();
        if (!Record.fastEquals((Record)before, (Object)root)) {
            SegmentNodeState after = snb.getNodeState();
            snb.reset(root);
            after.compareAgainstBaseState(before, new ConflictAnnotatingRebaseDiff(snb));
        }
        return snb.getNodeState();
    }

    @Override
    @Nonnull
    public NodeState reset(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        NodeState root = this.getRoot();
        snb.reset(root);
        return root;
    }

    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        return this.store.getTracker().getWriter().writeStream(stream);
    }

    @Override
    public Blob getBlob(@Nonnull String reference) {
        BlobStore blobStore = this.store.getBlobStore();
        if (blobStore != null) {
            String blobId = blobStore.getBlobId(reference);
            if (blobId != null) {
                return this.store.readBlob(blobId);
            }
            return null;
        }
        throw new IllegalStateException("Attempt to read external blob with blobId [" + reference + "] " + "without specifying BlobStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public synchronized String checkpoint(long lifetime) {
        Preconditions.checkArgument((lifetime > 0L ? 1 : 0) != 0);
        String name = UUID.randomUUID().toString();
        long now = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            if (!this.commitSemaphore.tryAcquire()) continue;
            try {
                this.refreshHead();
                this.store.getTracker().getWriter().flush();
                SegmentNodeState state = this.head.get();
                SegmentNodeBuilder builder = state.builder();
                NodeBuilder checkpoints = builder.child("checkpoints");
                for (String n : checkpoints.getChildNodeNames()) {
                    NodeBuilder cp = checkpoints.getChildNode(n);
                    PropertyState ts = cp.getProperty("timestamp");
                    if (ts != null && ts.getType() == Type.LONG && now <= ts.getValue(Type.LONG)) continue;
                    cp.remove();
                }
                NodeBuilder cp = checkpoints.child(name);
                cp.setProperty("timestamp", now + lifetime);
                cp.setChildNode(ROOT, state.getChildNode(ROOT));
                SegmentNodeState newState = builder.getNodeState();
                this.store.getTracker().getWriter().flush();
                if (!this.store.setHead(state, newState)) continue;
                this.refreshHead();
                String string = name;
                return string;
            }
            finally {
                this.commitSemaphore.release();
            }
        }
        return name;
    }

    @Override
    @CheckForNull
    public NodeState retrieve(@Nonnull String checkpoint) {
        NodeState cp = this.head.get().getChildNode("checkpoints").getChildNode(checkpoint).getChildNode(ROOT);
        if (cp.exists()) {
            return cp;
        }
        return null;
    }

    private class Commit {
        private final Random random = new Random();
        private SegmentNodeState before;
        private SegmentNodeState after;
        private final CommitHook hook;
        private final CommitInfo info;

        Commit(@Nonnull SegmentNodeBuilder builder, @Nonnull CommitHook hook, CommitInfo info) {
            Preconditions.checkNotNull((Object)builder);
            this.before = builder.getBaseState();
            this.after = builder.getNodeState();
            this.hook = (CommitHook)Preconditions.checkNotNull((Object)hook);
            this.info = (CommitInfo)Preconditions.checkNotNull((Object)info);
        }

        private boolean setHead(SegmentNodeBuilder builder) {
            SegmentNodeState before = builder.getBaseState();
            SegmentNodeState after = builder.getNodeState();
            SegmentNodeStore.this.refreshHead();
            if (SegmentNodeStore.this.store.setHead(before, after)) {
                SegmentNodeStore.this.head.set(after);
                SegmentNodeStore.this.changeDispatcher.contentChanged(after.getChildNode(SegmentNodeStore.ROOT), this.info);
                SegmentNodeStore.this.refreshHead();
                return true;
            }
            return false;
        }

        private SegmentNodeBuilder prepare() throws CommitFailedException {
            SegmentNodeState state = (SegmentNodeState)SegmentNodeStore.this.head.get();
            SegmentNodeBuilder builder = state.builder();
            if (Record.fastEquals((Record)this.before, (Object)state.getChildNode(SegmentNodeStore.ROOT))) {
                builder.setChildNode(SegmentNodeStore.ROOT, this.hook.processCommit(this.before, this.after, this.info));
            } else {
                ConflictAnnotatingRebaseDiff diff = new ConflictAnnotatingRebaseDiff(builder.child(SegmentNodeStore.ROOT));
                this.after.compareAgainstBaseState(this.before, diff);
                builder.setChildNode(SegmentNodeStore.ROOT, this.hook.processCommit(builder.getBaseState().getChildNode(SegmentNodeStore.ROOT), builder.getNodeState().getChildNode(SegmentNodeStore.ROOT), this.info));
            }
            return builder;
        }

        private long optimisticMerge() throws CommitFailedException, InterruptedException {
            long timeout = 1L;
            for (long backoff = 1L; backoff < SegmentNodeStore.this.maximumBackoff; backoff *= 2L) {
                SegmentNodeBuilder builder;
                long start = System.nanoTime();
                SegmentNodeStore.this.refreshHead();
                SegmentNodeState state = (SegmentNodeState)SegmentNodeStore.this.head.get();
                if ((!state.hasProperty("token") || state.getLong("timeout") < System.currentTimeMillis()) && this.setHead(builder = this.prepare())) {
                    return -1L;
                }
                Thread.sleep(backoff, this.random.nextInt(1000000));
                long stop = System.nanoTime();
                if (stop - start <= timeout) continue;
                timeout = stop - start;
            }
            return TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.NANOSECONDS);
        }

        private void pessimisticMerge(long timeout) throws CommitFailedException, InterruptedException {
            while (true) {
                long now = System.currentTimeMillis();
                SegmentNodeState state = (SegmentNodeState)SegmentNodeStore.this.head.get();
                if (state.hasProperty("token") && state.getLong("timeout") >= now) {
                    Thread.sleep(Math.min(state.getLong("timeout") - now, 1000L), this.random.nextInt(1000000));
                    continue;
                }
                SegmentNodeBuilder builder = state.builder();
                builder.setProperty("token", UUID.randomUUID().toString());
                builder.setProperty("timeout", now + timeout);
                if (!this.setHead(builder)) continue;
                builder = this.prepare();
                builder.removeProperty("token");
                builder.removeProperty("timeout");
                if (this.setHead(builder)) break;
            }
        }

        @Nonnull
        NodeState execute() throws CommitFailedException, InterruptedException {
            long timeout;
            if (!Record.fastEquals((Record)this.before, this.after) && (timeout = this.optimisticMerge()) >= 0L) {
                this.pessimisticMerge(timeout);
            }
            return ((SegmentNodeState)SegmentNodeStore.this.head.get()).getChildNode(SegmentNodeStore.ROOT);
        }
    }
}

