/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;

public class FileBlob
implements Blob {
    private final String path;

    public FileBlob(String path) {
        this.path = path;
    }

    @Override
    public String getReference() {
        return this.path;
    }

    @Override
    public String getContentIdentity() {
        return null;
    }

    @Override
    @Nonnull
    public InputStream getNewStream() {
        try {
            return new FileInputStream(this.getFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long length() {
        return this.getFile().length();
    }

    private File getFile() {
        return new File(this.path);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileBlob) {
            FileBlob other = (FileBlob)obj;
            return this.path.equals(other.path);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

