/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public final class Utils {
    private Utils() {
    }

    @Nonnull
    static String uuidFromNode(@Nonnull NodeBuilder node) throws IllegalArgumentException {
        PropertyState p = ((NodeBuilder)Preconditions.checkNotNull((Object)node)).getProperty("jcr:uuid");
        if (p == null) {
            throw new IllegalArgumentException("Not referenceable");
        }
        return p.getValue(Type.STRING);
    }

    @Nonnull
    static String primaryTypeOf(@Nonnull NodeBuilder node) throws IllegalStateException {
        String primaryType = ((NodeBuilder)Preconditions.checkNotNull((Object)node)).getName("jcr:primaryType");
        if (primaryType == null) {
            throw new IllegalStateException("Node does not have a jcr:primaryType");
        }
        return primaryType;
    }
}

