/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Locale;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.query.SQL2Parser;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;

public class LiteralImpl
extends StaticOperandImpl {
    private final PropertyValue value;

    public LiteralImpl(PropertyValue value) {
        this.value = value;
    }

    public PropertyValue getLiteralValue() {
        return this.value;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        String type = PropertyType.nameFromValue((int)this.value.getType().tag());
        return "cast(" + this.escape() + " as " + type.toLowerCase(Locale.ENGLISH) + ')';
    }

    private String escape() {
        return SQL2Parser.escapeStringLiteral(this.value.getValue(Type.STRING));
    }

    @Override
    PropertyValue currentValue() {
        return this.value;
    }

    @Override
    int getPropertyType() {
        PropertyValue v = this.currentValue();
        return v == null ? 0 : v.getType().tag();
    }
}

