/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.fulltext;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.ast.AndImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.FullTextSearchImpl;
import org.apache.jackrabbit.oak.query.ast.LiteralImpl;
import org.apache.jackrabbit.oak.query.ast.OrImpl;
import org.apache.jackrabbit.util.Text;

public class SimpleExcerptProvider {
    private static final String REP_EXCERPT_FN = "rep:excerpt(.)";
    private static int maxFragmentSize = 150;

    public static String getExcerpt(String path, String columnName, Query query, boolean highlight) {
        if (path == null) {
            return null;
        }
        Tree t = query.getTree(path);
        if (t == null || !t.exists()) {
            return null;
        }
        if ((columnName = SimpleExcerptProvider.extractExcerptProperty(columnName)) != null && columnName.contains("/")) {
            for (String p : PathUtils.elements((String)PathUtils.getParentPath((String)columnName))) {
                if (t.hasChild(p)) {
                    t = t.getChild(p);
                    continue;
                }
                return null;
            }
            columnName = PathUtils.getName((String)columnName);
        }
        StringBuilder text = new StringBuilder();
        String separator = "";
        for (PropertyState propertyState : t.getProperties()) {
            if (propertyState.getType().tag() != Type.STRING.tag() || columnName != null && !columnName.equalsIgnoreCase(propertyState.getName())) continue;
            text.append(separator);
            separator = " ";
            for (String v : propertyState.getValue(Type.STRINGS)) {
                text.append(v);
            }
        }
        Set<String> searchToken = SimpleExcerptProvider.extractFulltext(query);
        if (highlight && searchToken != null) {
            String string = SimpleExcerptProvider.highlight(text, searchToken);
            return string;
        }
        return SimpleExcerptProvider.noHighlight(text);
    }

    private static String extractExcerptProperty(String column) {
        if (REP_EXCERPT_FN.equalsIgnoreCase(column)) {
            return null;
        }
        return column.substring(column.indexOf("(") + 1, column.indexOf(")"));
    }

    private static Set<String> extractFulltext(Query q) {
        if (q instanceof QueryImpl) {
            return SimpleExcerptProvider.extractFulltext(((QueryImpl)q).getConstraint());
        }
        return ImmutableSet.of();
    }

    private static Set<String> extractFulltext(ConstraintImpl c) {
        FullTextSearchImpl f;
        HashSet<String> tokens = new HashSet<String>();
        if (c instanceof FullTextSearchImpl && (f = (FullTextSearchImpl)c).getFullTextSearchExpression() instanceof LiteralImpl) {
            LiteralImpl l = (LiteralImpl)f.getFullTextSearchExpression();
            tokens.add(l.getLiteralValue().getValue(Type.STRING));
        }
        if (c instanceof AndImpl) {
            AndImpl a = (AndImpl)c;
            tokens.addAll(SimpleExcerptProvider.extractFulltext(a.getConstraint1()));
            tokens.addAll(SimpleExcerptProvider.extractFulltext(a.getConstraint2()));
        }
        if (c instanceof OrImpl) {
            OrImpl o = (OrImpl)c;
            tokens.addAll(SimpleExcerptProvider.extractFulltext(o.getConstraint1()));
            tokens.addAll(SimpleExcerptProvider.extractFulltext(o.getConstraint2()));
        }
        return tokens;
    }

    private static Set<String> tokenize(Set<String> in) {
        HashSet<String> tokens = new HashSet<String>();
        for (String s : in) {
            tokens.addAll(SimpleExcerptProvider.tokenize(s));
        }
        return tokens;
    }

    private static Set<String> tokenize(String in) {
        int length;
        HashSet<String> out = new HashSet<String>();
        StringBuilder token = new StringBuilder();
        boolean quote = false;
        block4: for (int i = 0; i < in.length(); i += length) {
            int c = in.codePointAt(i);
            length = Character.charCount(c);
            switch (c) {
                case 32: {
                    if (quote) {
                        token.append(' ');
                        continue block4;
                    }
                    if (token.length() <= 0) continue block4;
                    out.add(token.toString());
                    token = new StringBuilder();
                    continue block4;
                }
                case 34: 
                case 39: {
                    if (quote) {
                        quote = false;
                        if (token.length() <= 0) continue block4;
                        out.add(token.toString());
                        token = new StringBuilder();
                        continue block4;
                    }
                    quote = true;
                    continue block4;
                }
                default: {
                    token.append(new String(Character.toChars(c)));
                }
            }
        }
        if (token.length() > 0) {
            out.add(token.toString());
        }
        return out;
    }

    private static String noHighlight(StringBuilder text) {
        if (text.length() > maxFragmentSize) {
            int lastSpace = text.lastIndexOf(" ", maxFragmentSize);
            if (lastSpace != -1) {
                text.setLength(lastSpace);
            } else {
                text.setLength(maxFragmentSize);
            }
            text.append(" ...");
        }
        StringBuilder excerpt = new StringBuilder("<div><span>");
        excerpt.append(Text.encodeIllegalXMLCharacters((String)text.toString()));
        excerpt.append("</span></div>");
        return excerpt.toString();
    }

    private static String highlight(StringBuilder text, Set<String> searchToken) {
        Set<String> tokens = SimpleExcerptProvider.tokenize(searchToken);
        text = new StringBuilder(Text.encodeIllegalXMLCharacters((String)text.toString()));
        for (String token : tokens) {
            text = SimpleExcerptProvider.replaceAll(text, token, "<strong>", "</strong>");
        }
        StringBuilder excerpt = new StringBuilder("<div><span>");
        excerpt.append(text.toString());
        excerpt.append("</span></div>");
        return excerpt.toString();
    }

    private static StringBuilder replaceAll(StringBuilder in, String token, String start, String end) {
        boolean isLike = false;
        if (token.endsWith("*")) {
            token = token.substring(0, token.length() - 1);
            isLike = true;
        }
        int index = in.indexOf(token);
        while (index != -1) {
            int endIndex = index + token.length();
            if (isLike) {
                int nextSpace = in.indexOf(" ", endIndex);
                endIndex = nextSpace != -1 ? nextSpace : in.length();
            }
            String current = in.substring(index, endIndex);
            StringBuilder newToken = new StringBuilder(start);
            newToken.append(current);
            newToken.append(end);
            String newTokenS = newToken.toString();
            in.replace(index, index + current.length(), newTokenS);
            index = in.indexOf(token, in.lastIndexOf(newTokenS) + newTokenS.length());
        }
        return in;
    }
}

