/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.xpath;

import java.util.ArrayList;
import org.apache.jackrabbit.oak.query.SQL2Parser;
import org.apache.jackrabbit.oak.query.xpath.Selector;
import org.apache.jackrabbit.util.ISO9075;

abstract class Expression {
    static final int PRECEDENCE_OR = 1;
    static final int PRECEDENCE_AND = 2;
    static final int PRECEDENCE_CONDITION = 3;
    static final int PRECEDENCE_OPERAND = 4;

    Expression() {
    }

    public static Expression and(Expression old, Expression add) {
        if (old == null) {
            return add;
        }
        if (add == null) {
            return old;
        }
        return new AndCondition(old, add);
    }

    boolean isCondition() {
        return false;
    }

    Expression pullOrRight() {
        return this;
    }

    int getPrecedence() {
        return 4;
    }

    String getColumnAliasName() {
        return this.toString();
    }

    boolean isName() {
        return false;
    }

    static class Property
    extends Expression {
        final Selector selector;
        final String name;
        final boolean thereWasNoAt;

        Property(Selector selector, String name, boolean thereWasNoAt) {
            this.selector = selector;
            this.name = name;
            this.thereWasNoAt = thereWasNoAt;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            if (!this.selector.onlySelector) {
                buff.append(this.selector.name).append('.');
            }
            if (this.name.equals("*")) {
                buff.append('*');
            } else {
                buff.append('[').append(this.name).append(']');
            }
            return buff.toString();
        }

        @Override
        public String getColumnAliasName() {
            return this.name;
        }
    }

    static class SelectorExpr
    extends Expression {
        private final Selector selector;

        SelectorExpr(Selector selector) {
            this.selector = selector;
        }

        public String toString() {
            return this.selector.name;
        }
    }

    static class Cast
    extends Expression {
        final Expression expr;
        final String type;

        Cast(Expression expr, String type) {
            this.expr = expr;
            this.type = type;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("cast(");
            buff.append(this.expr.toString());
            buff.append(" as ").append(this.type).append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return false;
        }
    }

    static class Function
    extends Expression {
        final String name;
        final ArrayList<Expression> params = new ArrayList();

        Function(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder(this.name);
            buff.append('(');
            for (int i = 0; i < this.params.size(); ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.params.get(i).toString());
            }
            buff.append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return this.name.equals("contains") || this.name.equals("not");
        }

        @Override
        boolean isName() {
            if ("upper".equals(this.name) || "lower".equals(this.name)) {
                return this.params.get(0).isName();
            }
            return "name".equals(this.name);
        }
    }

    static class Similar
    extends Expression {
        final Expression property;
        final Expression path;

        Similar(Expression property, Expression path) {
            this.property = property;
            this.path = path;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("similar(");
            buff.append(this.property);
            buff.append(", ").append(this.path).append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return true;
        }

        @Override
        boolean isName() {
            return false;
        }
    }

    static class NativeFunction
    extends Expression {
        final String selector;
        final Expression language;
        final Expression expression;

        NativeFunction(String selector, Expression language, Expression expression) {
            this.selector = selector;
            this.language = language;
            this.expression = expression;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("native(");
            buff.append(this.selector);
            buff.append(", ").append(this.language).append(", ").append(this.expression).append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return true;
        }

        @Override
        boolean isName() {
            return false;
        }
    }

    static class Contains
    extends Expression {
        final Expression left;
        final Expression right;

        Contains(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("contains(");
            Expression l = this.left;
            if (l instanceof Property) {
                Property p = (Property)l;
                if (p.thereWasNoAt) {
                    l = new Property(p.selector, p.name + "/*", true);
                }
            }
            buff.append(l);
            buff.append(", ").append(this.right).append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return true;
        }

        @Override
        boolean isName() {
            return this.left.isName();
        }
    }

    static class AndCondition
    extends Condition {
        AndCondition(Expression left, Expression right) {
            super(left, "and", right, 2);
        }

        @Override
        AndCondition pullOrRight() {
            if (this.right instanceof OrCondition) {
                return this;
            }
            if (this.left instanceof OrCondition) {
                return new AndCondition(this.right, this.left);
            }
            if (this.right instanceof AndCondition) {
                AndCondition r2 = (AndCondition)this.right;
                r2 = r2.pullOrRight();
                AndCondition l2 = new AndCondition(this.left, r2.left);
                l2 = l2.pullOrRight();
                return new AndCondition(l2, r2.right);
            }
            if (this.left instanceof AndCondition) {
                return new AndCondition(this.right, this.left).pullOrRight();
            }
            return this;
        }
    }

    static class OrCondition
    extends Condition {
        OrCondition(Expression left, Expression right) {
            super(left, "or", right, 1);
        }

        @Override
        public String getCommonLeftPart() {
            if (this.left instanceof Condition && this.right instanceof Condition) {
                String l = ((Condition)this.left).getCommonLeftPart();
                String r = ((Condition)this.right).getCommonLeftPart();
                if (l != null && r != null && l.equals(r)) {
                    return l;
                }
            }
            return null;
        }
    }

    static class Condition
    extends Expression {
        final Expression left;
        final String operator;
        Expression right;
        final int precedence;

        Condition(Expression left, String operator, Expression right, int precedence) {
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.precedence = precedence;
        }

        @Override
        int getPrecedence() {
            return this.precedence;
        }

        public String getCommonLeftPart() {
            if (!"=".equals(this.operator)) {
                return null;
            }
            return this.left.toString();
        }

        public String toString() {
            String rightExpr;
            String leftExpr;
            boolean leftExprIsName;
            if (this.left == null) {
                leftExprIsName = false;
                leftExpr = "";
            } else {
                leftExprIsName = this.left.isName();
                leftExpr = this.left.toString();
                if (this.left.getPrecedence() < this.precedence) {
                    leftExpr = "(" + leftExpr + ")";
                }
            }
            boolean impossible = false;
            if (this.right == null) {
                rightExpr = "";
            } else {
                if (leftExprIsName && !"like".equals(this.operator)) {
                    if (!(this.right instanceof Literal)) {
                        throw new IllegalArgumentException("Can only compare a name against a string literal, not " + this.right);
                    }
                    Literal l = (Literal)this.right;
                    String raw = l.rawText;
                    String decoded = ISO9075.decode((String)raw);
                    String encoded = ISO9075.encode((String)decoded);
                    rightExpr = SQL2Parser.escapeStringLiteral(decoded);
                    if (!encoded.equalsIgnoreCase(raw)) {
                        impossible = true;
                    }
                } else {
                    rightExpr = this.right.toString();
                }
                if (this.right.getPrecedence() < this.precedence) {
                    rightExpr = "(" + this.right + ")";
                }
            }
            if (impossible) {
                return "upper(" + leftExpr + ") = 'never matches'";
            }
            return (leftExpr + " " + this.operator + " " + rightExpr).trim();
        }

        @Override
        boolean isCondition() {
            return true;
        }
    }

    static class Literal
    extends Expression {
        final String value;
        final String rawText;

        Literal(String value, String rawText) {
            this.value = value;
            this.rawText = rawText;
        }

        public static Expression newBoolean(boolean value) {
            return new Literal(String.valueOf(value), String.valueOf(value));
        }

        static Literal newNumber(String s) {
            return new Literal(s, s);
        }

        static Literal newString(String s) {
            return new Literal(SQL2Parser.escapeStringLiteral(s), s);
        }

        public String toString() {
            return this.value;
        }
    }
}

